/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.bdsync;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.bdsync.DTSConfigOperate;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;

public class BdsyncConfigPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(BdsyncConfigPlugin.class);
    private static final String ENTITY = "cbs_bdsync_config";
    private static final String SAVE_BTN = "save";
    private static final String ENTITY_NUMBER_FIELD = "entitynumber";
    private static final String TARGET_ROUTE_FIELD = "targetroute";
    private static final String TIMING_SEQUENCE_FIELD = "timingsequence";
    private static final String ENABLE_FIELD = "enable";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        FormOperate form = (FormOperate)args.getSource();
        String operateKey = form.getOperateKey();
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        Object entity = model.getValue(ENTITY_NUMBER_FIELD);
        Object entityNumber = ((DynamicObject)entity).get("id");
        Object targetRoute = model.getValue(TARGET_ROUTE_FIELD);
        Object timingSequence = model.getValue(TIMING_SEQUENCE_FIELD);
        Object enable = model.getValue(ENABLE_FIELD);
        if (SAVE_BTN.equals(operateKey)) {
            String sourceRoute = EntityMetadataCache.getDataEntityType((String)((String)entityNumber)).getDBRouteKey();
            if (DB.isUseTheSameDatabase((String[])new String[]{sourceRoute, (String)targetRoute})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u8c61\u5b9e\u4f53\u6240\u5728\u7269\u7406\u5e93\u4e0e\u76ee\u6807\u4e1a\u52a1\u5e93\u5bf9\u5e94\u7684\u7269\u7406\u5e93\u76f8\u540c\uff0c\u65e0\u9700\u8fdb\u884c\u540c\u6b65\u3002", (String)"BdsyncConfigPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (operationStatus == OperationStatus.ADDNEW) {
                if (timingSequence == null && !args.cancel) {
                    model.setValue(TIMING_SEQUENCE_FIELD, (Object)"id");
                    timingSequence = "id";
                }
                if (this.isDuplicateConfig((String)entityNumber, (String)targetRoute)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u914d\u7f6e\uff0c\u8bf7\u52ff\u91cd\u590d\u65b0\u589e\u3002", (String)"BdsyncConfigPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else {
                    DTSConfigOperate.saveToDtsConfig((String)entityNumber, (String)targetRoute, (String)timingSequence, (Boolean)enable);
                }
            }
            if (operationStatus == OperationStatus.EDIT) {
                if (timingSequence == null && !args.cancel) {
                    model.setValue(TIMING_SEQUENCE_FIELD, (Object)"id");
                    timingSequence = "id";
                }
                DTSConfigOperate.saveToDtsConfig((String)entityNumber, (String)targetRoute, (String)timingSequence, (Boolean)enable);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (ENTITY_NUMBER_FIELD.equals(propertyName)) {
            Object value = model.getValue(ENTITY_NUMBER_FIELD);
            if (value == null) {
                return;
            }
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)((DynamicObject)value).getString("dentityid"));
            this.setTimingSequenceCombo(mainEntityType, true);
            this.setTargetRouteCombo(mainEntityType, true);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel dataModel = this.getModel();
        Object entityNumberValue = dataModel.getValue(ENTITY_NUMBER_FIELD);
        if (entityNumberValue != null) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)((DynamicObject)entityNumberValue).getString("dentityid"));
            this.setTimingSequenceCombo(mainEntityType, false);
            this.setTargetRouteCombo(mainEntityType, false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTITY_NUMBER_FIELD, TARGET_ROUTE_FIELD});
        }
    }

    public void afterBindData(EventObject e) {
        OperationStatus operateKey = this.getView().getFormShowParameter().getStatus();
        IDataModel dataModel = this.getModel();
    }

    private void setTargetRouteCombo(MainEntityType mainEntityType, boolean cleanCache) {
        ComboEdit targetRouteCombo = (ComboEdit)this.getControl(TARGET_ROUTE_FIELD);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        JSONArray dbInstanceList = this.getDbInstanceList();
        if (!dbInstanceList.isEmpty()) {
            for (Object instance : dbInstanceList) {
                JSONObject json = (JSONObject)instance;
                String number = (String)json.get((Object)"number");
                String name = (String)json.get((Object)"name");
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put(Lang.zh_CN.toString(), name);
                map.put(Lang.en_US.toString(), number);
                map.put(Lang.zh_TW.toString(), number);
                LocaleString localeString = LocaleString.fromMap(map);
                ComboItem item = new ComboItem(localeString, number);
                if (number.equals(mainEntityType.getDBRouteKey())) continue;
                items.add(item);
            }
        }
        targetRouteCombo.setComboItems(items);
        if (cleanCache) {
            this.getModel().setValue(TIMING_SEQUENCE_FIELD, null);
        }
    }

    private JSONArray getDbInstanceList() {
        HashMap<String, String> header = new HashMap<String, String>(16);
        header.put("Content-type", "application/json;charset=UTF-8");
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("dataCenterId", RequestContext.get().getAccountId());
        String host = System.getProperty("mc.server.url");
        JSONArray data = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)host)) {
            try {
                JSONObject jsonResponse;
                String param = JSONUtils.toString(params);
                String httpResponse = HttpClientUtils.postjson((String)(host + "/kapi/app/mc/GetDbInstanceListService"), header, (String)param);
                if (StringUtils.isNotBlank((CharSequence)httpResponse) && (jsonResponse = JSONObject.parseObject((String)httpResponse)).getInteger("errorcode") == 100) {
                    data = jsonResponse.getJSONArray("data");
                }
            }
            catch (IOException e) {
                logger.error("Failed to get Business Database. ERROR INFO: " + e);
            }
        }
        return data;
    }

    private void setTimingSequenceCombo(MainEntityType mainEntityType, boolean cleanCache) {
        ComboEdit timingSequenceCombo = (ComboEdit)this.getControl(TIMING_SEQUENCE_FIELD);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        DataEntityPropertyCollection dataEntityProperties = mainEntityType.getProperties();
        for (IDataEntityProperty dataEntityProperty : dataEntityProperties) {
            String name = dataEntityProperty.getName();
            if (name.endsWith("_id") || ORMUtil.isDbIgnoreRefBaseData((IDataEntityProperty)dataEntityProperty)) continue;
            ComboItem item = dataEntityProperty instanceof PKFieldProp ? new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e3b\u952e", (String)"DtsMappingPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0])), name) : new ComboItem(dataEntityProperty.getDisplayName(), name);
            if (dataEntityProperty instanceof DateTimeProp || dataEntityProperty instanceof LongProp || dataEntityProperty instanceof DecimalProp) {
                items.add(item);
            }
            timingSequenceCombo.setComboItems(items);
            if (!cleanCache) continue;
            this.getModel().setValue(TIMING_SEQUENCE_FIELD, null);
        }
    }

    private boolean isDuplicateConfig(String entityNumber, String targetroute) {
        QFilter entityNumberFilter = new QFilter(ENTITY_NUMBER_FIELD, "=", (Object)entityNumber);
        QFilter targetRouteFilter = new QFilter(TARGET_ROUTE_FIELD, "=", (Object)targetroute);
        DynamicObject result = QueryServiceHelper.queryOne((String)ENTITY, (String)ENTITY_NUMBER_FIELD, (QFilter[])new QFilter[]{entityNumberFilter, targetRouteFilter});
        return result != null;
    }
}

