/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.bdsync;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.bdsync.BDSyncImpl;
import kd.bos.bdsync.DBSyncStatusMsg;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import kd.bos.orm.datasync.agent.RelationTablesCache;
import kd.bos.orm.datasync.agent.TableInfo;

class StatusListDataProvider
extends ListDataProvider {
    private static final String SYNC_STATUS = "syncstatus";
    private static final String RELATION_TABLE_INFO = "relationtableinfo";
    private static final String SYNC_STATUS_UNCONFIG = "UNCONFIG";

    StatusListDataProvider() {
    }

    public DynamicObjectCollection getData(int arg0, int arg1) {
        DynamicObjectCollection rows = super.getData(arg0, arg1);
        if (rows.isEmpty()) {
            return rows;
        }
        if (!((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)SYNC_STATUS)) {
            return rows;
        }
        for (DynamicObject row : rows) {
            BDSyncImpl bdSync = new BDSyncImpl();
            String entityNumber = (String)((DynamicObject)row.get("entitynumber")).get("id");
            DBRoute targetRoute = DBRoute.of((String)((String)row.get("targetroute")));
            boolean isEnable = row.getBoolean("enable");
            if (!isEnable) {
                row.set(SYNC_STATUS, (Object)SYNC_STATUS_UNCONFIG);
            } else {
                DBSyncStatusMsg bdSyncStatusMsg = bdSync.getBDSyncStatusMsg(entityNumber, targetRoute);
                row.set(SYNC_STATUS, (Object)(bdSyncStatusMsg == null ? " " : bdSyncStatusMsg.getBdSyncStatusType()));
            }
            if (this.getRelationTableInfo(entityNumber).size() == 0) {
                RelationTablesCache.get().flushRelationTables(entityNumber);
            }
            row.set(RELATION_TABLE_INFO, (Object)this.getrelationTableList(entityNumber));
        }
        return rows;
    }

    private List<TableInfo> getRelationTableInfo(String entityNumber) {
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
        String selectSql = "SELECT FRELATIONTABLE,FRELATIONFIELD FROM T_DTS_TABLE_CONFIG JOIN T_DTS_TABLE_CONFIG_ENTRY ON T_DTS_TABLE_CONFIG.FID = T_DTS_TABLE_CONFIG_ENTRY.FID WHERE T_DTS_TABLE_CONFIG.FENTITYNUMBER=?";
        DB.query((DBRoute)DBRoute.basedata, (String)selectSql, (Object[])new Object[]{entityNumber}, resultSet -> {
            while (resultSet.next()) {
                tableInfos.add(new TableInfo(resultSet.getString("FRELATIONTABLE"), resultSet.getString("FRELATIONFIELD")));
            }
            return null;
        });
        return tableInfos;
    }

    private void saveRelationTableInfo(String entityNumber) {
        Set tableInfos = DataSyncConfigCache.get().getEntityTableInfos(entityNumber);
        String insertSql = "INSERT INTO T_DTS_TABLE_CONFIG(FID,FENTITYNUMBER) VALUES(?,?)";
        String insertEntrySql = "INSERT INTO T_DTS_TABLE_CONFIG_ENTRY(FID,FENTRYID,FSEQ,FRELATIONTABLE,FRELATIONFIELD,FCONFIGTYPE) VALUES(?,?,?,?,?,?)";
        long fid = DB.genLongId((String)"T_DTS_TABLE_CONFIG");
        Object[] params = new Object[]{fid, entityNumber};
        ArrayList<Object[]> entryParams = new ArrayList<Object[]>();
        int fseq = 1;
        for (TableInfo tableInfo : tableInfos) {
            long entryId = DB.genLongId((String)"T_DTS_TABLE_CONFIG_ENTRY");
            Object[] entryParam = new Object[]{fid, entryId, fseq, tableInfo.getTableName(), tableInfo.getRelationField(), "1"};
            entryParams.add(entryParam);
            ++fseq;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DB.execute((DBRoute)DBRoute.basedata, (String)insertSql, (Object[])params);
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertEntrySql, entryParams);
            }
            catch (Throwable throwable) {
                txHandle.markRollback();
            }
        }
    }

    private String getrelationTableList(String entityNumber) {
        List<TableInfo> tableInfos = this.getRelationTableInfo(entityNumber);
        StringBuilder tableInfosString = new StringBuilder();
        if (!tableInfos.isEmpty()) {
            for (int i = 0; i < tableInfos.size() - 1; ++i) {
                tableInfosString.append(tableInfos.get(i).getTableName()).append(", ");
            }
            tableInfosString.append(tableInfos.get(tableInfos.size() - 1).getTableName());
        }
        return tableInfosString.toString();
    }
}

