/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.dts;

import java.io.StringReader;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;

public class DtsAddressPropertiesPlugin
extends AbstractFormPlugin {
    private static final String ADDR_PROP = "addressproperties";
    private static final String DESTINATION_TYPE = "destinationtype";
    private static final String FULLTEXT = "fulltext";
    private static final String CONFIG_FORM = "dts_addr_config";
    private static final String CALL_BACK_ACTION_ID = "propertiesCallBack";
    private static final String OK_BTN = "okbtn";
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADDR_PROP});
        Button btn = (Button)this.getControl(OK_BTN);
        if (btn != null) {
            btn.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit) {
            this.showForm();
        } else if (source instanceof Button) {
            this.setReturnData();
        }
    }

    private void setReturnData() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String type = (String)view.getFormShowParameter().getCustomParam("type");
        HashMap<String, Object> retMap = new HashMap<String, Object>(4);
        Object ip = model.getValue(IP);
        Object port = model.getValue(PORT);
        if (ip == null || port == null) {
            view.showTipNotification(ResManager.loadKDString((String)"IP\u548c\u7aef\u53e3\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DtsAddressPropertiesPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return;
        }
        if (FULLTEXT.equals(type)) {
            String username = (String)model.getValue(USERNAME);
            String password = (String)model.getValue(PASSWORD);
            if (!StringUtils.isEmpty((String)username)) {
                retMap.put(USERNAME, username);
            }
            if (!StringUtils.isEmpty((String)password)) {
                retMap.put(PASSWORD, password);
            }
        }
        retMap.put(IP, ip);
        retMap.put(PORT, port);
        view.returnDataToParent(retMap);
        view.close();
    }

    private boolean matchIP(String ip) {
        String ipReg = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        Pattern ipPattern = Pattern.compile(ipReg);
        return ipPattern.matcher(ip).matches();
    }

    public void initialize() {
        super.initialize();
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String type = (String)formShowParameter.getCustomParam("type");
        if (type != null && !FULLTEXT.equals(type)) {
            view.setVisible(Boolean.valueOf(false), new String[]{USERNAME, PASSWORD});
        }
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        try {
            String properties;
            FormShowParameter formShowParameter = view.getFormShowParameter();
            String type = (String)formShowParameter.getCustomParam("type");
            if (type != null && !StringUtils.isEmpty((String)(properties = (String)formShowParameter.getCustomParam("properties")))) {
                IDataModel model = this.getModel();
                Properties prop = new Properties();
                prop.load(new StringReader(properties));
                model.setValue(IP, (Object)prop.getProperty(IP));
                model.setValue(PORT, (Object)prop.getProperty(PORT));
                model.setValue(USERNAME, (Object)prop.getProperty(USERNAME));
                String password = prop.getProperty(PASSWORD);
                if (StringUtils.isNotEmpty((String)password)) {
                    password = Encrypters.decode((String)password);
                }
                model.setValue(PASSWORD, (Object)password);
            }
        }
        catch (Exception ex) {
            throw new KDException(BosErrorCode.otherUnknow, new Object[]{"fill data error", e});
        }
    }

    private void showForm() {
        IDataModel model = this.getModel();
        String value = (String)model.getValue(DESTINATION_TYPE);
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u7c7b\u578b\u3002", (String)"DtsAddressPropertiesPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(CONFIG_FORM);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_ACTION_ID));
        fsp.setCustomParam("type", (Object)value);
        String properties = (String)model.getValue(ADDR_PROP);
        if (properties != null) {
            fsp.setCustomParam("properties", (Object)properties);
        }
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map retData = (Map)closedCallBackEvent.getReturnData();
        if (retData == null) {
            return;
        }
        switch (closedCallBackEvent.getActionId()) {
            case "propertiesCallBack": {
                this.getModel().setValue(ADDR_PROP, (Object)this.formatData(retData));
            }
        }
    }

    private String formatData(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<String, Object>> entries = map.entrySet();
        for (Map.Entry<String, Object> next : entries) {
            String key = next.getKey();
            Object value = next.getValue();
            if (PASSWORD.equals(key)) {
                value = Encrypters.encode((String)((String)value));
            }
            sb.append(next).append("=").append(value).append("\n");
        }
        return sb.toString();
    }
}

