/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.dts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dts.DtsMsgSender;
import kd.bos.dts.init.DtsSnapConfigDao;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.datasync.DtsThreadContext;

public class DtsMappingListPlugin
extends AbstractListPlugin {
    private static final String REVISE = "revise";
    private static final String updateSql = "UPDATE T_DTS_DATASYNCCONFIG SET FENABLE = 0 WHERE FID = ?";
    private static final String DTS_CONFIG_CHANGE_KEY = "dts_config_change_key";

    public void itemClick(ItemClickEvent evt) {
        IListView listview;
        ListSelectedRowCollection selectedRows;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (REVISE.equals(itemKey) && !(selectedRows = (listview = (IListView)this.getView()).getSelectedRows()).isEmpty()) {
            int size = selectedRows.size();
            ArrayList<Object[]> deleteList = new ArrayList<Object[]>(size);
            Object[] params = new Object[1];
            for (int i = 0; i < size; ++i) {
                ListSelectedRow listSelectedRow = selectedRows.get(i);
                params[0] = listSelectedRow.getPrimaryKeyValue();
                deleteList.add(params);
            }
            try (TXHandle h = TX.requiresNew();
                 DtsThreadContext dtsContext = DtsThreadContext.create();){
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)updateSql, deleteList);
                List configChanged = DtsSnapConfigDao.instance.getDtsConfigChanged();
                if (configChanged.size() == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u4fee\u590d\u7684\u6570\u636e\u3002", (String)"DtsMappingListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("repair", "true");
                configChanged.forEach(v -> {
                    map.put(DTS_CONFIG_CHANGE_KEY, (String)v);
                    DtsMsgSender.sendWithTranscation((String)"dts", (String)"kd.bos.service.dts.init_config_queue", (Map)map, (String)DBRoute.getRouteKey((DBRoute)DBRoute.basedata));
                });
                this.getView().showMessage(ResManager.loadKDString((String)"\u4fee\u590d\u542f\u52a8\u5b8c\u6210\u3002", (String)"DtsMappingListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4fee\u590d\u5931\u8d25\u3002", (String)"DtsMappingListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
        }
    }
}

