/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.dts;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dts.business.DtsBusinessTypeFactory;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;

public class DtsMappingPlugin
extends AbstractFormPlugin {
    private static final int MAX_REGIONS = Integer.parseInt(System.getProperty("dts.regions.max", "10"));
    private static final String ENTITY_NUMBER = "entitynumber";
    private static final String BUSINESS_TYPE = "businesstype";
    private static final String BUSINESS_DB = "businessdb";
    private static final String BASETABLE_BROAD = "basetablebroadcast";
    private static final String ENTITY_ID = "dentityid";
    private static final String SYNC_FIELDS = "entityfields";
    private static final String TIMING_FIELD = "timingsequence";
    private static final String OPERATE_KEY = "save";
    private static final String DESTINATION_TYPE = "destinationtype";
    private static final String REGION = "region";
    private static final String FULLTEXT = "fulltext";
    private static final String MONGODB = "Mongodb";
    private static final String HBASE = "Hbase";
    private static final Log logger = LogFactory.getLog(DtsMappingPlugin.class);
    private static final String sql = "select fdestinationtype,fregion,faddressproperties from t_dts_datasyncaddress where fdestinationtype = ?";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs propertychangedargs) {
        String[] split;
        int length;
        String regions;
        String value;
        String propertyName = propertychangedargs.getProperty().getName();
        IDataModel model = this.getModel();
        if (ENTITY_NUMBER.equals(propertyName)) {
            Object value2 = model.getValue(ENTITY_NUMBER);
            if (value2 == null) {
                return;
            }
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)((DynamicObject)value2).getString(ENTITY_ID));
            this.setComboData(mainEntityType, true);
        } else if (DESTINATION_TYPE.equals(propertyName)) {
            String destinationType = (String)model.getValue(DESTINATION_TYPE);
            this.getModel().setValue(REGION, null);
            this.setRegionCombo(destinationType, true);
        } else if (BUSINESS_TYPE.equals(propertyName)) {
            String value3 = (String)model.getValue(BUSINESS_TYPE);
            if (BASETABLE_BROAD.equals(value3)) {
                this.getModel().setValue(DESTINATION_TYPE, (Object)BUSINESS_DB);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{DESTINATION_TYPE});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{DESTINATION_TYPE});
                this.getModel().setValue(DESTINATION_TYPE, (Object)"");
            }
        } else if (REGION.equals(propertyName) && !BASETABLE_BROAD.equals(value = (String)model.getValue(BUSINESS_TYPE)) && (regions = (String)model.getValue(REGION)) != null && (length = (split = regions.split(",")).length) > 2) {
            model.setValue(REGION, (Object)split[length - 1]);
            return;
        }
    }

    private JSONArray getDbInstanceList() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/json;charset=UTF-8");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dataCenterId", RequestContext.get().getAccountId());
        String host = System.getProperty("mc.server.url");
        JSONArray data = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)host)) {
            try {
                JSONObject resp;
                String param = JSONUtils.toString(params);
                String sHttpResponse = HttpClientUtils.postjson((String)(host + "/kapi/app/mc/GetDbInstanceListService"), header, (String)param);
                if (StringUtils.isNotBlank((CharSequence)sHttpResponse) && (resp = JSONObject.parseObject((String)sHttpResponse)).getInteger("errorcode") == 100) {
                    data = resp.getJSONArray("data");
                }
            }
            catch (IOException e) {
                logger.error("DtsMappingPluging: ", (Throwable)e);
            }
        }
        return data;
    }

    private void setRegionCombo(String type, boolean init) {
        Properties properties = System.getProperties();
        ComboEdit regionCombo = (ComboEdit)this.getControl(REGION);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        Set<Object> keySet = properties.keySet();
        Iterator<Object> iterator = keySet.iterator();
        block6 : switch (type) {
            case "fulltext": {
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    if (!key.startsWith("elasticsearch.server")) continue;
                    String substring = key.substring(key.lastIndexOf(46) + 1);
                    String region = substring + "_system";
                    ComboItem item = new ComboItem(new LocaleString(region), substring);
                    items.add(item);
                }
                break;
            }
            case "Mongodb": {
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    if (!key.startsWith("nosql.storage.indexabletable.mongo.ip")) continue;
                    String region = "system";
                    ComboItem item = new ComboItem(new LocaleString(region), key.substring(key.lastIndexOf(46) + 1));
                    items.add(item);
                    break block6;
                }
                break;
            }
            case "businessdb": {
                JSONArray dbInstanceList = this.getDbInstanceList();
                if (dbInstanceList.size() <= 0) break;
                for (Object instance : dbInstanceList) {
                    JSONObject json = (JSONObject)instance;
                    String num = (String)json.get((Object)"number");
                    String name = (String)json.get((Object)"name");
                    ComboItem item = new ComboItem(new LocaleString(name), num);
                    items.add(item);
                }
                break;
            }
            case "Hbase": {
                break;
            }
        }
        DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{type}, resultSet -> {
            while (resultSet.next()) {
                String fregion = resultSet.getString("fregion");
                items.add(new ComboItem(new LocaleString(fregion), fregion));
            }
            return null;
        });
        regionCombo.setComboItems(items);
        if (!init) {
            IDataModel model = this.getModel();
            Object value = model.getValue(REGION);
            model.setValue(REGION, value);
        }
    }

    private void setComboData(MainEntityType dt, boolean cleanCache) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(TIMING_FIELD);
        MulComboEdit EntityFieldsComboEdit = (MulComboEdit)this.getControl(SYNC_FIELDS);
        DataEntityPropertyCollection ps = dt.getProperties();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ArrayList<ComboItem> EntityFieldsItems = new ArrayList<ComboItem>();
        for (IDataEntityProperty dp : ps) {
            String name = dp.getName();
            if (name.endsWith("_id") || ORMUtil.isDbIgnoreRefBaseData((IDataEntityProperty)dp)) continue;
            ComboItem item = dp instanceof PKFieldProp ? new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e3b\u952e", (String)"DtsMappingPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0])), name) : new ComboItem(dp.getDisplayName(), name);
            EntityFieldsItems.add(item);
            if (!(dp instanceof DateTimeProp) && !(dp instanceof BigIntProp) && !(dp instanceof IntegerProp) && !(dp instanceof LongProp) && !(dp instanceof DecimalProp) && !(dp instanceof DateProp)) continue;
            items.add(item);
        }
        comboEdit.setComboItems(items);
        EntityFieldsComboEdit.setComboItems(EntityFieldsItems);
        if (cleanCache) {
            this.getModel().setValue(SYNC_FIELDS, null);
            this.getModel().setValue(TIMING_FIELD, null);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        Object value = model.getValue(ENTITY_NUMBER);
        if (value == null) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)((DynamicObject)value).getString(ENTITY_ID));
        this.setComboData(mainEntityType, false);
        String destinationType = (String)model.getValue(DESTINATION_TYPE);
        if (!kd.bos.util.StringUtils.isEmpty((String)destinationType)) {
            this.setRegionCombo(destinationType, false);
        }
        this.setBusinessTypeCombo(false);
    }

    public void afterCreateNewData(EventObject e) {
        this.setBusinessTypeCombo(true);
    }

    public void setBusinessTypeCombo(boolean init) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(BUSINESS_TYPE);
        Map map = DtsBusinessTypeFactory.getAll();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            data.add(new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey()));
        }
        comboEdit.setComboItems(data);
        if (!init) {
            IDataModel model = this.getModel();
            Object value = model.getValue(BUSINESS_TYPE);
            model.setValue(BUSINESS_TYPE, value);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        FormOperate form = (FormOperate)args.getSource();
        String operateKey = form.getOperateKey();
        if (OPERATE_KEY.equals(operateKey)) {
            String[] split;
            String value = (String)model.getValue(SYNC_FIELDS);
            if (value != null && (split = value.split(",")).length - 1 > 20) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u5b57\u6bb5\u4e0d\u80fd\u9009\u62e9\u8d85\u8fc720\u4e2a\u5b57\u6bb5\u3002", (String)"DtsMappingPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            String type = (String)model.getValue(DESTINATION_TYPE);
            String region = (String)this.getModel().getValue(REGION);
            if (region != null) {
                String[] regions = region.split(",");
                if (!type.equals(BUSINESS_DB) && regions.length - 1 > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u5c0f\u8868\u5e7f\u64ad\u573a\u666f\u7c7b\u578b\u65f6\uff0c\u76ee\u6807\u5730\u5740\u4e0d\u5141\u8bb8\u9009\u62e9\u591a\u503c\u3002", (String)"DtsMappingPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else if (type.equals(BUSINESS_DB) && regions.length - 1 > MAX_REGIONS) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5c0f\u8868\u5e7f\u64ad\u573a\u666f\u7c7b\u578b\u65f6\uff0c\u76ee\u6807\u5730\u5740\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7%s\u3002", (String)"DtsMappingPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]), MAX_REGIONS));
                    args.setCancel(true);
                }
            }
        }
    }
}

