/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.dts;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bundle.BosRes;
import kd.bos.bundle.Resources;
import kd.bos.cbs.plugin.dts.common.ConfigPicker;
import kd.bos.cbs.plugin.dts.common.DtsCheckInfo;
import kd.bos.cbs.plugin.dts.common.DtsConstants;
import kd.bos.cbs.plugin.dts.common.RabbitRestTool;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.dts.DtsUtils;
import kd.bos.dts.business.DtsBusinessTypeFactory;
import kd.bos.dts.check.address.DestinationCheckerFactory;
import kd.bos.dts.check.consistence.Checker;
import kd.bos.dts.define.DestinationRuleConfig;
import kd.bos.dts.enmu.DtsDestTypeEnum;
import kd.bos.dts.init.DtsSnapConfigDao;
import kd.bos.dts.log.DateUtil;
import kd.bos.dts.log.DtsStatusQuery;
import kd.bos.dts.log.query.PageInfo;
import kd.bos.dts.service.DtsMQueueDefManager;
import kd.bos.dts.service.DtsService;
import kd.bos.dts.syncconfig.DestinationRuleConfigHelper;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.property.entryfilter.EntryFilterItemInfo;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.orm.datasync.DtsAccountPower;
import kd.bos.orm.datasync.agent.UpgraderStatus;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ThreadLocals;

public class DtsMonitorPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
DtsConstants,
TabSelectListener,
ItemClickListener,
ClickListener {
    private static final Log logger = LogFactory.getLog(DtsMonitorPlugin.class);
    private static final String PROJECT_NAME = "bos-cbs-plugin";
    private static ScheduledExecutorService ses = Executors.newScheduledThreadPool(3);
    private static final int QUERY_SIZE = 100;
    private static final int MAX_SIZE;

    private static void init() {
        ses.scheduleAtFixedRate(ThreadLifeCycleManager.wrapRunnable(() -> {
            Thread.currentThread().setName("DTSMonitor-CheckTask");
            if (DtsUtils.dtsEnable() && DtsService.isMaster()) {
                DtsMonitorPlugin.checkTask();
            }
            ThreadLocals.release();
        }), 1L, 600L, TimeUnit.SECONDS);
        ses.scheduleAtFixedRate(ThreadLifeCycleManager.wrapRunnable(() -> {
            Thread.currentThread().setName("DTSMonitor-RepairTask");
            if (DtsUtils.dtsEnable() && DtsService.isMaster()) {
                DtsMonitorPlugin.repairTask();
            }
            ThreadLocals.release();
        }), 10L, 720L, TimeUnit.SECONDS);
    }

    private static void checkTask() {
        DLock dLock = DLock.create((String)"/dlock/dts/monitor/config/check");
        if (dLock.tryLock()) {
            try {
                List accounts = DtsUtils.getAllAccountsOfCurrentEnv();
                accounts.forEach(account -> {
                    ThreadLifeCycleManager.start();
                    RequestContext context = RequestContext.create();
                    context.setAccountId(account.getAccountId());
                    context.setTenantId(account.getTenantId());
                    if (UpgraderStatus.status.isUpgradering()) {
                        return;
                    }
                    try {
                        List rets = (List)DB.query((DBRoute)DBRoute.base, (String)"SELECT dd.fentitynumber,dd.fbusinesstype,dd.fdestinationtype,dd.fregion,dcr.fid from t_dts_datasyncconfig dd left join t_dts_check_record dcr on dd.fid = dcr.fdts_config_id where dcr.fstatus = 0 or dcr.fstatus = 1", rs -> {
                            ArrayList<DtsCheckInfo> list = new ArrayList<DtsCheckInfo>(4);
                            while (rs.next()) {
                                String entitynumber = rs.getString("fentitynumber");
                                String businesstype = rs.getString("fbusinesstype");
                                String regions = rs.getString("fregion");
                                String destinationtype = rs.getString("fdestinationtype");
                                DestinationRuleConfig destinationConfig = DestinationRuleConfigHelper.getDestinationConfig((String)businesstype, (String)regions, (String)destinationtype, (String)entitynumber);
                                long checkId = rs.getLong("fid");
                                DtsCheckInfo checkInfo = new DtsCheckInfo(checkId, destinationConfig);
                                list.add(checkInfo);
                            }
                            return list;
                        });
                        rets.forEach(o -> {
                            Map check = Checker.check((DestinationRuleConfig)o.getDestinationRuleConfig());
                            String msg = (String)check.get("msg");
                            DB.execute((DBRoute)DBRoute.basedata, (String)"update t_dts_check_record set fcheck_result=?,fstatus=? where fid=?", (Object[])new Object[]{msg.length() > 200 ? msg.substring(0, 200) : msg, 2, o.getId()});
                        });
                    }
                    catch (Exception e) {
                        logger.error("DtsMonitor ConfigTask error: " + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        ThreadLifeCycleManager.end();
                    }
                });
            }
            finally {
                dLock.unlock();
            }
        }
    }

    private static void repairTask() {
        DLock dLock = DLock.create((String)"/dlock/dts/monitor/config/repair");
        if (dLock.tryLock()) {
            try {
                List accounts = DtsUtils.getAllAccountsOfCurrentEnv();
                accounts.forEach(account -> {
                    ThreadLifeCycleManager.start();
                    RequestContext context = RequestContext.create();
                    context.setAccountId(account.getAccountId());
                    context.setTenantId(account.getTenantId());
                    if (UpgraderStatus.status.isUpgradering()) {
                        return;
                    }
                    try {
                        List rets = (List)DB.query((DBRoute)DBRoute.base, (String)"SELECT dd.fentitynumber,dd.fbusinesstype,dd.fdestinationtype,dd.fregion,dcr.fid  from t_dts_datasyncconfig dd left join t_dts_check_record dcr on dd.fid = dcr.fdts_config_id where dcr.fstatus = 4 or dcr.fstatus = 5", rs -> {
                            ArrayList<DtsCheckInfo> list = new ArrayList<DtsCheckInfo>(4);
                            while (rs.next()) {
                                String entitynumber = rs.getString("fentitynumber");
                                String businesstype = rs.getString("fbusinesstype");
                                String regions = rs.getString("fregion");
                                String destinationtype = rs.getString("fdestinationtype");
                                DestinationRuleConfig destinationConfig = DestinationRuleConfigHelper.getDestinationConfig((String)businesstype, (String)regions, (String)destinationtype, (String)entitynumber);
                                long checkId = rs.getLong("fid");
                                DtsCheckInfo checkInfo = new DtsCheckInfo(checkId, destinationConfig);
                                list.add(checkInfo);
                            }
                            return list;
                        });
                        rets.forEach(o -> {
                            Map ret = Checker.checkAndRepair((DestinationRuleConfig)o.getDestinationRuleConfig());
                            DB.execute((DBRoute)DBRoute.basedata, (String)"update t_dts_check_record set fcheck_result=?,fstatus=? where fid=?", (Object[])new Object[]{Objects.equals("1", ret.get("status")) ? ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f", (String)"DtsRepairSuccess", (String)PROJECT_NAME, (Object[])new Object[0]) : ret.get("msg"), 6, o.getId()});
                        });
                    }
                    catch (Exception e) {
                        logger.error("DtsMonitor RepairTask error: " + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        ThreadLifeCycleManager.end();
                    }
                });
            }
            finally {
                dLock.unlock();
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity_status_list");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"entity_number", "toolbarap_addr_status", "toolbarap_MQ_INFO", "toolbarap_status_list", "toolbarap_exc_info", "toolbarap_check", "toolbarap_repair", "toolbarap_log_info"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "reflush_addr_status": {
                this.createConfigStatusList();
                break;
            }
            case "reflush_mq_info": {
                this.createMqInfo();
                break;
            }
            case "reflush_status_list": {
                this.createSyncStatusList();
                break;
            }
            case "check_config": {
                this.configCheck();
                break;
            }
            case "search_exc_info": {
                this.createExceptionList(1, 100);
                break;
            }
            case "repair_config": {
                this.repairConfig();
                break;
            }
            case "search_log_info": {
                this.createLogInfo();
                break;
            }
            case "reflush_check_list": {
                this.createCheckInfoList();
                break;
            }
        }
    }

    private void createLogInfo() {
        Control control = this.getView().getControl("entryentity_log_list");
        DynamicObject dynamicObject = control.getModel().getDataEntity(true);
        this.setLogInfo(dynamicObject);
        control.getView().setReturnData((Object)dynamicObject);
        control.getView().updateView();
    }

    private void setLogInfo(DynamicObject dataEntity) {
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity_log_list");
        if (!rows.isEmpty()) {
            rows.clear();
        }
        IDataModel model = this.getModel();
        String entityNumber = (String)model.getValue("combofield_log");
        String businessType = (String)model.getValue("combofield_log_type");
        if (kd.bos.util.StringUtils.isEmpty((String)entityNumber) && kd.bos.util.StringUtils.isEmpty((String)businessType)) {
            this.getView().showTipNotification(BosRes.get((String)PROJECT_NAME, (String)"DtsNoSelectSearchTerm", (String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u9879\u67e5\u8be2\u6761\u4ef6\u3002", (Object[])new Object[0]));
            return;
        }
        List maps = DtsStatusQuery.get().querySyncLog(entityNumber, businessType);
        if (CollectionUtils.isEmpty((Collection)maps)) {
            return;
        }
        for (Map map : maps) {
            try {
                DynamicObject addRow = new DynamicObject(rows.getDynamicObjectType());
                addRow.set("log_budinesstype", map.get("businesstype"));
                DtsDestTypeEnum typeEnum = DtsDestTypeEnum.from((String)((String)map.get("destination_type")));
                addRow.set("log_destinationtype", (Object)(typeEnum != null ? typeEnum.getValue() : ""));
                addRow.set("log_dts_count", map.get("dts_count"));
                addRow.set("log_dts_exception", map.get("dts_exception"));
                addRow.set("log_dts_logtype", map.get("dts_logtype"));
                addRow.set("log_dts_optype", map.get("dts_optype"));
                addRow.set("log_dts_timestap", (Object)DateUtil.utcDateToDate((String)((String)map.get("dts_timestap"))));
                addRow.set("log_entity_number", map.get("entity_number"));
                if (map.get("dts_status") != null) {
                    addRow.set("log_dts_status", (Object)Resources.get((String)PROJECT_NAME, (String)((String)map.get("dts_status")).toLowerCase(), null, (Object[])new Object[0]));
                }
                rows.add((Object)addRow);
            }
            catch (Exception e) {
                logger.error("parse error!", (Throwable)e);
            }
        }
    }

    public void createNewData(BizDataEventArgs e) {
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
        Control control = this.getView().getControl("entryentity_addr_status");
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)control.getModel().getDataEntityType());
        this.setAddrStatus(dataEntity);
        e.setDataEntity((Object)dataEntity);
    }

    private void repairConfig() {
        if (!DtsAccountPower.isAccountDtsEnable()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u672a\u542f\u7528,\u4fee\u590d\u5931\u8d25\u3002", (String)"DtsUnableRepair", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity_check_list");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length <= 0) {
            String dtsNoSelectTip = BosRes.get((String)PROJECT_NAME, (String)"DtsNoSelectTip", (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (Object[])new Object[0]);
            this.getView().showTipNotification(dtsNoSelectTip);
            return;
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity_check_list");
        int startIndex = collection.getStartRowIndex();
        try {
            DynamicObject dataEntity = (DynamicObject)collection.get(selectRows[0] - startIndex);
            long dtsConfigId = dataEntity.getLong("check_dts_id");
            boolean exist = (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select 1 from t_dts_check_record where fstatus=4 or fstatus=5", rs -> {
                if (rs.next()) {
                    return true;
                }
                return false;
            });
            if (exist) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u6b63\u5728\u4fee\u590d\u4e2d\u7684\u4efb\u52a1,\u8bf7\u7a0d\u540e\u3002", (String)"DtsConfigRepair_1", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            int status = (Integer)DB.query((DBRoute)DBRoute.basedata, (String)"select fstatus from t_dts_check_record where fdts_config_id=?", (Object[])new Object[]{dtsConfigId}, rs -> {
                if (rs.next()) {
                    return rs.getInt("fstatus");
                }
                return -1;
            });
            if (status == -1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u5148\u8fdb\u884c\u6570\u636e\u4e00\u81f4\u6027\u6821\u9a8c\u65b9\u53ef\u4fee\u590d\u3002", (String)"DtsConfigRepair_2", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            if (status == 0 || status == 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6b63\u5728\u4e00\u81f4\u6027\u6821\u9a8c\u4e2d,\u8bf7\u7a0d\u540e\u4fee\u590d\u3002", (String)"DtsConfigRepair_3", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            if (status == 4 || status == 5) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6b63\u5728\u4fee\u590d\u4e2d,\u8bf7\u7a0d\u540e\u3002", (String)"DtsConfigRepair_4", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            DtsCheckInfo checkInfo = this.getRuleConfigByCheck(dataEntity);
            long checkId = dataEntity.getLong("check_record_id");
            entryGrid.getModel().setValue("check_result", (Object)ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u5f00\u59cb", (String)"DtsStatus_1", (String)PROJECT_NAME, (Object[])new Object[0]), selectRows[0] - startIndex);
            ThreadPools.executeOnce((String)"Dts-ConfigRepair", () -> {
                DB.execute((DBRoute)DBRoute.basedata, (String)"update t_dts_check_record set fcheck_result=?,fstatus=? where fid=?", (Object[])new Object[]{ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u5f00\u59cb", (String)"DtsStatus_1", (String)PROJECT_NAME, (Object[])new Object[0]), 4, checkId});
                DLock dLock = DLock.create((String)"/dlock/dts/monitor/config/repair");
                if (dLock.tryLock()) {
                    try {
                        DB.execute((DBRoute)DBRoute.basedata, (String)"update t_dts_check_record set fcheck_result=?,fstatus=? where fid=?", (Object[])new Object[]{ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u4e2d", (String)"DtsStatus_2", (String)PROJECT_NAME, (Object[])new Object[0]), 5, checkId});
                        Map ret = Checker.checkAndRepair((DestinationRuleConfig)checkInfo.getDestinationRuleConfig());
                        DB.execute((DBRoute)DBRoute.basedata, (String)"update t_dts_check_record set fcheck_result=?,fstatus=? where fid=?", (Object[])new Object[]{Objects.equals("1", ret.get("status")) ? ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f", (String)"DtsRepairSuccess", (String)PROJECT_NAME, (Object[])new Object[0]) : ret.get("msg"), 6, checkId});
                    }
                    finally {
                        dLock.unlock();
                    }
                } else {
                    DB.execute((DBRoute)DBRoute.basedata, (String)"update t_dts_check_record set fcheck_result=?,fstatus=? where fid=?", (Object[])new Object[]{ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u5931\u8d25", (String)"DtsStatus_3", (String)PROJECT_NAME, (Object[])new Object[0]), 7, checkId});
                }
            });
        }
        catch (Exception e) {
            logger.error("dts reparir error" + e.getMessage(), (Throwable)e);
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
    }

    private void configCheck() {
        if (!DtsAccountPower.isAccountDtsEnable()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u672a\u542f\u7528,\u6821\u9a8c\u5931\u8d25\u3002", (String)"DtsUnableCheck", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity_check_list");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length < 1) {
            String dtsNoSelectTip = BosRes.get((String)PROJECT_NAME, (String)"DtsNoSelectTip", (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (Object[])new Object[0]);
            this.getView().showTipNotification(dtsNoSelectTip);
            return;
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity_check_list");
        int startIndex = collection.getStartRowIndex();
        try {
            long checkId;
            DynamicObject dataEntity = (DynamicObject)collection.get(selectRows[0] - startIndex);
            long dtsConfigId = dataEntity.getLong("check_dts_id");
            int status = (Integer)DB.query((DBRoute)DBRoute.basedata, (String)"select fstatus from t_dts_check_record where fdts_config_id=?", (Object[])new Object[]{dtsConfigId}, rs -> {
                if (rs.next()) {
                    return rs.getInt("fstatus");
                }
                return -1;
            });
            boolean exist = (Boolean)DB.query((DBRoute)DBRoute.base, (String)"select 1 from t_dts_check_record where fstatus=0 or fstatus=1", rs -> {
                if (rs.next()) {
                    return true;
                }
                return false;
            });
            if (status == 1 || status == 0 || exist) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u6b63\u5728\u6821\u9a8c\u4e2d\u7684\u4efb\u52a1,\u8bf7\u7a0d\u540e\u3002", (String)"DtsConfigCheck_1", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            if (status == 4 || status == 5) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u540c\u6b65\u914d\u7f6e\u6b63\u5728\u4fee\u590d\u4e2d,\u8bf7\u7a0d\u540e\u6821\u9a8c\u3002", (String)"DtsConfigCheck_2", (String)PROJECT_NAME, (Object[])new Object[0]));
                return;
            }
            if (status == -1) {
                checkId = ID.genLongId();
                DB.execute((DBRoute)DBRoute.basedata, (String)"insert into t_dts_check_record(fid,fdts_config_id,fcheck_result,fstatus,fcheck_time) values(?,?,?,?,now())", (Object[])new Object[]{checkId, dtsConfigId, ResManager.loadKDString((String)"\u6821\u9a8c\u5f00\u59cb", (String)"DtsStatus_4", (String)PROJECT_NAME, (Object[])new Object[0]), 0});
            } else {
                checkId = dataEntity.getLong("check_record_id");
                DB.execute((DBRoute)DBRoute.basedata, (String)"update t_dts_check_record set fcheck_result=?,fstatus=?,fcheck_time=now() where fid=?", (Object[])new Object[]{ResManager.loadKDString((String)"\u6821\u9a8c\u5f00\u59cb", (String)"DtsStatus_4", (String)PROJECT_NAME, (Object[])new Object[0]), 0, checkId});
            }
            DtsCheckInfo ruleConfigByCheck = this.getRuleConfigByCheck(dataEntity);
            entryGrid.getModel().setValue("check_result", (Object)ResManager.loadKDString((String)"\u6570\u636e\u4e00\u81f4\u6027\u6821\u9a8c\u4e2d", (String)"DtsStatus_5", (String)PROJECT_NAME, (Object[])new Object[0]), selectRows[0] - startIndex);
            ThreadPools.executeOnce((String)"Dts-ConfigCheck", () -> {
                DB.execute((DBRoute)DBRoute.basedata, (String)"update t_dts_check_record set fcheck_result=?,fstatus=? where fid=?", (Object[])new Object[]{ResManager.loadKDString((String)"\u6570\u636e\u4e00\u81f4\u6027\u6821\u9a8c\u4e2d", (String)"DtsStatus_5", (String)PROJECT_NAME, (Object[])new Object[0]), 1, checkId});
                DLock dLock = DLock.create((String)"/dlock/dts/monitor/config/check");
                if (dLock.tryLock()) {
                    try {
                        Map check = Checker.check((DestinationRuleConfig)ruleConfigByCheck.getDestinationRuleConfig());
                        String msg = (String)check.get("msg");
                        DB.execute((DBRoute)DBRoute.basedata, (String)"update t_dts_check_record set fcheck_result=?,fstatus=? where fid=?", (Object[])new Object[]{msg.length() > 200 ? msg.substring(0, 200) : msg, 2, checkId});
                    }
                    finally {
                        dLock.unlock();
                    }
                } else {
                    DB.execute((DBRoute)DBRoute.basedata, (String)"update t_dts_check_record set fcheck_result=?,fstatus=? where fid=?", (Object[])new Object[]{ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25,\u8bf7\u91cd\u8bd5", (String)"DtsStatus_6", (String)PROJECT_NAME, (Object[])new Object[0]), 3, checkId});
                }
            });
        }
        catch (Exception e) {
            logger.error("dts check error" + e.getMessage(), (Throwable)e);
            throw new KDException(BosErrorCode.bOS, new Object[]{e});
        }
    }

    private DtsCheckInfo getRuleConfigByCheck(DynamicObject dataEntity) {
        String entitynumber = dataEntity.getString("check_entity_number");
        String businesstype = dataEntity.getString("check_business_type");
        String regions = dataEntity.getString("check_region");
        String destinationtype = dataEntity.getString("check_destination_type");
        DestinationRuleConfig destinationConfig = DestinationRuleConfigHelper.getDestinationConfig((String)businesstype, (String)regions, (String)destinationtype, (String)entitynumber);
        DtsCheckInfo checkInfo = new DtsCheckInfo(destinationConfig);
        return checkInfo;
    }

    private List<Map<String, List<Object>>> buildQFilterParams(EntryQueryParam entryQueryParam) {
        LinkedList<Map<String, List<Object>>> list = new LinkedList<Map<String, List<Object>>>();
        List filterItems = entryQueryParam.getFilterItems();
        for (EntryFilterItemInfo itemInfo : filterItems) {
            LinkedHashMap map = new LinkedHashMap(3);
            map.put("FieldName", Stream.of(itemInfo.getPropName()).collect(Collectors.toList()));
            map.put("Value", Stream.of(itemInfo.getValue()).collect(Collectors.toList()));
            map.put("Compare", Stream.of(itemInfo.getCompareType()).collect(Collectors.toList()));
            list.add(map);
        }
        return list;
    }

    private void createCheckInfoList() {
        IDataModel model = this.getView().getModel();
        EntryQueryParam entryQueryParam = model.getEntryQueryParam("entryentity_check_list");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity_check_list");
        DynamicObject dynamicObject = entryGrid.getModel().getDataEntity(true);
        this.setCheckInfo(dynamicObject);
        List<Map<String, List<Object>>> maps = this.buildQFilterParams(entryQueryParam);
        entryGrid.getGridDataByDefaultFilterRow(entryQueryParam.getDefaultFilterRows());
        entryGrid.getGridDataByFilter(maps);
        entryGrid.getView().updateView("entryentity_check_list");
    }

    private void createConfigStatusList() {
        IDataModel model = this.getView().getModel();
        EntryQueryParam entryQueryParam = model.getEntryQueryParam("entryentity_addr_status");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity_addr_status");
        DynamicObject dynamicObject = entryGrid.getModel().getDataEntity(true);
        this.setAddrStatus(dynamicObject);
        List<Map<String, List<Object>>> maps = this.buildQFilterParams(entryQueryParam);
        entryGrid.getGridDataByDefaultFilterRow(entryQueryParam.getDefaultFilterRows());
        entryGrid.getGridDataByFilter(maps);
        entryGrid.getView().updateView("entryentity_addr_status");
    }

    private void createMqInfo() {
        Control control = this.getView().getControl("entryentity_mq_list");
        DynamicObject dynamicObject = control.getModel().getDataEntity(true);
        this.setMQInfo(dynamicObject);
        control.getView().setReturnData((Object)dynamicObject);
        control.getView().updateView();
    }

    private void createSyncStatusList() {
        IDataModel model = this.getView().getModel();
        EntryQueryParam entryQueryParam = model.getEntryQueryParam("entryentity_status_list");
        Control control = this.getView().getControl("entryentity_status_list");
        DynamicObject dynamicObject = control.getModel().getDataEntity(true);
        this.setStatusList(dynamicObject);
        control.getView().updateView("entryentity_status_list");
    }

    private void createExceptionList(int page, int size) {
        Control control = this.getView().getControl("entryentity_exc_list");
        IDataModel model = this.getModel();
        String entityNumber = (String)model.getValue("combofield_exc");
        String businessType = (String)model.getValue("combofield_exc_type");
        DateRangeEdit headFieldEdit = (DateRangeEdit)this.getView().getControl("exc_data_range");
        Date beginDate = (Date)this.getModel().getValue(headFieldEdit.getStartDateFieldKey());
        Date endDate = (Date)this.getModel().getValue(headFieldEdit.getEndDateFieldKey());
        DynamicObject dynamicObject = control.getModel().getDataEntity(true);
        this.setStatusException(dynamicObject, entityNumber, businessType, beginDate, endDate, page, size);
        this.setComboValue();
        control.getView().setReturnData((Object)dynamicObject);
        control.getView().updateView();
    }

    private void setComboValue() {
        ComboEdit numnerCombo = (ComboEdit)this.getView().getControl("combofield_exc");
        Set entityNumberSet = DtsSnapConfigDao.instance.getEntityNumberSet();
        ArrayList itemList = new ArrayList(8);
        entityNumberSet.forEach(v -> {
            ComboItem item = new ComboItem(new LocaleString(v), v);
            itemList.add(item);
        });
        numnerCombo.setComboItems(itemList);
        ComboEdit typeCombo = (ComboEdit)this.getView().getControl("combofield_exc_type");
        Map mp = DtsBusinessTypeFactory.getAll();
        if (CollectionUtils.isEmpty((Map)mp)) {
            return;
        }
        ArrayList list = new ArrayList(5);
        mp.forEach((k, v) -> list.add(new ComboItem(new LocaleString(k), k)));
        typeCombo.setComboItems(list);
    }

    private void setLogComboValue() {
        Set entityNumberSet = DtsSnapConfigDao.instance.getEntityNumberSet();
        ArrayList itemList = new ArrayList(8);
        entityNumberSet.forEach(v -> {
            ComboItem item = new ComboItem(new LocaleString(v), v);
            itemList.add(item);
        });
        ComboEdit logCombo = (ComboEdit)this.getView().getControl("combofield_log");
        logCombo.setComboItems(itemList);
        ComboEdit typeCombo = (ComboEdit)this.getView().getControl("combofield_log_type");
        Map mp = DtsBusinessTypeFactory.getAll();
        if (CollectionUtils.isEmpty((Map)mp)) {
            return;
        }
        ArrayList list = new ArrayList(5);
        mp.forEach((k, v) -> list.add(new ComboItem(new LocaleString(k), k)));
        typeCombo.setComboItems(list);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("tab_addr_status".equals(tabKey)) {
            this.createConfigStatusList();
        } else if ("tab_status_list".equals(tabKey)) {
            this.createSyncStatusList();
        } else if ("tab_mq_list".equals(tabKey)) {
            this.createMqInfo();
        } else if ("tab_exception".equals(tabKey)) {
            this.createExceptionList(1, 100);
        } else if ("tab_check_repair".equals(tabKey)) {
            this.createCheckInfoList();
        } else if ("tab_log".equals(tabKey)) {
            this.setLogComboValue();
        }
    }

    private void setCheckInfo(DynamicObject dataEntity) {
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity_check_list");
        if (!rows.isEmpty()) {
            rows.clear();
        }
        DB.query((DBRoute)DBRoute.basedata, (String)"SELECT dd.fid,dd.fentitynumber,dd.fbusinesstype,dd.fdestinationtype,dd.fregion,dcr.fcheck_time,dcr.fcheck_result,dcr.fid as fcheck_record_id FROM T_DTS_DATASYNCCONFIG as dd left join t_dts_check_record as dcr  on dd.fid=dcr.fdts_config_id WHERE dd.fenable='1' and dd.fdestinationtype in ('fulltext') order by dd.fid", resultSet -> {
            int i = 1;
            while (resultSet.next()) {
                DynamicObject addRow = new DynamicObject(rows.getDynamicObjectType());
                addRow.set("check_entity_number", (Object)resultSet.getString("fentitynumber"));
                addRow.set("check_destination_type", (Object)resultSet.getString("fdestinationtype"));
                addRow.set("check_destination_name", (Object)DtsDestTypeEnum.from((String)resultSet.getString("fdestinationtype")).getValue());
                addRow.set("check_business_type", (Object)resultSet.getString("fbusinesstype"));
                addRow.set("check_business_name", (Object)resultSet.getString("fbusinesstype"));
                addRow.set("check_region", (Object)resultSet.getString("fregion").replaceAll(",", ""));
                addRow.set("check_entity_name", (Object)DtsUtils.getDisplayNameLocaleValue((String)addRow.getString("check_entity_number")));
                addRow.set("check_result", (Object)resultSet.getString("fcheck_result"));
                if (resultSet.getTimestamp("fcheck_time") != null) {
                    addRow.set("check_time", (Object)resultSet.getTimestamp("fcheck_time"));
                }
                addRow.set("check_dts_id", (Object)resultSet.getLong("fid"));
                addRow.set("check_record_id", (Object)resultSet.getLong("fcheck_record_id"));
                addRow.set("seq", (Object)i);
                ++i;
                rows.add((Object)addRow);
            }
            return rows;
        });
    }

    private void setAddrStatus(DynamicObject dataEntity) {
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity_addr_status");
        if (!rows.isEmpty()) {
            rows.clear();
        }
        DB.query((DBRoute)DBRoute.basedata, (String)"SELECT fentitynumber,fbusinesstype,fdestinationtype,fregion,fenable,fmappingrule FROM T_DTS_DATASYNCCONFIG", resultSet -> {
            int i = 1;
            while (resultSet.next()) {
                DynamicObject addRow = new DynamicObject(rows.getDynamicObjectType());
                addRow.set("entitynumber", (Object)resultSet.getString("fentitynumber"));
                addRow.set("mappingrule", (Object)resultSet.getString("fmappingrule"));
                addRow.set("destinationtype", (Object)resultSet.getString("fdestinationtype"));
                addRow.set("destinationtype_name", (Object)DtsDestTypeEnum.from((String)resultSet.getString("fdestinationtype")).getValue());
                addRow.set("businesstype", (Object)resultSet.getString("fbusinesstype"));
                addRow.set("businesstype_name", (Object)resultSet.getString("fbusinesstype"));
                addRow.set("regions", (Object)resultSet.getString("fregion").replaceAll(",", ""));
                addRow.set("enable", (Object)(resultSet.getBoolean("fenable") ? ResManager.loadKDString((String)"\u662f", (String)"DtsAddressEnable", (String)PROJECT_NAME, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"DtsAddressDisable", (String)PROJECT_NAME, (Object[])new Object[0])));
                addRow.set("entityname", (Object)DtsUtils.getDisplayNameLocaleValue((String)addRow.getString("entitynumber")));
                String region = addRow.getString("regions");
                String desttype = resultSet.getString("fdestinationtype");
                if (DestinationCheckerFactory.getChecker((String)desttype, (String)region).isAvailable()) {
                    addRow.set("regionstatus", (Object)ResManager.loadKDString((String)"\u6b63\u5e38", (String)"DtsRegionStatusNormal", (String)PROJECT_NAME, (Object[])new Object[0]));
                } else {
                    addRow.set("regionstatus", (Object)ResManager.loadKDString((String)"\u5f02\u5e38", (String)"DtsRegionStatusAbnormal", (String)PROJECT_NAME, (Object[])new Object[0]));
                    addRow.set("regionstatusdesc", (Object)DestinationCheckerFactory.getChecker((String)desttype, (String)region).getLastCheckInfo());
                }
                addRow.set("seq", (Object)i);
                ++i;
                rows.add((Object)addRow);
            }
            return rows;
        });
    }

    private void setStatusList(DynamicObject dataEntity) {
        List configStatusList = DtsStatusQuery.get().getConfigStatusList();
        if (CollectionUtils.isEmpty((Collection)configStatusList)) {
            return;
        }
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity_status_list");
        if (!rows.isEmpty()) {
            rows.clear();
        }
        int i = 1;
        for (Map mp : configStatusList) {
            try {
                DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
                newRow.set("entity_number", mp.get("entity_number"));
                newRow.set("entity_name", (Object)DtsUtils.getDisplayNameLocaleValue((String)String.valueOf(mp.get("entity_number"))));
                newRow.set("destination_type", mp.get("destination_type"));
                newRow.set("destination_type_name", (Object)DtsDestTypeEnum.from((String)String.valueOf(mp.get("destination_type"))).getValue());
                newRow.set("region", mp.get("region"));
                newRow.set("dts_timestap", (Object)DateUtil.utcDateToDate((String)String.valueOf(mp.get("dts_timestap"))));
                newRow.set("business_type", mp.get("businesstype"));
                newRow.set("business_type_name", (Object)String.valueOf(mp.get("businesstype")));
                String dtsStatus = mp.get("dts_status") + "";
                if (StringUtils.isNotBlank((CharSequence)dtsStatus)) {
                    newRow.set("dts_status_description", (Object)ResManager.loadKDString((String)Resources.get((String)PROJECT_NAME, (String)String.valueOf(mp.get("dts_status")), null, (Object[])new Object[0]), (String)String.valueOf(mp.get("dts_status")), (String)PROJECT_NAME, (Object[])new Object[0]));
                }
                newRow.set("dts_tps", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"DtsLookDetail", (String)PROJECT_NAME, (Object[])new Object[0]));
                newRow.set("seq", (Object)i);
                ++i;
                rows.add((Object)newRow);
            }
            catch (Exception e) {
                logger.error("Unparseable date: ", (Throwable)e);
            }
        }
    }

    private void setStatusException(DynamicObject dataEntity, String entityNumber, String businessType, Date beginDate, Date endDate, int page, int size) {
        PageInfo pageInfo;
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity_exc_list");
        if (!rows.isEmpty()) {
            rows.clear();
        }
        if (CollectionUtils.isEmpty((Collection)(pageInfo = DtsStatusQuery.get().queryStatusExceptionList(RequestContext.get().getAccountId(), entityNumber, businessType, beginDate, endDate, page - 1, size)).getList())) {
            return;
        }
        this.setRows(rows, pageInfo.getList());
        long total = pageInfo.getTotal();
        int count = 0;
        if (total >= (long)MAX_SIZE) {
            count = MAX_SIZE / 100 - 1;
            total = MAX_SIZE;
        } else {
            count = (int)(total / (long)size);
        }
        for (int i = 1; i <= count; ++i) {
            pageInfo = DtsStatusQuery.get().queryStatusExceptionList(RequestContext.get().getAccountId(), entityNumber, businessType, beginDate, endDate, i * size, size);
            this.setRows(rows, pageInfo.getList());
        }
        rows.setRowCount((int)total);
    }

    private void setRows(DynamicObjectCollection rows, List<Map<String, String>> list) {
        for (Map<String, String> mp : list) {
            try {
                DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
                newRow.set("exc_entity_number", (Object)mp.get("entity_number"));
                newRow.set("exc_entity_name", (Object)DtsUtils.getDisplayNameLocaleValue((String)mp.get("entity_number")));
                newRow.set("exc_destination_type", (Object)DtsDestTypeEnum.from((String)mp.get("destination_type")).getValue());
                newRow.set("exc_region", (Object)mp.get("region"));
                newRow.set("exc_dts_timestap", (Object)DateUtil.utcDateToDate((String)mp.get("dts_timestap")));
                newRow.set("exc_businesstype", (Object)mp.get("businesstype"));
                newRow.set("dts_exception", (Object)mp.get("dts_exception"));
                rows.add((Object)newRow);
            }
            catch (Exception e) {
                logger.error("Unparseable date: ", (Throwable)e);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        String entityNumber = (String)this.getModel().getValue("entity_number", evt.getRowIndex());
        String destinationType = (String)this.getModel().getValue("destination_type", evt.getRowIndex());
        String region = (String)this.getModel().getValue("region", evt.getRowIndex());
        String businessType = (String)this.getModel().getValue("business_type", evt.getRowIndex());
        HashMap<String, String> mp = new HashMap<String, String>(6);
        mp.put("entity_number", entityNumber);
        mp.put("destination_type", destinationType);
        mp.put("region", region);
        mp.put("business_type", businessType);
        FormShowParameter showParameter = new FormShowParameter();
        if ("entity_number".equals(fieldName)) {
            showParameter.setCustomParams(mp);
            showParameter.setFormId("dts_status_detail");
        } else if ("dts_tps".equals(fieldName)) {
            showParameter.setFormId("dts_tps_detail");
            showParameter.setCustomParams(mp);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void setMQInfo(DynamicObject dataEntity) {
        String mqType;
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity_mq_list");
        if (!rows.isEmpty()) {
            rows.clear();
        }
        if ((mqType = QueueManager.getMQType((String)"base")) != null && !mqType.equals("rabbitmq")) {
            this.getView().showTipNotification(mqType + " " + ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u3002", (String)"DtsMqUnSupprot", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        String property = System.getProperty("mq.server");
        Properties prop = new Properties();
        try (StringReader reader = new StringReader(property);){
            prop.load(reader);
        }
        catch (IOException ioException) {
            logger.error((Throwable)ioException);
        }
        String type = prop.getProperty("type");
        if ("rocketmq".equals(type)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301RocketMQ\u3002", (String)"DtsUnSupprot", (String)PROJECT_NAME, (Object[])new Object[0]));
            return;
        }
        String vhost = prop.getProperty("vhost");
        Set queueSet = DtsMQueueDefManager.getCurrentDtsQueueNames();
        for (String queueName : queueSet) {
            String realQueueName = QueueManager.getRealQueueName((String)"dts", (String)queueName);
            DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
            newRow.set("queuename", (Object)realQueueName);
            newRow.set("vhost", (Object)vhost);
            this.setQueuesConsumer(newRow, vhost, realQueueName);
            rows.add((Object)newRow);
        }
    }

    private void setQueuesConsumer(DynamicObject dynamicObject, String vhost, String name) {
        JSONObject result = this.getQueueConsume(vhost, name);
        if (result.containsKey((Object)"error") || result.getJSONArray("consumer_details").isEmpty()) {
            dynamicObject.set("consumer", (Object)BosRes.get((String)PROJECT_NAME, (String)"DtsEmpty", (String)"\u65e0", (Object[])new Object[0]));
        } else {
            JSONArray itemsArray = result.getJSONArray("consumer_details");
            ArrayList<String> consumerList = new ArrayList<String>(1);
            for (Object obj : itemsArray) {
                JSONObject detail = (JSONObject)obj;
                String tag = detail.getString("consumer_tag");
                JSONObject channel = detail.getJSONObject("channel_details");
                String ip = channel.getString("peer_host");
                String port = channel.getString("peer_port");
                consumerList.add(ip + ":" + port + "@" + tag);
            }
            dynamicObject.set("consumer", (Object)StringUtils.join((Object[])consumerList.toArray(), (String)","));
        }
        dynamicObject.set("total", (Object)result.getIntValue("messages"));
        dynamicObject.set("ready", (Object)result.getIntValue("messages_ready"));
        dynamicObject.set("unacknowledged", (Object)result.getIntValue("messages_unacknowledged"));
    }

    private JSONObject getQueueConsume(String vhost, String queName) {
        String apiUrl = "/api/queues/" + vhost + "/" + queName;
        return this.getMqInfo(apiUrl);
    }

    private JSONObject getMqInfo(String apiUrl) {
        String result;
        ConfigPicker configPicker = new ConfigPicker();
        String host = configPicker.getHost();
        String user = configPicker.getUser();
        String pwd = configPicker.getPassword();
        int webPort = Integer.parseInt(configPicker.getWebPort());
        try {
            result = RabbitRestTool.getRestfulResult(host, webPort, apiUrl, user, pwd);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqConfiguration, new Object[]{e.getMessage()});
        }
        return JSONObject.parseObject((String)result);
    }

    static {
        DtsMonitorPlugin.init();
        MAX_SIZE = Integer.parseInt(System.getProperty("dts.monitor.query.size", "3000"));
    }
}

