/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.dts;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bdsync.BDSyncImpl;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.DataCacheReader;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.datasync.agent.DataSyncConfigCache;
import kd.bos.orm.datasync.agent.RelationTablesCache;
import kd.bos.orm.datasync.agent.TableInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DtsTablesConfigPlugin
extends AbstractFormPlugin {
    private static final String ENTITY = "dts_tables_config";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String SAVE_BTN = "save";
    private static final String DELETE_ENTRY = "deleteentry";
    private static final String NEW_ENTRY = "newentry";
    private static final String ENTITY_NUMBER_FIELD = "entitynumber";
    private static final String CONFIG_TYPE_FIELD = "configtype";
    private static final String RELATION_TABLE = "relationtable";
    private static final String RELATION_FIELD = "relationfield";
    private static final String DEFAULT_CONFIG_TYPE = "1";
    private static final String MANUAL_CONFIG_TYPE = "0";
    private static final String CONFIRM_ID = "RESYNC_CONFIRM";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView formView = this.getView();
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (operationStatus.equals((Object)OperationStatus.EDIT)) {
            formView.setEnable(Boolean.valueOf(false), new String[]{ENTITY_NUMBER_FIELD});
        }
        if (operationStatus.equals((Object)OperationStatus.VIEW)) {
            formView.setVisible(Boolean.valueOf(false), new String[]{DELETE_ENTRY, NEW_ENTRY, SAVE_BTN});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String propertyName = e.getProperty().getName();
        IFormView formView = this.getView();
        IDataModel model = this.getModel();
        if (operationStatus.equals((Object)OperationStatus.ADDNEW) && ENTITY_NUMBER_FIELD.equals(propertyName) && (value = model.getValue(ENTITY_NUMBER_FIELD)) != null) {
            String entityNumber = ((DynamicObject)value).getString("id");
            if (this.isDuplicateDefaultEntity(entityNumber)) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u914d\u7f6e\u5df2\u5b58\u5728\u3002", (String)"DtsTablesConfigPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                formView.setEnable(Boolean.valueOf(false), new String[]{SAVE_BTN});
                this.clearDefaultConfig(entityNumber);
            } else {
                this.clearDefaultConfig(entityNumber);
                this.setDefaultConfig(entityNumber);
                formView.setEnable(Boolean.valueOf(true), new String[]{SAVE_BTN});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        FormOperate formOperate = (FormOperate)args.getSource();
        Map variables = formOperate.getOption().getVariables();
        String operateKey = formOperate.getOperateKey();
        Object entity = dataModel.getValue(ENTITY_NUMBER_FIELD);
        if (entity == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5b9e\u4f53\u3002", (String)"DtsTablesConfigPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject entityObject = (DynamicObject)entity;
        String entityNumber = (String)entityObject.get("id");
        String routeKey = DataCacheReader.get().getDataEntityType((String)entityObject.get("id")).getDBRouteKey();
        List<TableInfo> manualTableInfosInDB = this.getTableInfoFromDB(entityNumber);
        List<TableInfo> manualTableInfosInUI = this.getTableInfoFromUI(dataModel, false);
        List<TableInfo> tableInfosInUI = this.getTableInfoFromUI(dataModel, true);
        if (operateKey.equals(SAVE_BTN)) {
            ArrayList<String> notExistTables = this.tablesNotExist(tableInfosInUI, routeKey);
            if (!this.isComplete(tableInfosInUI)) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u8868\u548c\u5173\u8054\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DtsTablesConfigPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.hasDupliacteTable(tableInfosInUI)) {
                formView.showErrorNotification(ResManager.loadKDString((String)"\u5173\u8054\u8868\u5b58\u5728\u91cd\u590d\u3002", (String)"DtsTablesConfigPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!notExistTables.isEmpty()) {
                formView.showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5173\u8054\u8868\u4e0d\u5b58\u5728\u3002", (String)"DtsTablesConfigPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]), notExistTables.toString()));
                args.setCancel(true);
            } else if (variables.get(CONFIRM_ID) == null && this.isDifferent(manualTableInfosInDB, manualTableInfosInUI)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_ID, (IFormPlugin)this);
                formView.showConfirm(ResManager.loadKDString((String)"\u5173\u8054\u8868\u914d\u7f6e\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u91cd\u65b0\u540c\u6b65\u6570\u636e\uff1f", (String)"DtsTablesConfigPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks);
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        IDataModel dataModel = this.getModel();
        IFormView formView = this.getView();
        DynamicObject entityObject = (DynamicObject)dataModel.getValue(ENTITY_NUMBER_FIELD);
        String entityNumber = (String)entityObject.get("id");
        ArrayList<String> targetRouteList = this.getTargetRouteConfig(entityNumber);
        if (messageBoxClosedEvent.getCallBackId().equals(CONFIRM_ID) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.reBDSync(entityNumber, targetRouteList);
            formView.showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u540c\u6b65\u6570\u636e\u5b8c\u6210\u3002", (String)"DtsTablesConfigPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(CONFIRM_ID, "true");
            this.getView().invokeOperation(SAVE_BTN, operateOption);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        IFormView formView = this.getView();
        IDataModel dataModel = this.getModel();
        DynamicObject entityObject = (DynamicObject)dataModel.getValue(ENTITY_NUMBER_FIELD);
        String configType = (String)formView.getControl(ENTRY_ENTITY).getModel().getValue(CONFIG_TYPE_FIELD);
        String table = (String)formView.getControl(ENTRY_ENTITY).getModel().getValue(RELATION_TABLE);
        String routeKey = DataCacheReader.get().getDataEntityType((String)entityObject.get("id")).getDBRouteKey();
        Set tableInfos = DataSyncConfigCache.get().getDefaultTableInfosForPlugin((String)entityObject.get("id"));
        boolean tableBelongToEntity = false;
        if (tableInfos != null && !tableInfos.isEmpty()) {
            for (TableInfo tableInfo : tableInfos) {
                if (!tableInfo.getTableName().equals(table)) continue;
                tableBelongToEntity = true;
            }
        }
        if (configType.equals(DEFAULT_CONFIG_TYPE) && this.isExistTable(routeKey, table) && tableBelongToEntity) {
            formView.showErrorNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u914d\u7f6e\u9879\u4e0d\u80fd\u5220\u9664\u3002", (String)"DtsTablesConfigPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void setDefaultConfig(String entityNumber) {
        Set tableInfos = DataSyncConfigCache.get().getDefaultTableInfosForPlugin(entityNumber);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField(RELATION_TABLE, new Object[0]);
        setter.addField(RELATION_FIELD, new Object[0]);
        setter.addField(CONFIG_TYPE_FIELD, new Object[0]);
        for (TableInfo tableInfo : tableInfos) {
            setter.addRow(new Object[]{tableInfo.getTableName(), tableInfo.getRelationField(), DEFAULT_CONFIG_TYPE});
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, setter);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void clearDefaultConfig(String entityNumber) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(ENTRY_ENTITY);
        if (count > 0) {
            int[] deleteIndex = new int[count];
            for (int i = 0; i < count; ++i) {
                deleteIndex[i] = i;
            }
            model.deleteEntryRows(ENTRY_ENTITY, deleteIndex);
        }
    }

    private boolean isDuplicateDefaultEntity(String entityNumber) {
        QFilter entityNumberFilter = new QFilter(ENTITY_NUMBER_FIELD, "=", (Object)entityNumber);
        DynamicObject result = QueryServiceHelper.queryOne((String)ENTITY, (String)ENTITY_NUMBER_FIELD, (QFilter[])new QFilter[]{entityNumberFilter});
        return result != null;
    }

    private ArrayList<String> getTargetRouteConfig(String entityNumber) {
        String selectSql = "SELECT FENTITYNUMBER,FTARGETROUTE FROM T_CBS_BDSYNCCONFIG WHERE FENTITYNUMBER=?";
        ArrayList<String> targetRouteList = new ArrayList<String>();
        DB.query((DBRoute)DBRoute.basedata, (String)selectSql, (Object[])new Object[]{entityNumber}, resultSet -> {
            while (resultSet.next()) {
                targetRouteList.add(resultSet.getString("FTARGETROUTE"));
            }
            return null;
        });
        return targetRouteList;
    }

    private void reBDSync(String entityNumber, ArrayList<String> targetRouteList) {
        DataSyncConfigCache dscc = DataSyncConfigCache.get();
        RelationTablesCache.get().reloadRelationTableConfig(entityNumber);
        dscc.removeCache();
        BDSyncImpl bdSync = new BDSyncImpl();
        for (String targetRoute : targetRouteList) {
            bdSync.reSync(entityNumber, DBRoute.of((String)targetRoute));
        }
    }

    private List<TableInfo> getTableInfoFromDB(String entityNumber) {
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
        String selectSql = "SELECT FRELATIONTABLE,FRELATIONFIELD FROM T_DTS_TABLE_CONFIG JOIN T_DTS_TABLE_CONFIG_ENTRY ON T_DTS_TABLE_CONFIG.FID = T_DTS_TABLE_CONFIG_ENTRY.FID WHERE T_DTS_TABLE_CONFIG_ENTRY.FCONFIGTYPE=? AND T_DTS_TABLE_CONFIG.FENTITYNUMBER=?";
        DB.query((DBRoute)DBRoute.basedata, (String)selectSql, (Object[])new Object[]{MANUAL_CONFIG_TYPE, entityNumber}, resultSet -> {
            while (resultSet.next()) {
                tableInfos.add(new TableInfo(resultSet.getString("FRELATIONTABLE"), resultSet.getString("FRELATIONFIELD")));
            }
            return null;
        });
        return tableInfos;
    }

    private List<TableInfo> getTableInfoFromUI(IDataModel dataModel, boolean isAll) {
        DynamicObjectCollection dynamicObjectCollection = dataModel.getEntryEntity(ENTRY_ENTITY);
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            if (isAll) {
                tableInfos.add(new TableInfo(dynamicObject.getString(RELATION_TABLE), dynamicObject.getString(RELATION_FIELD)));
                continue;
            }
            if (!dynamicObject.getString(CONFIG_TYPE_FIELD).equals(MANUAL_CONFIG_TYPE)) continue;
            tableInfos.add(new TableInfo(dynamicObject.getString(RELATION_TABLE), dynamicObject.getString(RELATION_FIELD)));
        }
        return tableInfos;
    }

    private boolean isDifferent(List<TableInfo> oldTablesInfoList, List<TableInfo> newTablesInfoList) {
        boolean isDifferent = false;
        if (oldTablesInfoList.size() != newTablesInfoList.size()) {
            return true;
        }
        for (TableInfo tableInfo : oldTablesInfoList) {
            if (this.inTableInfoList(tableInfo, newTablesInfoList)) continue;
            isDifferent = true;
            break;
        }
        return isDifferent;
    }

    private boolean inTableInfoList(TableInfo tableInfo, List<TableInfo> tableInfos) {
        boolean flag = false;
        for (TableInfo temp : tableInfos) {
            if (!tableInfo.getTableName().equals(temp.getTableName()) || !tableInfo.getRelationField().equals(temp.getRelationField())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private boolean hasDupliacteTable(List<TableInfo> tableInfos) {
        HashSet<String> set = new HashSet<String>();
        for (TableInfo tableInfo : tableInfos) {
            set.add(tableInfo.getTableName());
        }
        return tableInfos.size() > set.size();
    }

    private boolean isComplete(List<TableInfo> tableInfos) {
        boolean flag = true;
        for (TableInfo tableInfo : tableInfos) {
            if (!tableInfo.getTableName().equals("") && !tableInfo.getRelationField().equals("")) continue;
            flag = false;
        }
        return flag;
    }

    private ArrayList<String> tablesNotExist(List<TableInfo> tablesInfoList, String routeKey) {
        ArrayList<String> result = new ArrayList<String>();
        for (TableInfo tableInfo : tablesInfoList) {
            if (this.isExistTable(routeKey, tableInfo.getTableName())) continue;
            result.add(tableInfo.getTableName());
        }
        return result;
    }

    private boolean isExistTable(String routeKey, String table) {
        return DB.exitsTable((DBRoute)DBRoute.of((String)routeKey), (String)table);
    }
}

