/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.fulltext.edit;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.fulltext.common.FullTextIndexCustomSyncCommon;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.base.BaseView;

public class FullTextIndexCustomSyncPlugin
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(FullTextIndexCustomSyncPlugin.class);

    public void afterBindData(EventObject e) {
        MainEntityType entityMainEntityType;
        DynamicObject dynamicObject;
        super.afterBindData(e);
        BaseView baseView = (BaseView)e.getSource();
        IDataModel dataModel = this.getModel();
        if (baseView.getFormShowParameter().getStatus().getValue() == OperationStatus.EDIT.getValue() && (dynamicObject = (DynamicObject)dataModel.getValue("entityname")) != null && (entityMainEntityType = this.getEntityMainEntityType(dynamicObject)) != null) {
            DynamicObjectCollection entryDynamicObjects = dataModel.getEntryEntity("entryentity");
            this.fillDisplayField(dataModel, entityMainEntityType);
            this.constructEntryRows(entityMainEntityType, entryDynamicObjects, false);
        }
    }

    public void propertyChanged(PropertyChangedArgs propertychangedargs) {
        MainEntityType entityMainEntityType;
        IDataModel dataModel;
        DynamicObject entityNameDO;
        if (propertychangedargs.getProperty().getName().equalsIgnoreCase("entityname") && (entityNameDO = (DynamicObject)(dataModel = this.getModel()).getValue("entityname")) != null && (entityMainEntityType = this.getEntityMainEntityType(entityNameDO)) != null) {
            this.clearPrvValue();
            this.fillDisplayField(dataModel, entityMainEntityType);
            this.fillDefaultField(dataModel, entityMainEntityType);
            this.constructEntryRows(entityMainEntityType, null, true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operationKey = afterDoOperationEventArgs.getOperateKey();
        if (operationKey.equals("save") && OperationStatus.EDIT.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            List pkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
            FullTextIndexCustomSyncCommon.removeCacheByEntityName(pkIds.get(0));
        }
    }

    private void fillDisplayField(IDataModel dataModel, MainEntityType mainEntityType) {
        String tableName = "";
        try {
            tableName = this.getTableName(mainEntityType).toUpperCase();
        }
        catch (Exception e) {
            logger.error("FullTextIndexCustomSyncPlugin#getTableName", (Throwable)e);
        }
        dataModel.setValue("tablename", (Object)tableName);
        dataModel.setValue("entitydisplayname", (Object)mainEntityType.getDisplayName());
    }

    private void fillDefaultField(IDataModel dataModel, MainEntityType mainEntityType) {
        dataModel.setValue("indexname", (Object)mainEntityType.getName());
    }

    private void clearPrvValue() {
        IDataModel dataModel = this.getModel();
        dataModel.setValue("indexname", (Object)"");
        dataModel.setValue("filtername", (Object)"");
        dataModel.setValue("filtervalue", (Object)"");
        dataModel.setValue("indextype", (Object)"");
        dataModel.setValue("isenable", (Object)Boolean.FALSE);
        this.clearPrvRows(dataModel);
    }

    private void clearPrvRows(IDataModel dataModel) {
        dataModel.deleteEntryData("entryentity");
    }

    private String getTableName(MainEntityType mainEntityType) throws Exception {
        Field field = DynamicObjectType.class.getDeclaredField("_tableName");
        this.setFieldAccessible(field);
        return (String)field.get(mainEntityType);
    }

    private void setFieldAccessible(Field field) {
        AccessibleObject[] fArray = new Field[]{field};
        AccessibleObject.setAccessible(fArray, true);
    }

    private void constructEntryRows(MainEntityType mainEntityType, DynamicObjectCollection entryDynamicObjects, boolean isEntityNamePropertyChange) {
        DynamicObjectCollection preEntryDynamicObjects = this.getEntryDynamicObjectsClone(entryDynamicObjects);
        List<String> prvFieldNames = this.getPrvFieldNames(preEntryDynamicObjects);
        Map<String, DynamicObject> prvFieldMap = this.getPrvFieldMap(preEntryDynamicObjects);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        List<String> defaultCheckFields = this.getDefaultCheckFields(mainEntityType, isEntityNamePropertyChange);
        if (properties != null) {
            this.getModel().deleteEntryData("entryentity");
            ArrayList<Integer> toLockIndexList = new ArrayList<Integer>();
            ArrayList<Integer> toDelIndexList = new ArrayList<Integer>(prvFieldNames.size());
            this.createAllNewRows(prvFieldNames, properties, toDelIndexList, toLockIndexList, defaultCheckFields);
            this.reConstructRows(prvFieldMap, toDelIndexList);
            this.lockEntryCells(toLockIndexList);
        }
    }

    private List<String> getDefaultCheckFields(MainEntityType mainEntityType, boolean isEntityNamePropertyChange) {
        if (isEntityNamePropertyChange) {
            BillEntityType billEntityType;
            ArrayList<String> defaultCheckFields = new ArrayList<String>(2);
            if (mainEntityType instanceof BasedataEntityType) {
                BasedataEntityType basedataEntityType = (BasedataEntityType)mainEntityType;
                if (StringUtils.isNotEmpty((CharSequence)basedataEntityType.getNumberProperty())) {
                    defaultCheckFields.add(basedataEntityType.getNumberProperty());
                }
                if (StringUtils.isNotEmpty((CharSequence)basedataEntityType.getNameProperty())) {
                    defaultCheckFields.add(basedataEntityType.getNameProperty());
                }
            } else if (mainEntityType instanceof BillEntityType && StringUtils.isNotEmpty((CharSequence)(billEntityType = (BillEntityType)mainEntityType).getBillNo())) {
                defaultCheckFields.add(billEntityType.getBillNo());
            }
            return defaultCheckFields;
        }
        return Collections.emptyList();
    }

    private void lockEntryCells(List<Integer> toLockIndexList) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        List list = entryGrid.getFieldEdits();
        for (FieldEdit fieldEdit : list) {
            for (int i = 0; i < rowCount; ++i) {
                if (!fieldEdit.getKey().equals("isfieldenable") && !fieldEdit.getKey().equals("esfieldname")) {
                    fieldEdit.setEnable("", false, i);
                }
                if (!toLockIndexList.contains(i) || !fieldEdit.getKey().equals("isfieldenable")) continue;
                fieldEdit.setEnable("", false, i);
            }
        }
    }

    private void createAllNewRows(List<String> prvFieldNames, DataEntityPropertyCollection properties, List<Integer> toDelIndexList, List<Integer> toLockIndexList, List<String> defaultCheckFields) {
        for (IDataEntityProperty property : properties) {
            if (!this.needToIndex(property)) continue;
            int rowIndex = this.createNewEntryRow(property, defaultCheckFields);
            if (this.isPrimaryKey(property)) {
                toLockIndexList.add(rowIndex);
            }
            if (!this.isInPrv(prvFieldNames, property)) continue;
            toDelIndexList.add(rowIndex);
        }
    }

    private void reConstructRows(Map<String, DynamicObject> prvFieldMap, List<Integer> toDelIndexList) {
        IDataModel dataModel = this.getModel();
        for (Integer delIndex : toDelIndexList) {
            DynamicObject toDelDO = dataModel.getEntryRowEntity("entryentity", delIndex.intValue());
            String key = toDelDO.getString("propertyname");
            dataModel.deleteEntryRow("entryentity", delIndex.intValue());
            DynamicObject toFillInDO = prvFieldMap.get(key);
            dataModel.createNewEntryRow("entryentity", delIndex.intValue(), toFillInDO);
        }
    }

    private DynamicObjectCollection getEntryDynamicObjectsClone(DynamicObjectCollection entryDynamicObjects) {
        return entryDynamicObjects != null ? (DynamicObjectCollection)entryDynamicObjects.clone() : null;
    }

    private int createNewEntryRow(IDataEntityProperty property, List<String> defaultCheckFields) {
        EntryProp p = (EntryProp)this.getModel().getProperty("entryentity");
        DynamicObject temp = new DynamicObject(p.getDynamicCollectionItemPropertyType());
        this.setPropertyValues(property, temp, defaultCheckFields);
        return this.getModel().createNewEntryRow("entryentity", temp);
    }

    private void setPropertyValues(IDataEntityProperty property, DynamicObject temp, List<String> defaultCheckFields) {
        temp.set("propertyname", (Object)property.getName());
        temp.set("esfieldname", (Object)property.getName());
        temp.set("fieldtype", (Object)property.getPropertyType().getSimpleName());
        if (this.isPrimaryKey(property)) {
            temp.set("propertydisplayname", (Object)"PK");
            ((BooleanProp)temp.getDynamicObjectType().getProperty("isfieldenable")).setDefValue(null);
            temp.set("isfieldenable", (Object)Boolean.TRUE);
            ((BooleanProp)temp.getDynamicObjectType().getProperty("ispk")).setDefValue(null);
            temp.set("ispk", (Object)Boolean.TRUE);
        } else {
            temp.set("propertydisplayname", (Object)property.getDisplayName());
        }
        if (defaultCheckFields.contains(property.getName())) {
            ((BooleanProp)temp.getDynamicObjectType().getProperty("isfieldenable")).setDefValue(null);
            temp.set("isfieldenable", (Object)Boolean.TRUE);
        }
    }

    private boolean isInPrv(List<String> prvFieldNames, IDataEntityProperty property) {
        return prvFieldNames != null && prvFieldNames.contains(property.getName());
    }

    private boolean needToIndex(IDataEntityProperty property) {
        return this.isTextType(property) || this.isPrimaryKey(property);
    }

    private boolean isTextType(IDataEntityProperty property) {
        return property instanceof TextProp;
    }

    private List<String> getPrvFieldNames(DynamicObjectCollection exist) {
        if (exist != null) {
            return exist.stream().map(p -> (String)p.get("propertyname")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Map<String, DynamicObject> getPrvFieldMap(DynamicObjectCollection exist) {
        if (exist != null) {
            return exist.stream().collect(Collectors.toMap(p -> (String)p.get("propertyname"), p -> p));
        }
        return Collections.emptyMap();
    }

    private MainEntityType getEntityMainEntityType(DynamicObject dynamicObject) {
        return EntityMetadataCache.getDataEntityTypeById((String)dynamicObject.getString("dentityid"));
    }

    private boolean _isPrimaryKey(IDataEntityProperty property) throws Exception {
        Field field = DynamicSimpleProperty.class.getDeclaredField("_isPrimaryKey");
        this.setFieldAccessible(field);
        return (Boolean)field.get(property);
    }

    private boolean isPrimaryKey(IDataEntityProperty property) {
        try {
            return this._isPrimaryKey(property);
        }
        catch (Exception e) {
            logger.warn("FullTextIndexCustomSyncPlugin#_isPrimaryKey err found", (Throwable)e);
            return false;
        }
    }
}

