/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.form;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.cbs.plugin.kdtx.form.DtxBranchInfo;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class DtxBranchParamFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(DtxBranchParamFormPlugin.class);
    private static final String ENTITY_NUMBER = "branchentity";
    private static final String ENTITY_FIELD_ID = "branchid";
    private static final String ENTITY_FIELD_SEQ = "branchseq";
    private static final String ENTITY_FIELD_STATUS = "branchstatus";
    private static final String ENTITY_FIELD_STARTTIME = "starttime";
    private static final String PARAMS_TAP_NUMBER = "codeeditap";
    private static final String ENTRY_COUNT = "entry_count";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int DEFAULT_MAX_SIZE = 0x100000;
    private static final String LIMIT_SIZE_KEY = "kdtx.branchRegister.download.paramsize";
    private static final int EXPIRE_TIME = 7200;
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();

    public void registerListener(EventObject e) {
        EntryGrid eg = (EntryGrid)this.getControl(ENTITY_NUMBER);
        eg.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        String xid = (String)view.getFormShowParameter().getCustomParam("xid");
        List<DtxBranchInfo> dtxBranchInfos = this.getBranchInfoByXid(xid);
        this.generateEntityList(dtxBranchInfos);
    }

    private List<DtxBranchInfo> getBranchInfoByXid(String xid) {
        String sql = "select fbranch_id as branchId, fseq as seq, fstatus as status, fcreate_time as startTime from t_cbs_dtx_branch where fxid = ?";
        ArrayList<DtxBranchInfo> dtxBranchInfos = new ArrayList<DtxBranchInfo>();
        DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{xid}, rs -> {
            while (rs.next()) {
                DtxBranchInfo dtxBranchInfo = new DtxBranchInfo();
                dtxBranchInfo.setBranchId(rs.getString("branchId"));
                dtxBranchInfo.setSeq(rs.getInt("seq"));
                dtxBranchInfo.setStatus(rs.getInt("status"));
                dtxBranchInfo.setStartTime(rs.getTimestamp("startTime"));
                dtxBranchInfos.add(dtxBranchInfo);
            }
            return null;
        });
        return dtxBranchInfos;
    }

    private void generateEntityList(List<DtxBranchInfo> dtxBranchInfos) {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTITY_NUMBER);
        for (DtxBranchInfo dtxBranchInfo : dtxBranchInfos) {
            int rowIndex = model.createNewEntryRow(ENTITY_NUMBER);
            model.setValue(ENTITY_FIELD_ID, (Object)dtxBranchInfo.getBranchId(), rowIndex);
            model.setValue(ENTITY_FIELD_SEQ, (Object)dtxBranchInfo.getSeq(), rowIndex);
            model.setValue(ENTITY_FIELD_STATUS, (Object)dtxBranchInfo.getStatus(), rowIndex);
            model.setValue(ENTITY_FIELD_STARTTIME, (Object)dtxBranchInfo.getStartTime(), rowIndex);
        }
        this.getPageCache().put(ENTRY_COUNT, String.valueOf(dtxBranchInfos.size()));
    }

    public void entryRowClick(RowClickEvent evt) {
        int maxSize;
        String branchId = (String)((EntryGrid)evt.getSource()).getModel().getValue(ENTITY_FIELD_ID);
        byte[] paramsBytes = this.getParamsBytes(branchId);
        Object params = JsonUtils.deSerialization((byte[])paramsBytes);
        String maxSizeString = System.getProperty(LIMIT_SIZE_KEY, Integer.toString(0x100000));
        int n = maxSize = StringUtils.isNumericString((String)maxSizeString) ? Integer.parseInt(maxSizeString) : 0x100000;
        if (paramsBytes.length < maxSize) {
            String jsonParams = null;
            try {
                jsonParams = OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(params);
            }
            catch (JsonProcessingException e) {
                logger.error("Serialize params object to json failed.", (Throwable)e);
            }
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl(PARAMS_TAP_NUMBER);
            codeEdit.setText(jsonParams);
        } else {
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl(PARAMS_TAP_NUMBER);
            codeEdit.setText("Parameter is too large.Please view in local json file of paramter.");
            if (!this.download(params, branchId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53c2\u6570\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"DtxBranchParamFormPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
        }
    }

    private byte[] getParamsBytes(String branchId) {
        String sql = "select fparas_bytes as paramsBytes from t_cbs_dtx_branch where fbranch_id = ?";
        return (byte[])DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{branchId}, rs -> {
            if (rs.next()) {
                return rs.getBytes("paramsBytes");
            }
            return new byte[0];
        });
    }

    private boolean download(Object params, String branchId) {
        String cacheUrl = (String)CACHE.get(branchId);
        if (StringUtils.isEmpty((String)cacheUrl)) {
            Throwable throwable;
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String tempFileName = branchId + ".json";
            File file = new File(tempFileName);
            try {
                throwable = null;
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    OBJECT_MAPPER.writeValue((OutputStream)fileOutputStream, params);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                logger.error("Serialize params object to json failed.", (Throwable)e);
                return false;
            }
            try {
                throwable = null;
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    String url = tempFileCache.saveAsUrl(tempFileName, (InputStream)fileInputStream, 7200);
                    CACHE.put(branchId, (Object)url, 7200);
                    this.getView().download(url);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Exception e) {
                logger.error("Download json file is failed.", (Throwable)e);
                return false;
            }
            return file.delete();
        }
        this.getView().download(cacheUrl);
        return true;
    }
}

