/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.list;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.kdtx.DtxCompensate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.kdtx.sdk.compensate.Compensate;
import kd.bos.kdtx.sdk.entity.BaseTxSceneInfo;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;

public class DtxSceneConfigListPlugin
extends AbstractListPlugin {
    public static final String MODIFY = "modify";
    public static final String VIEW = "view";
    public static final String BIZ_SCENES = "bos_kdtx_scenes";
    private static Compensate compensate = DtxSceneConfigListPlugin.getCompensateImpl();

    private static Compensate getCompensateImpl() {
        return new DtxCompensate();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        ListView view = (ListView)this.getView();
        if (MODIFY.equals(itemKey) || VIEW.equals(itemKey)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(BIZ_SCENES);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            String itemId = view.getSelectedRows().get(0).getPrimaryKeyValue().toString();
            fsp.setCustomParam("itemId", (Object)itemId);
            if (MODIFY.equals(itemKey)) {
                fsp.setStatus(OperationStatus.EDIT);
            } else {
                fsp.setStatus(OperationStatus.VIEW);
            }
            view.showForm(fsp);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                rows.clear();
                List list = compensate.queryTxSceneInfo();
                for (BaseTxSceneInfo sceneInfo : list) {
                    DynamicObject item = new DynamicObject(rows.getDynamicObjectType());
                    item.set("code", (Object)sceneInfo.getCode());
                    item.set("tx_desc", (Object)sceneInfo.getName());
                    item.set("app", (Object)sceneInfo.getApp());
                    item.set("remark", (Object)sceneInfo.getRemark());
                    item.set("id", (Object)sceneInfo.getId());
                    rows.add((Object)item);
                }
                return rows;
            }
        });
    }
}

