/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.reporter;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.cbs.plugin.kdtx.DtxCompensate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.kdtx.sdk.compensate.Compensate;
import kd.bos.kdtx.sdk.entity.BaseTxSceneInfo;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;

public class TXDetailReporterFormPlugin
extends AbstractReportFormPlugin {
    private static final Compensate compensate = new DtxCompensate();

    public void preOpenForm(PreOpenFormEventArgs e) {
        String entityNumber;
        Map customParams = e.getFormShowParameter().getCustomParams();
        if (!customParams.isEmpty() && !"kdtx_reporter".equals(entityNumber = (String)customParams.get("entityNumber"))) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u4ece\u5206\u5e03\u5f0f\u4e8b\u52a1\u62a5\u8868\u5165\u53e3\u8fdb\u5165\u3002", (String)"TXDetailReporterFormPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        ComboEdit txComboEdit = (ComboEdit)this.getControl("tx_scene");
        List txSceneInfoList = compensate.queryTxSceneInfo();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(txSceneInfoList.size());
        for (BaseTxSceneInfo txSceneInfo : txSceneInfoList) {
            ComboItem comboItem = new ComboItem(new LocaleString(txSceneInfo.getName()), txSceneInfo.getId());
            items.add(comboItem);
        }
        txComboEdit.setComboItems(items);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"reportfilterap"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener(hyperLinkClickEvent -> {
            IReportView reportView = this.getView();
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObject dynamicObject = ((ReportView)reportView).getReportList().getReportModel().getRowData(rowIndex);
            String xid = (String)dynamicObject.get("xid");
            ReportShowParameter reportShowParameter = new ReportShowParameter();
            reportShowParameter.setFormId("dtx_log_report");
            reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ReportQueryParam reportQueryParam = new ReportQueryParam();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.addFilterItem("search_xid", (Object)xid);
            reportQueryParam.setFilter(filterInfo);
            reportShowParameter.setQueryParam(reportQueryParam);
            reportView.showForm((FormShowParameter)reportShowParameter);
        });
    }
}

