/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.rpt;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMetaFactory;
import kd.bos.cbs.plugin.kdtx.DtxCompensate;
import kd.bos.cbs.plugin.kdtx.common.Constant;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.sdk.compensate.Compensate;
import kd.bos.kdtx.sdk.constant.BaseTxListType;
import kd.bos.kdtx.sdk.param.BaseListTxInfoParam;
import kd.bos.util.StringUtils;

public class TxListDataPlugin
extends AbstractReportListDataPlugin {
    private static Compensate compensate = TxListDataPlugin.getCompensateImpl();
    private static String[] listTxFields = new String[]{"XID", "STATUS", "TX_CREATED_TIME", "TX_SCENEID", "TASK_COMMIT_RETRY_COUNT", "TASK_ROLLBACK_RETRY_COUNT", "MAN_COMMIT_RETRY_COUNT", "MAN_ROLLBACK_RETRY_COUNT", "TX_DESC", "TX_TYPE"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        if (!Constant.isTccApp()) {
            DataType[] dataTypes = new DataType[]{DataType.StringType, DataType.IntegerType, DataType.TimestampType, DataType.LongType, DataType.IntegerType, DataType.IntegerType, DataType.IntegerType, DataType.IntegerType, DataType.StringType, DataType.StringType};
            DataSetBuilder builder = Algo.create((String)"tcc_tx_list").createDataSetBuilder(RowMetaFactory.createRowMeta((String[])listTxFields, (DataType[])dataTypes));
            return builder.build();
        }
        boolean splitPage = false;
        String xid = reportQueryParam.getFilter().getString("search_xid");
        int limitSize = reportQueryParam.getFilter().getInt("search_limit_size");
        if (limitSize > 0) {
            splitPage = true;
        }
        int txType = reportQueryParam.getFilter().getInt("search_tx_type");
        long txSceneId = reportQueryParam.getFilter().getLong("search_tx_sceneid");
        int status = reportQueryParam.getFilter().getInt("search_status");
        String secondStatusStr = reportQueryParam.getFilter().getString("search_secondstatus");
        int resultType = reportQueryParam.getFilter().getInt("search_result_type");
        String bizId = reportQueryParam.getFilter().getString("search_biz_id");
        int secondStatus = StringUtils.isEmpty((String)secondStatusStr) ? -1 : Integer.parseInt(secondStatusStr);
        Date txCreatedTimeFrom = reportQueryParam.getFilter().getDate("search_tx_created_time_f");
        Date txCreatedTimeTo = reportQueryParam.getFilter().getDate("search_tx_created_time_t");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String txCreatedTimeFromStr = null;
        String txCreatedTimeToStr = null;
        if (txCreatedTimeFrom != null) {
            txCreatedTimeFromStr = sdf.format(txCreatedTimeFrom);
        }
        if (txCreatedTimeTo != null) {
            txCreatedTimeToStr = sdf.format(txCreatedTimeTo);
        }
        BaseListTxInfoParam baseListTxInfoParam = BaseListTxInfoParam.custom().setXid(xid).setTxSceneId(txSceneId).setStatus(status).setTxCreatedTimeFrom(txCreatedTimeFromStr).setTxCreatedTimeTo(txCreatedTimeToStr).setStart(0).setLimit(limitSize).setSplitPage(splitPage).setExceptionResultType(resultType).setBaseTxListType(this.transformQueryType(reportQueryParam.getFilter().getString("PAGE_ID"))).setDtxType(this.transformDtxType(reportQueryParam.getFilter().getString("PAGE_ID"))).setTxType(txType).setBizId(bizId).setSecondStatus(secondStatus).build();
        return (DataSet)compensate.listTxInfoDataSet(baseListTxInfoParam);
    }

    private DtxType transformDtxType(String dtxType) {
        switch (dtxType) {
            case "dtx_query_report": 
            case "dtx_compensate": {
                return DtxType.TCC;
            }
            case "dtx_ec_query_report": 
            case "dtx_ec_compensate": {
                return DtxType.EC;
            }
        }
        throw new RuntimeException("invalid dtx type! type: " + dtxType);
    }

    private BaseTxListType transformQueryType(String queryType) {
        if (queryType == null) {
            return BaseTxListType.TX_ALL;
        }
        switch (queryType) {
            case "dtx_query_report": {
                return BaseTxListType.TX_ALL;
            }
            case "dtx_compensate": {
                return BaseTxListType.EXCEPTION_TX_ALL;
            }
        }
        throw new RuntimeException("invalid query type! type: " + queryType);
    }

    private static Compensate getCompensateImpl() {
        return new DtxCompensate();
    }
}

