/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.kdtx.rpt;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMetaFactory;
import kd.bos.cbs.plugin.kdtx.DtxCompensate;
import kd.bos.cbs.plugin.kdtx.common.Constant;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.kdtx.sdk.compensate.Compensate;
import kd.bos.kdtx.sdk.param.BaseListTxLogParam;

public class TxLogListDataPlugin
extends AbstractReportListDataPlugin {
    private static Compensate compensate = TxLogListDataPlugin.getCompensateImpl();
    private static String[] listlogFields = new String[]{"xid", "action_type", "branch_clazz", "branch_desc", "branch_xid", "remark", "trigger_type", "tx_desc", "start_time", "end_time", "result", "traceid"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        if (!Constant.isTccApp()) {
            DataType[] dataTypes = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.TimestampType, DataType.TimestampType, DataType.IntegerType, DataType.StringType};
            DataSetBuilder builder = Algo.create((String)"tcc_tx_log").createDataSetBuilder(RowMetaFactory.createRowMeta((String[])listlogFields, (DataType[])dataTypes));
            return builder.build();
        }
        boolean splitPage = false;
        String xid = reportQueryParam.getFilter().getString("search_xid");
        int limitSize = reportQueryParam.getFilter().getInt("search_limit_size");
        if (limitSize > 0) {
            splitPage = true;
        }
        long txSceneId = reportQueryParam.getFilter().getLong("search_tx_sceneid");
        String branchXid = reportQueryParam.getFilter().getString("search_branch_xid");
        String branchDesc = reportQueryParam.getFilter().getString("search_branch_desc");
        String branchClazz = reportQueryParam.getFilter().getString("search_branch_clazz");
        int actionType = reportQueryParam.getFilter().getInt("search_action_type");
        int triggerType = reportQueryParam.getFilter().getInt("search_trigger_type");
        int status = reportQueryParam.getFilter().getInt("search_result");
        Date startTimeFrom = reportQueryParam.getFilter().getDate("search_start_time_f");
        Date startTimeTo = reportQueryParam.getFilter().getDate("search_end_time_t");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startTimeFromStr = null;
        String startTimeToStr = null;
        if (startTimeFrom != null) {
            startTimeFromStr = sdf.format(startTimeFrom);
        }
        if (startTimeTo != null) {
            startTimeToStr = sdf.format(startTimeTo);
        }
        return (DataSet)compensate.listTxLog(new BaseListTxLogParam(xid, txSceneId, startTimeFromStr, startTimeToStr, branchXid, branchDesc, branchClazz, actionType, triggerType, status, 0, limitSize, splitPage));
    }

    private static Compensate getCompensateImpl() {
        return new DtxCompensate();
    }
}

