/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.logorm;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public class DataSourceRoute {
    public static final String master = "@master";
    private final QueryDimension queryDimension;
    private final String dataSourceKey;

    public DataSourceRoute(QueryDimension queryDimension, String dataSourceKey) {
        this.queryDimension = queryDimension;
        this.dataSourceKey = dataSourceKey;
    }

    public static DataSourceRoute of(String key) {
        QueryDimension queryDimension;
        int idx = (key = key.trim()).indexOf("#");
        if (idx < 0) {
            throw new KDException(BosErrorCode.logorm, new Object[]{"Data source monitor key parse error: " + key + '.'});
        }
        String dimension = key.substring(0, idx);
        if (QueryDimension.business.name().equalsIgnoreCase(dimension)) {
            queryDimension = QueryDimension.business;
        } else if (QueryDimension.physical.name().equalsIgnoreCase(dimension)) {
            queryDimension = QueryDimension.physical;
        } else {
            throw new KDException(BosErrorCode.logorm, new Object[]{"Data source monitor quey dimension error: " + key + '.'});
        }
        return new DataSourceRoute(queryDimension, key.substring(idx + 1));
    }

    public String toString() {
        return this.queryDimension.name() + '#' + this.dataSourceKey;
    }

    public String getDataSourceKey() {
        return this.dataSourceKey;
    }

    public QueryDimension getQueryDimension() {
        return this.queryDimension;
    }

    public boolean isMaster() {
        return master.equalsIgnoreCase(this.dataSourceKey);
    }

    public static enum QueryDimension {
        business,
        physical;

    }
}

