/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.logorm;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.logorm.config.LogORMConfig;
import kd.bos.logorm.datasource.es.ESConfig;
import kd.bos.logorm.datasource.es.ESDataSource;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class ElasticDisposableDataSource {
    private static final ConcurrentHashMap<String, RestClient> CLIENT_FACTORY = new ConcurrentHashMap();
    private final HttpHost[] hosts;
    private final String name;
    private final String np1;
    private String shardingKey;
    private final String esConfigSchema;
    private final ESConfig.ESCluster esCluster;

    public ElasticDisposableDataSource(HttpHost[] hosts, String name, String np1, String esConfigSchema, ESConfig.ESCluster esCluster) {
        this.hosts = hosts;
        this.name = name;
        this.np1 = np1;
        this.esConfigSchema = esConfigSchema;
        this.esCluster = esCluster;
    }

    private String getShardingKey() {
        if (this.shardingKey == null) {
            ArrayList<String> hostKeys = new ArrayList<String>(this.hosts.length);
            for (HttpHost host : this.hosts) {
                hostKeys.add(host.getSchemeName() + "://" + host.getHostName() + ':' + host.getPort());
            }
            hostKeys.sort(String::compareTo);
            String hostKey = String.join((CharSequence)",", hostKeys);
            this.shardingKey = hostKey + '#' + this.name;
        }
        return this.shardingKey;
    }

    public ESDataSource createDisposableDataSource() {
        String clientShardingKey = this.getShardingKey();
        RestClient restClient = CLIENT_FACTORY.computeIfAbsent(clientShardingKey, k -> {
            RestClientBuilder builder = RestClient.builder((HttpHost[])this.hosts);
            if (this.name != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.name, this.np1));
                builder.setHttpClientConfigCallback(arg_0 -> ElasticDisposableDataSource.lambda$null$0((CredentialsProvider)credentialsProvider, arg_0));
            }
            builder.setNodeSelector(NodeSelector.SKIP_DEDICATED_MASTERS);
            builder.setRequestConfigCallback(rcc -> {
                rcc.setConnectTimeout(LogORMConfig.getSocketTimeout());
                rcc.setSocketTimeout(LogORMConfig.getQueryTimeout());
                rcc.setConnectionRequestTimeout(LogORMConfig.getConnectionTimeout());
                return rcc;
            });
            return builder.build();
        });
        return new ESDataSource(restClient, null, false, this.esCluster);
    }

    public String getEsConfigSchema() {
        return this.esConfigSchema;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$null$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder rcc) {
        rcc.setDefaultCredentialsProvider(credentialsProvider);
        rcc.setMaxConnPerRoute(2);
        rcc.setMaxConnTotal(2);
        return rcc;
    }
}

