/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.logorm.reader;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cbs.plugin.logorm.ElasticMonitorQueryBuilder;
import kd.bos.cbs.plugin.logorm.utils.FormatUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logorm.client.es.monitor.CatIndicesAction;
import kd.bos.logorm.client.es.monitor.IndexInfoResponse;

public class IndexStatisticsReader {
    private final ElasticMonitorQueryBuilder queryBuilder;
    private final String indexName;
    private int count;
    private List<Object[]> rows;

    public IndexStatisticsReader(ElasticMonitorQueryBuilder queryBuilder, String indexName) {
        this.queryBuilder = queryBuilder;
        this.indexName = indexName;
    }

    public DynamicObjectCollection read(int start, int limit) {
        this.init();
        DataSet dataSet = Algo.create((String)"ElasticIndexStatisticsReader").createDataSet(this.rows, this.createRowMeta()).limit(start, limit);
        DynamicObjectType dynamicObjectType = this.queryBuilder.getContext().getDataEntityMetaProvider().getDynamicObjectType("logorm_monitor_index");
        DynamicObjectCollection result = new DynamicObjectCollection(dynamicObjectType, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            DynamicObject object = new DynamicObject(dynamicObjectType);
            object.set("index_name", (Object)row.getString("index_name"));
            object.set("row_count", (Object)row.getInteger("row_count"));
            object.set("data_size", (Object)row.getString("data_size"));
            result.add((Object)object);
        }
        return result;
    }

    public int count() {
        this.init();
        return this.count;
    }

    private void init() {
        if (this.rows == null) {
            CatIndicesAction action = new CatIndicesAction(this.indexName, this.queryBuilder.getContext(), this.queryBuilder.getDataSource().createDisposableDataSource(), this.queryBuilder.getRc().getTenantId(), this.queryBuilder.getRc().getAccountId());
            IndexInfoResponse response = (IndexInfoResponse)action.execute();
            this.count = response.getIndices().size();
            this.rows = new ArrayList<Object[]>(this.count);
            for (IndexInfoResponse.Index index : response.getIndices()) {
                Object[] row = new Object[]{index.getIndexName(), index.getDocsCount(), FormatUtils.formatByteSize(FormatUtils.safeParseInteger(index.getStoreSize()))};
                this.rows.add(row);
            }
        }
    }

    private RowMeta createRowMeta() {
        return new RowMeta(new Field[]{new Field("index_name", (DataType)DataType.StringType), new Field("row_count", (DataType)DataType.IntegerType), new Field("data_size", (DataType)DataType.StringType)});
    }
}

