/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.logorm.reader;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.cbs.plugin.logorm.ElasticMonitorQueryBuilder;
import kd.bos.cbs.plugin.logorm.utils.FormatUtils;
import kd.bos.cbs.plugin.logorm.utils.Pair;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.client.es.monitor.CatIndicesAction;
import kd.bos.logorm.client.es.monitor.IndexInfoResponse;

public class IndexSummaryStatisticsReader {
    private static final Log log = LogFactory.getLog(IndexSummaryStatisticsReader.class);
    private final ElasticMonitorQueryBuilder queryBuilder;
    private final String indexName;
    private List<Object[]> rows;

    public IndexSummaryStatisticsReader(ElasticMonitorQueryBuilder queryBuilder, String indexName) {
        this.queryBuilder = queryBuilder;
        this.indexName = indexName;
    }

    private void init() {
        if (this.rows == null) {
            List<Pair<String, String>> billList = this.queryLogBillList();
            IndexInfoResponse indexInfo = this.queryIndexInfo();
            List<SummaryResult> summaryResults = this.summary(billList, indexInfo);
            this.rows = new ArrayList<Object[]>(summaryResults.size());
            String route = this.queryBuilder.getDataSourceRoute().toString();
            for (SummaryResult index : summaryResults) {
                this.rows.add(new Object[]{index.getEntityName(), index.tableName, index.getDocCount(), index.getDataSize(), route});
            }
        }
    }

    private static RowMeta createRowMeta() {
        return new RowMeta(new Field[]{new Field("entity_name", (DataType)DataType.StringType), new Field("index_prefix", (DataType)DataType.StringType), new Field("row_count", (DataType)DataType.LongType), new Field("data_size", (DataType)DataType.StringType), new Field("datasource_route", (DataType)DataType.StringType)});
    }

    private List<SummaryResult> summary(List<Pair<String, String>> billList, IndexInfoResponse indexInfo) {
        ArrayList<SummaryResult> result = new ArrayList<SummaryResult>(billList.size());
        for (Pair<String, String> pair : billList) {
            ArrayList<IndexInfoResponse.Index> indices = new ArrayList<IndexInfoResponse.Index>();
            if (this.queryBuilder.isQueryIndex()) {
                String indexPrefix = "log-" + this.queryBuilder.getEsConfigSchema() + '-' + pair.getK2();
                for (IndexInfoResponse.Index index : indexInfo.getIndices()) {
                    if (!index.getIndexName().startsWith(indexPrefix)) continue;
                    indices.add(index);
                }
            }
            if (this.queryBuilder.isQueryArchiveIndex()) {
                String indexPrefix0 = "log-archive-" + this.queryBuilder.getEsConfigSchema() + '-';
                int start = indexPrefix0.length();
                for (IndexInfoResponse.Index index : indexInfo.getIndices()) {
                    String tableName;
                    int subStart;
                    if (!index.getIndexName().startsWith(indexPrefix0) || (subStart = index.getIndexName().indexOf(45, start)) < 0 || !(tableName = index.getIndexName().substring(subStart)).startsWith(pair.getK2())) continue;
                    indices.add(index);
                }
            }
            result.add(new SummaryResult(pair.getK1(), pair.getK2(), indices));
        }
        return result;
    }

    public DataSet read() {
        this.init();
        return Algo.create((String)this.getClass().getName()).createDataSet(this.rows, IndexSummaryStatisticsReader.createRowMeta());
    }

    public static DataSet empty() {
        return Algo.create((String)IndexSummaryStatisticsReader.class.getName()).createDataSet(new ArrayList(), IndexSummaryStatisticsReader.createRowMeta());
    }

    private IndexInfoResponse queryIndexInfo() {
        RequestContext rc = RequestContext.get();
        CatIndicesAction action = new CatIndicesAction(this.indexName, this.queryBuilder.getContext(), this.queryBuilder.getDataSource().createDisposableDataSource(), rc.getTenantId(), rc.getAccountId());
        return (IndexInfoResponse)action.execute();
    }

    private List<Pair<String, String>> queryLogBillList() {
        String sql = "select fnumber from t_meta_formdesign where  fmodeltype = 'LogBillFormModel'";
        DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"sys.meta"), (String)sql);
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        while (ds.hasNext()) {
            String entityName = ds.next().getString(0);
            try {
                String tableName = this.queryBuilder.getContext().getDataEntityMetaProvider().getEntityMetadata(entityName).getTableName();
                result.add(new Pair<String, String>(entityName, tableName));
            }
            catch (Exception ex) {
                log.warn("Entity: {} ignored, {}", (Object)entityName, (Object)ex.getMessage());
            }
        }
        return result;
    }

    static class SummaryResult {
        private final String entityName;
        private final String tableName;
        private final List<IndexInfoResponse.Index> indices;
        private final long docCount;
        private final String dataSize;

        public SummaryResult(String entityName, String tableName, List<IndexInfoResponse.Index> indices) {
            this.entityName = entityName;
            this.tableName = tableName;
            this.indices = indices;
            int totalDocCount = 0;
            long totalDataSize = 0L;
            for (IndexInfoResponse.Index index : this.indices) {
                totalDataSize += FormatUtils.safeParseLong(index.getStoreSize());
                totalDocCount += index.getDocsCount();
            }
            this.docCount = totalDocCount;
            this.dataSize = FormatUtils.formatByteSize(totalDataSize);
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public List<IndexInfoResponse.Index> getIndices() {
            return this.indices;
        }

        public long getDocCount() {
            return this.docCount;
        }

        public String getDataSize() {
            return this.dataSize;
        }
    }
}

