/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.operationcollect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.operationcollect.CbsOperationCollectService;
import kd.bos.operationcollect.CollectInfo;
import kd.bos.portal.datalog.service.IDataCollectService;
import kd.bos.util.StringUtils;

public class CbsDataCollectServiceImpl
implements IDataCollectService {
    public static final String DEPARTMENT_KEY = "department";
    public static final String BUSINESS_SCENE_KEY = "business_scene";
    public static final String CBS_DEPARTMENT = "CBS";
    private static Log log = LogFactory.getLog(CbsDataCollectServiceImpl.class);

    public Map<String, Object> collectData() {
        return null;
    }

    public List<Map<String, Object>> collectBatchData() {
        return this.getDataMapList();
    }

    private List<Map<String, Object>> getDataMapList() {
        ServiceLoader<CbsOperationCollectService> providers;
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(5);
        try {
            providers = ServiceLoader.load(CbsOperationCollectService.class);
        }
        catch (Throwable throwable) {
            log.error("cbs collect error, service loader fail: " + throwable.getMessage(), throwable);
            return Collections.emptyList();
        }
        for (CbsOperationCollectService next : providers) {
            try {
                List collectInfoList = next.collect();
                if (collectInfoList == null || collectInfoList.isEmpty()) continue;
                for (CollectInfo collectInfo : collectInfoList) {
                    dataList.add(this.getDataMap(collectInfo));
                }
            }
            catch (Throwable e) {
                log.error("cbs collect error: " + next.toString() + " collect error!", e);
            }
        }
        return dataList;
    }

    private Map<String, Object> getDataMap(CollectInfo collectInfo) {
        HashMap<String, Object> data = new HashMap<String, Object>(5);
        data.put(DEPARTMENT_KEY, CBS_DEPARTMENT);
        String businessScene = collectInfo.getBusinessScene();
        if (StringUtils.isEmpty((String)businessScene)) {
            throw new KDException(BosErrorCode.paramError, new Object[]{"the param of businessScene can not be null!"});
        }
        data.put(BUSINESS_SCENE_KEY, businessScene);
        Map collectDataMap = collectInfo.getData();
        if (collectDataMap != null && !collectDataMap.isEmpty()) {
            data.putAll(collectDataMap);
        }
        return data;
    }
}

