/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.readwritesplit;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.cbs.plugin.readwritesplit.ReadWriteScenesEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.splittingread.RWManager;
import kd.bos.db.splittingread.RWScenes;
import kd.bos.db.splittingread.SlaveDBCheckResult;
import kd.bos.dc.mc.LoginMCService;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ReadWriteSplitCheckToolPlugin
extends AbstractFormPlugin
implements CreateListDataProviderListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ReadWriteSplitCheckToolPlugin.class);
    private static final String PROP_SCENES = "scenes";
    private static final String PROP_ENTITY_NO = "entity_no";
    private static final String PROP_BILLNO = "billno";
    private static final String BTN_OK = "btnok";
    private static final String PROP_DBROUTE = "dbroute";

    public void initialize() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        super.initialize();
    }

    public void beforeBindData(EventObject e) {
        String billno;
        this.initDBRouteCombo();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PROP_ENTITY_NO});
        FormView billView = (FormView)e.getSource();
        IDataModel model = this.getModel();
        FormShowParameter parameter = billView.getFormShowParameter();
        String scenes = (String)parameter.getCustomParam(PROP_SCENES);
        if (scenes != null) {
            model.setValue(PROP_SCENES, (Object)scenes);
        }
        if ((billno = (String)parameter.getCustomParam(PROP_BILLNO)) != null) {
            model.setValue(PROP_BILLNO, (Object)billno);
        }
        this.setDBRouteCombo(scenes, billno);
        super.beforeBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ctl = (BasedataEdit)this.getControl(PROP_ENTITY_NO);
        ctl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button ok = (Button)this.getControl(BTN_OK);
        ok.addClickListener((ClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (beforeF7SelectEvent.getProperty().getName().equals(PROP_ENTITY_NO)) {
            Object scenesObj = this.getModel().getValue(PROP_SCENES);
            if (scenesObj == null) {
                return;
            }
            String scenes = (String)scenesObj;
            ReadWriteScenesEnum scenesEnum = ReadWriteScenesEnum.fromValue(scenes);
            QFilter filter = null;
            if (scenesEnum == ReadWriteScenesEnum.BILL_LIST) {
                filter = new QFilter("modeltype", "in", (Object)Lists.newArrayList((Object[])new String[]{"BillFormModel", "BaseFormModel"}));
            } else if (scenesEnum == ReadWriteScenesEnum.REPORT) {
                filter = new QFilter("modeltype", "=", (Object)"ReportFormModel");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bfb\u5199\u5206\u79bb\u914d\u7f6e\u76ee\u524d\u4ec5\u652f\u6301\u5bf9\uff1a\u5355\u636e\uff0c\u57fa\u7840\u8d44\u6599\uff0c\u62a5\u8868 \u8fdb\u884c\u914d\u7f6e\u3002", (String)"ReadWriteAllowTypes", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            if (filter != null) {
                beforeF7SelectEvent.getCustomQFilters().add(filter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject value;
        String propertyName = e.getProperty().getName();
        if (e.getChangeSet() == null || e.getChangeSet().length == 0) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (PROP_SCENES.equals(propertyName)) {
            String value2 = (String)changeData.getNewValue();
            ReadWriteScenesEnum scenes = ReadWriteScenesEnum.fromValue(value2);
            boolean entityPropVisit = false;
            switch (scenes) {
                case REPORT: 
                case BILL_LIST: {
                    entityPropVisit = true;
                    break;
                }
            }
            view.setVisible(Boolean.valueOf(entityPropVisit), new String[]{PROP_ENTITY_NO});
            view.setVisible(Boolean.valueOf(!entityPropVisit), new String[]{PROP_BILLNO});
            model.setValue(PROP_ENTITY_NO, null);
            model.setValue(PROP_BILLNO, null);
            model.setValue(PROP_DBROUTE, null);
        } else if (PROP_ENTITY_NO.equals(propertyName) && (value = (DynamicObject)changeData.getNewValue()) != null) {
            String billNumber = value.getString("number");
            model.setValue(PROP_BILLNO, (Object)billNumber);
            this.setDBRouteCombo((String)model.getValue(PROP_SCENES), billNumber);
        }
    }

    private void initDBRouteCombo() {
        JSONArray dbinstanceList = ReadWriteSplitCheckToolPlugin.getDbInstanceList();
        Lang lang = RequestContext.get().getLang();
        ArrayList<ComboItem> combo = new ArrayList<ComboItem>(dbinstanceList.size());
        for (int i = 0; i < dbinstanceList.size(); ++i) {
            JSONObject object = dbinstanceList.getJSONObject(i);
            String caption = object.getString("name");
            if (Lang.zh_CN != lang && Lang.zh_TW != lang) {
                caption = object.getString("number");
            }
            String value = object.getString("number");
            ComboItem item = new ComboItem(new LocaleString(caption), value);
            combo.add(item);
        }
        ComboEdit dbCombo = (ComboEdit)this.getView().getControl(PROP_DBROUTE);
        dbCombo.setComboItems(combo);
    }

    private void setDBRouteCombo(String scenesString, String key) {
        ReadWriteScenesEnum scenesEnum = ReadWriteScenesEnum.fromValue(scenesString);
        if (scenesEnum == null) {
            return;
        }
        switch (scenesEnum) {
            case REPORT: 
            case BILL_LIST: {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)key);
                String dbRoute = dynamicObject.getDataEntityType().getDBRouteKey();
                this.getModel().setValue(PROP_DBROUTE, (Object)dbRoute);
                break;
            }
        }
    }

    public static JSONArray getDbInstanceList() {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("Content-type", "application/json");
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("dataCenterId", RequestContext.get().getAccountId());
        String host = System.getProperty("mc.server.url");
        JSONArray data = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)host)) {
            try {
                JSONObject resp;
                String sHttpResponse = LoginMCService.create().callMcApiService("/kapi/app/mc/GetDbInstanceListService", "application/json", header, params, 30);
                if (StringUtils.isNotBlank((CharSequence)sHttpResponse) && (resp = JSONObject.parseObject((String)sHttpResponse)).getInteger("errorcode") == 100) {
                    data = resp.getJSONArray("data");
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        JSONArray array = new JSONArray();
        for (int i = 0; i < data.size(); ++i) {
            JSONObject object = data.getJSONObject(i);
            if (object.getBoolean("readonly").booleanValue()) continue;
            array.add((Object)object);
        }
        return array;
    }

    public void click(EventObject evt) {
        Button btn;
        Object source = evt.getSource();
        if (source instanceof Button && BTN_OK.equals((btn = (Button)source).getKey())) {
            this.check();
        }
        super.click(evt);
    }

    private void check() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refreshData();
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        IDataModel model = this.getModel();
        String scenes = (String)model.getValue(PROP_SCENES);
        String billno = (String)model.getValue(PROP_BILLNO);
        String routeKey = (String)model.getValue(PROP_DBROUTE);
        ReadWriteScenesEnum scenesEnum = ReadWriteScenesEnum.fromValue(scenes);
        beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new EventListDataProvider(scenesEnum, billno, routeKey));
    }

    public static class EventListDataProvider
    extends ListDataProvider {
        private final RWScenes scenes;
        private final String billno;
        private final String routeKey;

        public EventListDataProvider(ReadWriteScenesEnum scenes, String billno, String routeKey) {
            this.billno = billno;
            this.routeKey = routeKey;
            if (scenes == null) {
                this.scenes = null;
            } else {
                switch (scenes) {
                    case CUSTOM: {
                        this.scenes = RWScenes.custom;
                        break;
                    }
                    case BILL_LIST: {
                        this.scenes = RWScenes.billlist;
                        break;
                    }
                    case REPORT: {
                        this.scenes = RWScenes.report;
                        break;
                    }
                    default: {
                        this.scenes = null;
                    }
                }
            }
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectType dataType = (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"rw_split_check_event").getDataEntityType();
            DynamicObjectCollection collection = new DynamicObjectCollection(dataType, (Object)false);
            if (this.scenes == null || this.billno == null || this.routeKey == null) {
                return collection;
            }
            SlaveDBCheckResult checkResult = RWManager.getInstance().getCheckSlaveDBResult(this.scenes, this.billno, this.routeKey);
            this.setGlobalCheckResult(collection, checkResult);
            this.setAccountCheckResult(collection, checkResult);
            this.setSlaveDBListCheckResult(collection, checkResult);
            this.setKeyConfigCheckResult(collection, checkResult);
            this.setCheckConclusion(collection, checkResult);
            return collection;
        }

        public int getBillDataCount() {
            return this.getData(0, 0).size();
        }

        public int getRealCount() {
            return this.getData(0, 0).size();
        }

        public int getMaxCount() {
            return this.getData(0, 0).size();
        }

        private void setGlobalCheckResult(DynamicObjectCollection collection, SlaveDBCheckResult result) {
            String event = ResManager.loadKDString((String)"\u662f\u5426\u5f00\u542f\u8bfb\u5199\u5206\u79bb\u5168\u5c40\u53c2\u6570\u3002", (String)"ReadWriteSplitCheckToolPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            if (result.isGlobalEnable()) {
                this.newCheckEvent(collection, event, ResManager.loadKDString((String)"\u5df2\u5f00\u542f", (String)"ReadWriteSplitCheckToolPlugin_14", (String)"bos-cbs-plugin", (Object[])new Object[0]), "", false);
            } else {
                result.setSlaveFirst(false);
                this.newCheckEvent(collection, event, ResManager.loadKDString((String)"\u5df2\u5173\u95ed", (String)"ReadWriteSplitCheckToolPlugin_15", (String)"bos-cbs-plugin", (Object[])new Object[0]), "", true);
            }
        }

        private void setAccountCheckResult(DynamicObjectCollection collection, SlaveDBCheckResult result) {
            String event = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u662f\u5426\u5f00\u542f\u3010\u8bfb\u5199\u5206\u79bb\u3011\u3002", (String)"ReadWriteSplitCheckToolPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            if (result.isCurrentAccountEnable()) {
                this.newCheckEvent(collection, event, ResManager.loadKDString((String)"\u5df2\u5f00\u542f", (String)"ReadWriteSplitCheckToolPlugin_14", (String)"bos-cbs-plugin", (Object[])new Object[0]), "", false);
            } else {
                this.newCheckEvent(collection, event, ResManager.loadKDString((String)"\u5df2\u5173\u95ed", (String)"ReadWriteSplitCheckToolPlugin_15", (String)"bos-cbs-plugin", (Object[])new Object[0]), "", true);
                result.setSlaveFirst(false);
            }
        }

        private void setSlaveDBListCheckResult(DynamicObjectCollection collection, SlaveDBCheckResult result) {
            String event = ResManager.loadKDString((String)"\u5206\u5e93\u3010%1$s\u3011\u662f\u5426\u914d\u7f6e\u4ece\u5e93\u3002", (String)"ReadWriteSplitCheckToolPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[]{this.routeKey});
            List slaveList = result.getSlaveInfoList();
            if (slaveList == null || slaveList.isEmpty()) {
                this.newCheckEvent(collection, event, ResManager.loadKDString((String)"\u672a\u914d\u7f6e", (String)"ReadWriteSplitCheckToolPlugin_23", (String)"bos-cbs-plugin", (Object[])new Object[0]), "", true);
                result.setSlaveFirst(false);
                return;
            }
            this.newCheckEvent(collection, event, ResManager.loadKDString((String)"\u5df2\u914d\u7f6e", (String)"ReadWriteSplitCheckToolPlugin_22", (String)"bos-cbs-plugin", (Object[])new Object[0]), "", false);
            this.setSlaveDBListLoadFactorCheckResult(collection, result);
        }

        private void setSlaveDBListLoadFactorCheckResult(DynamicObjectCollection collection, SlaveDBCheckResult result) {
            String event = ResManager.loadKDString((String)"\u4ece\u5e93\u8d1f\u8f7d\u56e0\u5b50\u914d\u7f6e", (String)"ReadWriteSplitCheckToolPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            List slaveList = result.getSlaveInfoList();
            if (slaveList.size() == 1) {
                if (((SlaveDBCheckResult.DatabaseInfo)slaveList.get(0)).getLoadFactor() > 0) {
                    this.newCheckEvent(collection, event, ResManager.loadKDString((String)"\u914d\u7f6e\u6b63\u786e\u3002", (String)"ReadWriteSplitCheckToolPlugin_18", (String)"bos-cbs-plugin", (Object[])new Object[0]), "", false);
                    this.setSlaveDBStatusCheckResult(collection, result);
                } else {
                    this.newCheckEvent(collection, event, ResManager.loadKDString((String)"\u914d\u7f6e\u9519\u8bef\u3002", (String)"ReadWriteSplitCheckToolPlugin_19", (String)"bos-cbs-plugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d1f\u8f7d\u56e0\u5b50\u5c0f\u4e8e\u7b49\u4e8e0\u65f6\u4ece\u5e93\u4e0d\u53ef\u7528", (String)"ReadWriteSplitCheckToolPlugin_33", (String)"bos-cbs-plugin", (Object[])new Object[0]), true);
                    result.setSlaveFirst(false);
                }
                return;
            }
            int correctCount = 0;
            for (SlaveDBCheckResult.DatabaseInfo info : slaveList) {
                if (info.getLoadFactor() <= 0) continue;
                ++correctCount;
            }
            if (correctCount == slaveList.size()) {
                this.newCheckEvent(collection, event, ResManager.loadKDString((String)"\u914d\u7f6e\u6b63\u786e\u3002", (String)"ReadWriteSplitCheckToolPlugin_18", (String)"bos-cbs-plugin", (Object[])new Object[0]), "", false);
                this.setSlaveDBStatusCheckResult(collection, result);
            } else if (correctCount > 0) {
                this.newCheckEvent(collection, event, ResManager.loadKDString((String)"\u914d\u7f6e\u9519\u8bef\u3002", (String)"ReadWriteSplitCheckToolPlugin_19", (String)"bos-cbs-plugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d1f\u8f7d\u56e0\u5b50\u5c0f\u4e8e\u7b49\u4e8e0\u7684\u4ece\u5e93\u4e0d\u4f1a\u88ab\u4f7f\u7528", (String)"ReadWriteSplitCheckToolPlugin_34", (String)"bos-cbs-plugin", (Object[])new Object[0]), true);
                this.setSlaveDBStatusCheckResult(collection, result);
            } else {
                this.newCheckEvent(collection, event, ResManager.loadKDString((String)"\u914d\u7f6e\u9519\u8bef\u3002", (String)"ReadWriteSplitCheckToolPlugin_19", (String)"bos-cbs-plugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5206\u5e93\u3010%1$s\u3011\u6240\u6709\u4ece\u5e93\u7684\u8d1f\u8f7d\u56e0\u5b50\u5168\u90e8\u914d\u7f6e\u4e3a\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u6ca1\u6709\u53ef\u4ee5\u4f7f\u7528\u7684\u4ece\u5e93", (String)"ReadWriteSplitCheckToolPlugin_35", (String)"bos-cbs-plugin", (Object[])new Object[]{this.routeKey}), true);
                result.setSlaveFirst(false);
            }
        }

        private void setSlaveDBStatusCheckResult(DynamicObjectCollection collection, SlaveDBCheckResult result) {
            String event = ResManager.loadKDString((String)"\u4ece\u5e93\u6570\u636e\u540c\u6b65\u72b6\u6001", (String)"ReadWriteSplitCheckToolPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            if (result.isSlaveDBAvailable()) {
                this.newCheckEvent(collection, event, ResManager.loadKDString((String)"\u72b6\u6001\u6b63\u5e38", (String)"ReadWriteSplitCheckToolPlugin_39", (String)"bos-cbs-plugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ece\u5e93\u6570\u636e\u540c\u6b65\u72b6\u6001\u6307\u6807\u6b63\u5e38\uff0c\u4ece\u5e93\u53ef\u7528", (String)"ReadWriteSplitCheckToolPlugin_20", (String)"bos-cbs-plugin", (Object[])new Object[0]), false);
            } else {
                this.newCheckEvent(collection, event, ResManager.loadKDString((String)"\u72b6\u6001\u5f02\u5e38", (String)"ReadWriteSplitCheckToolPlugin_40", (String)"bos-cbs-plugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ece\u5e93\u6570\u636e\u540c\u6b65\u72b6\u6001\u6307\u6807\u5f02\u5e38\uff0c\u4ece\u5e93\u4e0d\u53ef\u7528", (String)"ReadWriteSplitCheckToolPlugin_21", (String)"bos-cbs-plugin", (Object[])new Object[0]), true);
                result.setSlaveFirst(false);
            }
        }

        private void setKeyConfigCheckResult(DynamicObjectCollection collection, SlaveDBCheckResult result) {
            if (this.scenes == null) {
                return;
            }
            String eventName = "";
            switch (this.scenes) {
                case billlist: {
                    eventName = ResManager.loadKDString((String)"\u5355\u636e\u3010%1$s\u3011\u662f\u5426\u914d\u7f6e\u4ece\u5e93\u4f18\u5148", (String)"ReadWriteSplitCheckToolPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[]{this.billno});
                    break;
                }
                case report: {
                    eventName = ResManager.loadKDString((String)"\u62a5\u8868\u3010%1$s\u3011\u662f\u5426\u914d\u7f6e\u4ece\u5e93\u4f18\u5148", (String)"ReadWriteSplitCheckToolPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[]{this.billno});
                    break;
                }
                default: {
                    eventName = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49Key\u3010%1$s\u3011\u662f\u5426\u914d\u7f6e\u4ece\u5e93\u4f18\u5148", (String)"ReadWriteSplitCheckToolPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[]{this.billno});
                }
            }
            String checkResult = ResManager.loadKDString((String)"\u672a\u914d\u7f6e", (String)"ReadWriteSplitCheckToolPlugin_23", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            boolean configInSlaveFirst = false;
            String comment = "";
            if (result.getConfigInSlaveFirst() != null) {
                if (result.getConfigInSlaveFirst().booleanValue()) {
                    configInSlaveFirst = true;
                    comment = ResManager.loadKDString((String)"\u8bfb\u5199\u5206\u79bb\u914d\u7f6e\u4e2d\u5df2\u914d\u7f6e\u4ece\u5e93\u4f18\u5148", (String)"ReadWriteSplitCheckToolPlugin_41", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                }
            } else if (result.getScenesSlaveFirst() != null) {
                if (result.getScenesSlaveFirst().booleanValue()) {
                    configInSlaveFirst = true;
                    comment = ResManager.loadKDString((String)"\u8bfb\u5199\u5206\u79bb\u573a\u666f\u914d\u7f6e\u4e2d\u5df2\u914d\u7f6e\u4ece\u5e93\u4f18\u5148", (String)"ReadWriteSplitCheckToolPlugin_42", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                }
            } else if (result.getWhiteListHasSlaveFirst() != null && result.getWhiteListHasSlaveFirst().booleanValue()) {
                configInSlaveFirst = true;
                comment = ResManager.loadKDString((String)"\u53c2\u6570\u767d\u540d\u5355\u4e2d\u5df2\u914d\u7f6e\u4ece\u5e93\u4f18\u5148", (String)"ReadWriteSplitCheckToolPlugin_43", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            }
            if (configInSlaveFirst) {
                checkResult = ResManager.loadKDString((String)"\u5df2\u914d\u7f6e", (String)"ReadWriteSplitCheckToolPlugin_22", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            }
            this.newCheckEvent(collection, eventName, checkResult, comment, !configInSlaveFirst);
            result.setSlaveFirst(configInSlaveFirst && result.isSlaveFirst());
        }

        private void setCheckConclusion(DynamicObjectCollection collection, SlaveDBCheckResult result) {
            String event = ResManager.loadKDString((String)"\u68c0\u6d4b\u7ed3\u8bba", (String)"ReadWriteSplitCheckToolPlugin_24", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            String checkResult = "";
            checkResult = result.isSlaveFirst() ? ResManager.loadKDString((String)"\u4f18\u5148\u4ece\u5e93", (String)"ReadWriteSplitCheckToolPlugin_28", (String)"bos-cbs-plugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f18\u5148\u4e3b\u5e93", (String)"ReadWriteSplitCheckToolPlugin_27", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            this.newCheckEvent(collection, event, checkResult, "", !result.isSlaveFirst());
        }

        private void newCheckEvent(DynamicObjectCollection collection, String event, String result, String comment, boolean highlight) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rw_split_check_event");
            dynamicObject.set("event", (Object)event);
            dynamicObject.set("result", (Object)result);
            dynamicObject.set("comment", (Object)comment);
            dynamicObject.set("result_code", (Object)(highlight ? "1" : "0"));
            collection.add((Object)dynamicObject);
        }
    }
}

