/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.readwritesplit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.readwritesplit.ReadWriteSplitConfigEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.splittingread.RWManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ReadWriteSplitTreeListPlugin
extends StandardTreeListPlugin {
    private static final String BTN_NEW = "btn_new";
    private static final String BTN_SAVE_AS = "btn_saveas";
    private static final String BTN_DELETE = "btn_delete";
    private static final String BTN_RELEASE = "btn_release";
    private static final String BTN_SAVE_AS_MASTER_FIRST = "save_as_master_first";
    private static final String BTN_SAVE_AS_SLAVE_FIRST = "save_as_slave_first";
    private static final String CONFIRM_RELEASE_CALL_BACK_ID = "btn_release";
    private static final String BTN_CHECK_TOOL = "btnchecktool";
    private static final int MAX_TREE_LEVEL = 3;

    private static TreeNode loadAllAppNodes() {
        return (TreeNode)BizAppServiceHelp.getSubsysTree((String[])null, (String[])null, (String)null, (String)"app", (boolean)true, (boolean)false, (boolean)false);
    }

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void initializeTree(EventObject e) {
        TreeNode root = ReadWriteSplitTreeListPlugin.loadAllAppNodes();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            Donothing btn = (Donothing)args.getSource();
            String itemKey = btn.getOperateKey();
            if (BTN_NEW.equals(itemKey)) {
                this.onNewBtnClick();
            } else if (BTN_SAVE_AS_MASTER_FIRST.equals(itemKey) || BTN_SAVE_AS_SLAVE_FIRST.equals(itemKey)) {
                this.onSaveAsClick(itemKey);
            } else if (BTN_DELETE.equals(itemKey)) {
                this.onDeleteClick();
            } else if ("btn_release".equals(itemKey)) {
                this.onReleaseClick();
            }
        }
    }

    public void addItemClickListeners(String ... keys) {
        super.addItemClickListeners(keys);
        super.addItemClickListeners(new String[]{BTN_CHECK_TOOL});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (BTN_CHECK_TOOL.equals(evt.getItemKey())) {
            this.onCheckToolClick();
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        ITreeModel treeModel = this.getTreeModel();
        TreeNode root = treeModel.getRoot();
        TreeNode current = root.getTreeNode(e.getNodeId().toString(), 3);
        if ((current.getChildren() == null || current.getChildren().isEmpty()) && !"app".equals(current.getData())) {
            root = ReadWriteSplitTreeListPlugin.loadAllAppNodes();
            current = root.getTreeNode(e.getNodeId().toString(), 3);
        }
        e.setChildNodes(current.getChildren());
        super.refreshNode(e);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode current = root.getTreeNode(nodeId, 5);
        String nodeType = (String)current.getData();
        if ("cloud".equals(nodeType)) {
            ArrayList<String> groupIds = new ArrayList<String>(4);
            for (TreeNode app : current.getChildren()) {
                groupIds.add(app.getId());
            }
            e.addQFilter(new QFilter("group", "in", groupIds));
        } else if ("app".equals(nodeType)) {
            e.addQFilter(new QFilter("group", "=", (Object)current.getId()));
        }
    }

    private void onCheckToolClick() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("rw_split_checktools");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selected = billList.getSelectedRows();
        if (selected != null && !selected.isEmpty()) {
            ListSelectedRow row = selected.get(0);
            DynamicObject rowData = BusinessDataServiceHelper.loadSingleFromCache((Object)row.getPrimaryKeyValue(), (String)"rw_split_config");
            parameter.setCustomParam("scenes", (Object)rowData.getString("scenes"));
            parameter.setCustomParam("billno", (Object)rowData.getString("billno"));
        }
        this.getView().showForm(parameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("btn_release".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.release();
        }
        super.confirmCallBack(event);
    }

    private void release() {
        String deleteSQL = "DELETE t_rw_split_config WHERE fcurrent_config=? and fpreset=0";
        String releaseSQL = "UPDATE t_rw_split_config SET frelease_config=fcurrent_config";
        String releaseSQL1 = "UPDATE t_rw_split_config SET frelease_config=' ' WHERE fcurrent_config = ?";
        BillList billList = (BillList)this.getControl("billlistap");
        try (TXHandle txHandle = TX.requiresNew((String)"kd.bos.cbs.readwritesplit");){
            DBRoute route = DBRoute.of((String)"sys");
            DB.execute((DBRoute)route, (String)deleteSQL, (Object[])new Object[]{ReadWriteSplitConfigEnum.Delete.getValue()});
            DB.execute((DBRoute)route, (String)releaseSQL);
            DB.execute((DBRoute)route, (String)releaseSQL1, (Object[])new Object[]{ReadWriteSplitConfigEnum.Delete.getValue()});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"ReleaseSuccess", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            billList.refreshData();
        }
        RWManager manager = RWManager.getInstance();
        manager.invalidConfigCache();
    }

    private void onReleaseClick() {
        ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("btn_release", (IFormPlugin)this);
        String title = ResManager.loadKDString((String)"\u53d8\u66f4\u914d\u7f6e\u4f1a\u5bfc\u81f4\u67e5\u8be2\u5207\u6362\u5230\u4e3b\u5e93\u6216\u4ece\u5e93\u6267\u884c\uff0c\u662f\u5426\u786e\u8ba4\u53d1\u5e03\u914d\u7f6e\uff1f", (String)"ConfirmReleaseConfig", (String)"bos-cbs-plugin", (Object[])new Object[0]);
        this.getView().showConfirm(title, MessageBoxOptions.YesNo, confirmListener);
    }

    private void onDeleteClick() {
        this.updateSelectedRowConfig(ReadWriteSplitConfigEnum.Delete);
    }

    private void showSelectRowsTip() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u6570\u636e\u884c\u3002", (String)"NoneSelectedRows", (String)"bos-cbs-plugin", (Object[])new Object[0]));
    }

    private void updateSelectedRowConfig(ReadWriteSplitConfigEnum configEnum) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRowCollection = billList.getSelectedRows();
        if (selectedRowCollection.isEmpty()) {
            this.showSelectRowsTip();
            return;
        }
        String value = configEnum.getValue();
        ArrayList<DynamicObject> updateObjects = new ArrayList<DynamicObject>(selectedRowCollection.size());
        for (ListSelectedRow row : selectedRowCollection) {
            Object primary = row.getPrimaryKeyValue();
            if (primary == null) continue;
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"rw_split_config");
            data.set("id", primary);
            data.set("current_config", (Object)value);
            updateObjects.add(data);
        }
        try (TXHandle txHandle = TX.requiresNew((String)"kd.bos.cbs.readwritesplit");){
            SaveServiceHelper.update((DynamicObject[])updateObjects.toArray(new DynamicObject[0]));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6210\u529f\u3002", (String)"SaveSuccess", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        billList.refreshData();
    }

    private void onSaveAsClick(String itemKey) {
        ReadWriteSplitConfigEnum value = BTN_SAVE_AS_MASTER_FIRST.equalsIgnoreCase(itemKey) ? ReadWriteSplitConfigEnum.MasterFirst : ReadWriteSplitConfigEnum.SlaveFirst;
        this.updateSelectedRowConfig(value);
    }

    private void onNewBtnClick() {
        String nodeId = this.getTreeModel().getCurrentNodeId().toString();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode current = root.getTreeNode(nodeId, 5);
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("rw_split_config");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "create_callback"));
        if ("app".equals(current.getData())) {
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("group", nodeId);
            parameter.setCustomParams(customParams);
        }
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("create_callback".equals(closedCallBackEvent.getActionId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refreshData();
        }
        super.closedCallBack(closedCallBackEvent);
    }
}

