/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.search;

import java.util.HashSet;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.fulltext.FullTextFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.datasync.agent.DataSyncAgent;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.fulltext.QFullTextQuery;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.util.StringUtils;

public class IsFromSearchPlugin
extends AbstractReportListDataPlugin {
    private static Log logger = LogFactory.getLog(IsFromSearchPlugin.class);
    private static String[] fields = new String[]{"isfromes", "reason"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        String[] split;
        DataType[] dataTypes = new DataType[]{DataType.StringType, DataType.StringType};
        DataSetBuilder dataSetBuilder = Algo.create((String)"bos_cbs_qs_is_fromes").createDataSetBuilder(RowMetaFactory.createRowMeta((String[])fields, (DataType[])dataTypes));
        DynamicObject entitynumberObject = reportQueryParam.getFilter().getDynamicObject("entitynumber");
        if (entitynumberObject == null) {
            return dataSetBuilder.build();
        }
        String entityNumber = entitynumberObject.getString("number");
        if (StringUtils.isEmpty((String)entityNumber)) {
            return dataSetBuilder.build();
        }
        String entityFields = reportQueryParam.getFilter().getString("entityfields");
        if (StringUtils.isEmpty((String)entityFields)) {
            return dataSetBuilder.build();
        }
        HashSet<String> properties = new HashSet<String>();
        for (String field : split = entityFields.split(",")) {
            if (!StringUtils.isNotEmpty((String)field)) continue;
            properties.add(field);
        }
        String entityName = this.getEntityName(entityNumber);
        boolean fullTextOrmEnable = QFullTextQuery.isFullTextEnable();
        boolean fullTextCustSyncEnable = FullTextFactory.getFullTextCustSyncQuery().isConfigFullText(entityName);
        boolean dtsQueryEnable = DataSyncAgent.isQueryEnable((String)entityName);
        StringBuilder builder = new StringBuilder();
        boolean isES = QMatches.recordIsESLog(properties, (String)entityNumber, (boolean)dtsQueryEnable, (boolean)fullTextOrmEnable, (boolean)fullTextCustSyncEnable, (StringBuilder)builder, new HashSet(2));
        Object[] datas = new Object[]{String.valueOf(isES), !isES ? builder.toString() : ""};
        dataSetBuilder.append(datas);
        return dataSetBuilder.build();
    }

    private String getEntityName(String fullObjectName) {
        String entityName;
        String[] segs = fullObjectName.split("\\.");
        if (segs.length == 0) {
            entityName = segs[0];
        } else {
            String aloneFullObjectName = fullObjectName;
            ORM orm = ORM.create();
            IDataEntityType dataEntityType = orm.getDataEntityType(aloneFullObjectName);
            if (ORMConfiguration.isEntryEntityType((IDataEntityType)dataEntityType)) {
                while (ORMConfiguration.isEntryEntityType((IDataEntityType)(dataEntityType = orm.getDataEntityType(aloneFullObjectName = aloneFullObjectName.substring(0, aloneFullObjectName.lastIndexOf(46)))))) {
                }
                entityName = dataEntityType.getName() + fullObjectName.substring(aloneFullObjectName.length());
            } else {
                entityName = dataEntityType.getName();
            }
        }
        return entityName;
    }
}

