/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.common.entity;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;

public class ComboDate
implements Const {
    String condiType;
    Date startDate;
    Date endDate;
    Long id;
    private static final String TYPE_FROM_TO = "1";
    private static final String TYPE_EARLIER_THAN = "2";

    public String getComboType() {
        return this.condiType;
    }

    public void setComboType(String condiType) {
        this.condiType = condiType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean overlaps(ComboDate other) {
        if (other == null || other.getStartDate() == null && other.getEndDate() == null) {
            return false;
        }
        if (this.startDate != null && this.startDate.after(this.endDate)) {
            throw new IllegalStateException("StartDate must be before endDate in ComboDate.");
        }
        if (other.startDate != null && other.startDate.after(other.endDate)) {
            throw new IllegalStateException("StartDate must be before endDate in other ComboDate.");
        }
        return TYPE_FROM_TO.equals(this.getComboType()) && TYPE_FROM_TO.equals(other.getComboType()) ? this.getEndDate().after(other.getStartDate()) && this.getStartDate().before(other.getEndDate()) : (TYPE_FROM_TO.equals(this.getComboType()) && TYPE_EARLIER_THAN.equals(other.getComboType()) ? this.getStartDate().before(other.getEndDate()) : (TYPE_EARLIER_THAN.equals(this.getComboType()) && TYPE_FROM_TO.equals(other.getComboType()) ? this.getEndDate().after(other.getStartDate()) : TYPE_EARLIER_THAN.equals(this.getComboType()) && TYPE_EARLIER_THAN.equals(other.getComboType())));
    }

    public String toDesc() {
        Lang lang = RequestContext.get().getLang();
        SimpleDateFormat sdf = "en".equals(lang.getLocale().getLanguage()) ? new SimpleDateFormat("dd/MM/yyyy HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formattedEndDate = sdf.format(this.endDate);
        String desc = "";
        if (TYPE_FROM_TO.equals(this.condiType)) {
            String formattedStartDate = sdf.format(this.startDate);
            String descFormat = ResManager.loadKDString((String)"\u5927\u4e8e\u7b49\u4e8e%1$s\uff0c\u5c0f\u4e8e%2$s", (String)"ShardingArchiEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            desc = String.format(descFormat, formattedStartDate, formattedEndDate);
        } else {
            String descFormat = ResManager.loadKDString((String)"\u5c0f\u4e8e%s", (String)"ShardingArchiEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            desc = String.format(descFormat, formattedEndDate);
        }
        return desc;
    }
}

