/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.common.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.service.ShardTaskService;

public class ShardingStrategyFormUtils {
    private static ThreadLocal<Object> thSyncObject = ThreadLocals.create();

    public static String getShardingConfigLockKey(String accountId, String entityName) {
        return "/xdbsharding/config_dispatch/" + accountId + "/" + entityName;
    }

    public static Boolean shardingLock(String type, String entityName) {
        CountDownLatch cd = new CountDownLatch(1);
        AtomicBoolean ret = new AtomicBoolean(false);
        AtomicBoolean zkRunning = new AtomicBoolean(true);
        Object syncObject = new Object();
        ThreadPools.executeOnce((String)"shardingLock", () -> {
            block8: {
                String lockKey = "config".equals(type) ? ShardingStrategyFormUtils.getShardingConfigLockKey(RequestContext.get().getAccountId(), entityName) : ShardTaskService.getShardTaskLockKey((String)RequestContext.get().getAccountId(), (String)entityName);
                try {
                    DLock lock = DLock.create((String)lockKey);
                    if (lock.tryLock()) {
                        ret.set(true);
                        cd.countDown();
                        Object object = syncObject;
                        synchronized (object) {
                            try {
                                syncObject.wait(10000L);
                            }
                            catch (InterruptedException e) {
                                throw ExceptionUtil.wrap((Throwable)e);
                            }
                        }
                        lock.unlock();
                        break block8;
                    }
                    cd.countDown();
                }
                catch (Exception e) {
                    zkRunning.set(false);
                    cd.countDown();
                }
            }
        });
        try {
            cd.await();
        }
        catch (InterruptedException e) {
            throw ExceptionUtil.asRuntimeException((Throwable)e);
        }
        if (zkRunning.get()) {
            boolean acquired = ret.get();
            if (acquired) {
                thSyncObject.set(syncObject);
            }
            return acquired;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseShardingConfigLock() {
        Object syncObject = thSyncObject.get();
        if (syncObject != null) {
            Object object = syncObject;
            synchronized (object) {
                syncObject.notifyAll();
            }
            thSyncObject.remove();
        }
    }

    public static List<IDataEntityProperty> getEntityPropertiesForSharding(String formId, boolean forIndices) {
        ArrayList<IDataEntityProperty> dps = new ArrayList<IDataEntityProperty>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)formId);
        DataEntityPropertyCollection ps = dt.getProperties();
        int n = ps.size();
        for (int i = 0; i < n; ++i) {
            FieldProp fp;
            IDataEntityProperty dp = (IDataEntityProperty)ps.get(i);
            if (ORMUtil.isDbIgnoreRefBaseData((IDataEntityProperty)dp) || dp.getName().endsWith("_id") || !(dp instanceof PKFieldProp) && !(dp instanceof DateTimeProp) && !(dp instanceof ComboProp) && !(dp instanceof BasedataProp) && dp.getClass() != TextProp.class && !(dp instanceof DecimalProp) || dp.getTableGroup() != null && !forIndices || dp instanceof TextProp && dp instanceof FieldProp && (fp = (FieldProp)dp).isSysField()) continue;
            dps.add(dp);
        }
        dps.sort(new Comparator<IDataEntityProperty>(){

            @Override
            public int compare(IDataEntityProperty o1, IDataEntityProperty o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return dps;
    }

    public static Properties convertString2Properties(String shardingParams) {
        Properties ps = new Properties();
        try {
            ps.load(new StringReader(shardingParams));
        }
        catch (IOException e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
        return ps;
    }

    public static String getSpliceOperationLog(String operationLoad, String operationLog) {
        if (StringUtils.isEmpty((String)operationLoad)) {
            return operationLog;
        }
        operationLoad = operationLog + "\r\n" + operationLoad;
        int N = 1333;
        if (operationLoad.length() > 1333) {
            operationLoad = operationLoad.substring(0, 1333);
            int rn = operationLoad.lastIndexOf("\r\n");
            operationLoad = operationLoad.substring(0, rn);
        }
        return operationLoad;
    }
}

