/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.common.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cbs.plugin.sharding.common.validate.AbstractDDLValidate;
import kd.bos.cbs.plugin.sharding.common.validate.Column;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;

public class PostGreDDLValidate
extends AbstractDDLValidate {
    private static final String SQL = KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)"select column_name,data_type,character_maximum_length,numeric_precision,numeric_scale,is_nullable,column_default,ordinal_position from information_schema.columns where table_name=? order by ordinal_position"));
    private static final String SQL_EXIST = "SELECT 1 FROM information_schema.columns WHERE (table_name = ? AND column_name = ?)";

    public PostGreDDLValidate(DBRoute dbRoute, String compareTable, String toCompareTable) {
        super(dbRoute, compareTable, toCompareTable);
    }

    public PostGreDDLValidate(DBRoute dbRoute, DBRoute shardTableRoute, String compareTable, String toCompareTable) {
        super(dbRoute, shardTableRoute, compareTable, toCompareTable);
    }

    @Override
    List<Column> queryColumns(String table) {
        return this.queryColumns(table, this.dbRoute);
    }

    @Override
    List<Column> queryColumns(String table, DBRoute curDBRoute) {
        List pgRet = (List)DB.query((DBRoute)curDBRoute, (String)SQL, (Object[])new Object[]{table}, rs -> {
            ArrayList<Column> pgQuery = new ArrayList<Column>(8);
            while (rs.next()) {
                Column pgColumn = new Column();
                pgColumn.setColumnName(rs.getString("column_name"));
                String dataType = rs.getString("data_type");
                pgColumn.setDataLength(this.parseLongNullAsZero(rs.getString("character_maximum_length")));
                pgColumn.setDataPrecision(this.parseIntNullAsZero(rs.getString("numeric_precision")));
                pgColumn.setDataScale(this.parseIntNullAsZero(rs.getString("numeric_scale")));
                pgColumn.setNullable("YES".equals(rs.getString("is_nullable")));
                if ("bigint".equals(dataType) || "numeric".equals(dataType) || "integer".equals(dataType) || "smallint".equals(dataType)) {
                    pgColumn.setDataType(dataType);
                    pgColumn.setDataDefault(0);
                } else if ("character varying".equals(dataType)) {
                    pgColumn.setDataType("varchar");
                    pgColumn.setDataDefault(Character.valueOf(' '));
                } else if ("character".equals(dataType)) {
                    pgColumn.setDataType("character");
                    String column_default = rs.getString("column_default").trim();
                    int lastIndexOf = column_default.lastIndexOf("'");
                    if (lastIndexOf != -1) {
                        String defaultValue = column_default.substring(0, lastIndexOf + 1);
                        pgColumn.setDataDefault("' '".equals(defaultValue) ? Character.valueOf(' ') : defaultValue);
                    } else {
                        pgColumn.setDataDefault(Character.valueOf("'0'::bpchar".equals(column_default) ? (char)'0' : (char)' '));
                    }
                } else if ("timestamp without time zone".equals(dataType)) {
                    pgColumn.setDataType("timestamp");
                } else {
                    pgColumn.setDataType(dataType);
                }
                pgColumn.setColumnId(Integer.parseInt(rs.getString("ordinal_position")));
                pgQuery.add(pgColumn);
            }
            return pgQuery;
        });
        return pgRet;
    }

    @Override
    void dropAndAddColumn(Set<Column> lackedColumn) {
        StringBuilder pgAddSql = new StringBuilder(256);
        for (Column column : lackedColumn) {
            pgAddSql.setLength(0);
            pgAddSql.append("alter table ").append(this.toCompareTable).append(" add ").append(column.getColumnName()).append(' ');
            String dataType = column.getDataType();
            long dataLength = column.getDataLength();
            int dataScale = column.getDataScale();
            int dataPrecision = column.getDataPrecision();
            switch (dataType) {
                case "timestamp": {
                    pgAddSql.append("timestamp without time zone");
                    break;
                }
                case "bigint": 
                case "numeric": 
                case "integer": 
                case "smallint": {
                    pgAddSql.append(dataType);
                    break;
                }
                default: {
                    pgAddSql.append(dataType);
                    if (dataScale != 0) {
                        pgAddSql.append("(").append(dataPrecision).append(",").append(dataScale).append(")");
                        break;
                    }
                    if (dataPrecision != 0) {
                        pgAddSql.append("(").append(dataPrecision).append(")");
                        break;
                    }
                    if (dataLength == 0L) break;
                    pgAddSql.append("(").append(dataLength).append(")");
                }
            }
            if (!column.isNullable()) {
                pgAddSql.append(" NOT NULL");
            }
            if ("bigint".equals(dataType) || "numeric".equals(dataType) || "integer".equals(dataType) || "smallint".equals(dataType)) {
                pgAddSql.append(" DEFAULT 0");
            } else if ("varchar".equals(dataType)) {
                pgAddSql.append(" DEFAULT ' '");
            } else if ("character".equals(dataType) && dataLength == 1L) {
                pgAddSql.append(" DEFAULT ").append(column.getDataDefault());
            }
            this.dropColumn(this.toCompareTable, this.shardTableRoute, column);
            DB.execute((DBRoute)this.shardTableRoute, (String)KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)pgAddSql.toString())), (Object[])new Object[0]);
        }
    }

    @Override
    Map<String, List<Column>> queryIndexInColumns(Set<Column> columnSet) {
        HashMap<String, List<Column>> pgRet = new HashMap<String, List<Column>>(columnSet.size());
        String pgQueryIndexSql = "select i.relname as index_name from pg_class t, pg_class i, pg_index ix, pg_attribute a where t.oid = ix.indrelid and i.oid = ix.indexrelid and a.attrelid = t.oid and a.attnum = ANY(ix.indkey) and t.relkind = 'r' and t.relname = ? and a.attname = ? order by t.relname, i.relname";
        String pgQueryColumnExistIndexSql = "select a.attname as column_name from pg_class t, pg_class i, pg_index ix, pg_attribute a where t.oid = ix.indrelid and i.oid = ix.indexrelid and a.attrelid = t.oid and a.attnum = ANY(ix.indkey) and t.relkind = 'r' and t.relname = ? and i.relname = ? order by t.relname, i.relname;";
        for (Column column : columnSet) {
            List pgColumnList;
            String pgIndex = (String)DB.query((DBRoute)this.dbRoute, (String)KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)pgQueryIndexSql)), (Object[])new Object[]{this.compareTable, column.getColumnName()}, rs -> {
                if (rs.next()) {
                    return rs.getString("index_name");
                }
                return null;
            });
            if (null == pgIndex || !(pgColumnList = pgRet.computeIfAbsent(pgIndex, k -> new ArrayList(2))).isEmpty()) continue;
            List pgQueryColumnName = (List)DB.query((DBRoute)this.dbRoute, (String)KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)pgQueryColumnExistIndexSql)), (Object[])new Object[]{this.compareTable, pgIndex}, rs -> {
                ArrayList<String> queryColumn = new ArrayList<String>(2);
                while (rs.next()) {
                    queryColumn.add(rs.getString("column_name"));
                }
                return queryColumn;
            });
            ArrayList pgCollectColumn = new ArrayList(2);
            pgQueryColumnName.forEach(name -> {
                for (Column c : this.columns) {
                    if (!name.equals(c.getColumnName())) continue;
                    pgCollectColumn.add(c);
                    break;
                }
            });
            pgColumnList.addAll(pgCollectColumn);
        }
        return pgRet;
    }

    @Override
    protected void dropColumn(String table, Column column) {
        this.dropColumn(table, this.dbRoute, column);
    }

    @Override
    protected void dropColumn(String table, DBRoute curDBRoute, Column column) {
        boolean isExisted = (Boolean)DB.query((DBRoute)curDBRoute, (String)SQL_EXIST, (Object[])new Object[]{table, column.getColumnName()}, resultSet -> {
            if (resultSet.next()) {
                return true;
            }
            return false;
        });
        if (isExisted) {
            DB.execute((DBRoute)curDBRoute, (String)("alter table " + table + " drop column " + column.getColumnName()));
        }
    }
}

