/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.sharding.edit.ShardingCommonPlugin;
import kd.bos.cbs.plugin.tools.OperateLogUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.DisCardUtil;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.sharding.config.ShardingConfig;

public class ShardingAddConfigEditPlugin
extends ShardingCommonPlugin {
    protected static Set<String> formSet = new HashSet<String>(9);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_ensure"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Map<String, String> map;
        String property = e.getProperty().getName();
        if ("entitynumber".equals(property) && !(map = this.getSelectedEntityNumberAndNameMap()).isEmpty()) {
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            String entityNumber = map.get("number");
            if (formSet.contains(entityNumber)) {
                view.showMessage(ResManager.loadKDString((String)"\u5206\u7247\u76f8\u5173\u8868\u5355\u4e0d\u53ef\u5206\u7247\uff1a%s", (String)"ShardingAddConfigEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber}));
                model.setValue("entitynumber", null);
            }
            try {
                if (ORM.create().exists("bos_cbs_shard_config", new QFilter[]{new QFilter("entitynumber", "=", (Object)entityNumber)})) {
                    view.showMessage(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5206\u7247\u914d\u7f6e\uff1a%s", (String)"ShardingAddConfigEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber}));
                    return;
                }
                if (DB.isXDBEnable()) {
                    IDataEntityType dt = ORM.create().getDataEntityType(entityNumber);
                    ShardingConfig config = XDBConfig.getShardingConfigProvider().getConfig(dt.getAlias().toLowerCase());
                    if (null != config && !config.getName().equalsIgnoreCase(entityNumber)) {
                        view.showMessage(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u540c\u8868\u5206\u7247\u914d\u7f6e\uff1a%s", (String)"ShardingAddConfigEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[]{dt.getAlias().toLowerCase()}));
                        model.setValue("entitynumber", null);
                        return;
                    }
                }
            }
            catch (Exception exception) {
                view.showMessage(ResManager.loadKDString((String)"\u68c0\u67e5\u662f\u5426\u5df2\u5b58\u5728\u5206\u7247\u914d\u7f6e\u9519\u8bef\uff1a%s", (String)"ShardingAddConfigEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[]{exception.getMessage()}));
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_ensure".equals(key)) {
            IFormView view = this.getView();
            Object entityObj = this.getModel().getValue("entitynumber");
            if (entityObj == null) {
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5b9e\u4f53\u3002", (String)"ShardingAddConfigEditPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                this.getModel().setValue("entitynumber", null);
                return;
            }
            Map<String, Object> entityNumberMap = this.getSelectedEntityNumberAndNameILocaleStringMap();
            String entityNumber = (String)entityNumberMap.get("number");
            ILocaleString name = (ILocaleString)entityNumberMap.get("name");
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_cbs_shard_config");
            dynamicObject.set("entitynumber", (Object)entityNumber);
            dynamicObject.set("number", (Object)entityNumber);
            dynamicObject.set("name", (Object)name);
            dynamicObject.set("configstatus", (Object)ShardConfigStatusEnum.DISABLE.getKey());
            dynamicObject.set("createtime", (Object)new Date());
            long id = DB.genGlobalLongId();
            dynamicObject.set("id", (Object)id);
            QFilter qFilter = new QFilter("entitynumber", "=", (Object)entityNumber);
            boolean isExist = ORM.create().exists("bos_cbs_shard_config", qFilter.toArray());
            if (!isExist) {
                DynamicObject configTemp = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_shard_config_tpl", (String)"shardingfields,strategy,strategyzh_cn,strategyparams", (QFilter[])qFilter.and("isoem", "=", (Object)true).toArray());
                if (null != configTemp) {
                    dynamicObject.set("shardingfields", (Object)configTemp.getString("shardingfields"));
                    dynamicObject.set("strategy", (Object)configTemp.getString("strategy"));
                    dynamicObject.set("strategyzh_cn", (Object)configTemp.getString("strategyzh_cn"));
                    String params = configTemp.getString("strategyparams");
                    try {
                        JSONObject jsonObject = JSONObject.parseObject((String)params);
                        params = jsonObject.getString("strategyparams");
                    }
                    catch (Exception e) {
                        DisCardUtil.discard();
                    }
                    dynamicObject.set("strategyparams", (Object)params);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                BillShowParameter fsp = new BillShowParameter();
                fsp.setFormId("bos_cbs_shard_config");
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                fsp.getCustomParams().put("shardEntityInfoMap", entityNumberMap);
                fsp.setStatus(OperationStatus.EDIT);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CONFIG_FORM_CALL_BACK"));
                fsp.setPkId((Object)id);
                view.showForm((FormShowParameter)fsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        switch (closedCallBackEvent.getActionId()) {
            case "CONFIG_FORM_CALL_BACK": {
                IFormView view = this.getView();
                if ("bos_list".equals(view.getParentView().getFormShowParameter().getFormId())) {
                    view.getParentView().invokeOperation("refresh");
                }
                view.close();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object entityObj = this.getModel().getValue("entitynumber");
        if (entityObj == null) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        if ("btn_ensure".equals(operateKey)) {
            String entityNumber = ((DynamicObject)this.getView().getModel().getValue("entitynumber")).getString("number");
            String opName = ResManager.loadKDString((String)"\u65b0\u589e", (String)"ShardingAddConfigEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            String opDesc = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a%s\uff0c\u65b0\u589e\u5206\u7247\u914d\u7f6e\u6210\u529f\u3002", (String)"ShardingAddConfigEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), entityNumber);
            MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a%s\uff0c\u65b0\u589e\u5206\u7247\u914d\u7f6e\u6210\u529f\u3002", "ShardingAddConfigEditPlugin_5", "bos-cbs-plugin");
            OperateLogUtil.insertSimpleOperateLog(this.getView(), this.getModel().getDataEntityType().getName(), operateKey, opDesc, RequestContext.get().getOrgId(), entityNumber, langEnumBridge, entityNumber);
        }
    }

    static {
        formSet.add("bos_cbs_shard_config");
        formSet.add("bos_cbs_shard_task");
        formSet.add("bos_cbs_shard_fields");
        formSet.add("bos_cbs_shard_strategy");
        formSet.add("bos_cbs_add_config");
        formSet.add("bos_cbs_shard_params");
        formSet.add("bos_cbs_shard_log");
        formSet.add("bos_cbs_shard_name_map");
        formSet.add("bos_cbs_shard_cluster");
    }
}

