/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.cbs.plugin.sharding.common.entity.ComboDate;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ShardingArchiConditionEditPlugin
extends AbstractFormPlugin
implements Const,
Serializable {
    private static final Log logger = LogFactory.getLog(ShardingArchiConditionEditPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeBindData(EventObject e) {
        IFormView view = this.getView();
        this.initDatabaseCombo();
        String archifield = (String)view.getFormShowParameter().getCustomParam("archivefield");
        String condiDateJsonStr = (String)view.getFormShowParameter().getCustomParam("condiDate");
        this.getModel().setValue("archivefield", (Object)archifield);
        ComboDate condiDate = null;
        if (condiDateJsonStr != null && !StringUtils.isEmpty((CharSequence)condiDateJsonStr)) {
            try {
                condiDate = (ComboDate)JSONObject.parseObject((String)condiDateJsonStr, ComboDate.class);
            }
            catch (Exception exception) {
                logger.error("ShardingArchiConditionEditPlugin beforeBindDate occured an error: " + exception.getMessage());
            }
        }
        if (condiDate != null) {
            String condiType = condiDate.getComboType();
            Date endDate = condiDate.getEndDate();
            if ("1".equals(condiType)) {
                this.getModel().setValue("condifield", (Object)"1");
                Date startDate = condiDate.getStartDate();
                this.getView().getControl("daterangefield").getModel().setValue("start", (Object)startDate);
                this.getView().getControl("daterangefield").getModel().setValue("end", (Object)endDate);
            } else if ("2".equals(condiType)) {
                this.getModel().setValue("condifield", (Object)"2");
                this.getModel().setValue("datefield", (Object)endDate);
            }
        }
        this.initDatabaseCombo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if ("condifield".equals(property)) {
            this.initDatabaseCombo();
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            JSONArray entryJsonArr;
            String condifield = (String)this.getModel().getValue("condifield");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String from = ResManager.loadKDString((String)"\u4ece", (String)"ShardingConfigEditPlugin_34", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            String to = ResManager.loadKDString((String)"\u5230", (String)"ShardingConfigEditPlugin_35", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            ComboDate comboDate = this.buildComboDate();
            if (comboDate == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5e74\u4efd\u3002", (String)"ShardingConfigEditPlugin_33", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            if (!this.checkMaxYear(comboDate)) {
                String msg = String.format(ResManager.loadKDString((String)"\u6240\u9009\u5e74\u4efd\u4e0d\u5f97\u5927\u4e8e%s", (String)"ShardingConfigEditPlugin_42", (String)"bos-cbs-plugin", (Object[])new Object[0]), this.maxYear());
                this.getView().showMessage(msg);
                return;
            }
            String lessthan = ResManager.loadKDString((String)"\u65e9\u4e8e", (String)"ShardingConfigEditPlugin_52", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            if (("1".equals(condifield) || "2".equals(condifield)) && (entryJsonArr = (JSONArray)this.getView().getFormShowParameter().getCustomParam("entryentity")) != null && !entryJsonArr.isEmpty()) {
                List entryEntityJsonObjects = entryJsonArr.toJavaList(JSONObject.class);
                for (JSONObject jsonObject : entryEntityJsonObjects) {
                    ComboDate otherDate;
                    String archiCondiJson;
                    if (jsonObject.get((Object)"rangejudgecode") == null || jsonObject.get((Object)"rangejudgecode").equals(0) || jsonObject.get((Object)"rangejudgecode").equals(this.getView().getFormShowParameter().getCustomParam("rangejudgecode")) || StringUtils.isEmpty((CharSequence)(archiCondiJson = (String)jsonObject.get((Object)"archicondijson"))) || !comboDate.overlaps(otherDate = (ComboDate)JSONObject.parseObject((String)archiCondiJson, ComboDate.class))) continue;
                    String formatComboDesc = "";
                    if ("1".equals(otherDate.getComboType())) {
                        String formattedStartDate = dateFormat.format(otherDate.getStartDate());
                        String formattedEndDate = dateFormat.format(otherDate.getEndDate());
                        formatComboDesc = String.format("%s %s %s %s", from, formattedStartDate, to, formattedEndDate);
                    } else if ("2".equals(otherDate.getComboType())) {
                        String formattedDate = dateFormat.format(otherDate.getEndDate());
                        formatComboDesc = String.format("%s %s", lessthan, formattedDate);
                    }
                    String tip = ResManager.loadKDString((String)"\u4e0e\u5df2\u5b58\u5728\u7684\u65f6\u95f4\u533a\u95f4\u91cd\u53e0\uff1a", (String)"ShardingConfigEditPlugin_37", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                    this.getView().showMessage(tip + formatComboDesc);
                    return;
                }
            }
            if ("1".equals(condifield) && !comboDate.getEndDate().after(comboDate.getStartDate())) {
                String tip = ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u8981\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4\u3002", (String)"ShardingConfigEditPlugin_38", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tip, Integer.valueOf(2500));
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            JSONObject json = (JSONObject)JSONObject.toJSON((Object)comboDate);
            map.put("condiDate", json);
            map.put("archicondidesc", comboDate.toDesc());
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private ComboDate buildComboDate() {
        String condifield = (String)this.getModel().getValue("condifield");
        ComboDate comboDate = null;
        if ("1".equals(condifield)) {
            Date startDate = (Date)this.getView().getControl("daterangefield").getModel().getValue("start");
            Date endDate = (Date)this.getView().getControl("daterangefield").getModel().getValue("end");
            if (startDate == null || endDate == null) {
                return null;
            }
            LocalDateTime localDateTime = LocalDateTime.ofInstant(startDate.toInstant(), ZoneId.systemDefault());
            LocalDateTime newLocalDateTime = LocalDateTime.of(localDateTime.getYear(), Month.JANUARY, 1, 0, 0, 0, 0);
            Date newStartDate = Date.from(newLocalDateTime.atZone(ZoneId.systemDefault()).toInstant());
            LocalDateTime localDateTime2 = LocalDateTime.ofInstant(endDate.toInstant(), ZoneId.systemDefault());
            LocalDateTime newLocalDateTime2 = LocalDateTime.of(localDateTime2.getYear(), Month.JANUARY, 1, 0, 0, 0, 0);
            Date newEndDate = Date.from(newLocalDateTime2.atZone(ZoneId.systemDefault()).toInstant());
            comboDate = new ComboDate();
            comboDate.setComboType("1");
            comboDate.setStartDate(newStartDate);
            comboDate.setEndDate(newEndDate);
        } else if ("2".equals(condifield)) {
            Date date = (Date)this.getModel().getValue("datefield");
            if (date == null) {
                return null;
            }
            LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            LocalDateTime newLocalDateTime = LocalDateTime.of(localDateTime.getYear(), Month.JANUARY, 1, 0, 0, 0, 0);
            Date newDate = Date.from(newLocalDateTime.atZone(ZoneId.systemDefault()).toInstant());
            comboDate = new ComboDate();
            comboDate.setComboType("2");
            comboDate.setEndDate(newDate);
        }
        return comboDate;
    }

    private void initDatabaseCombo() {
        IDataModel model = this.getModel();
        String condifield = (String)model.getValue("condifield");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"daterangefield"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"datefield"});
        if (StringUtils.isNotEmpty((CharSequence)condifield)) {
            if ("1".equals(condifield = condifield.toLowerCase())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"daterangefield"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"datefield"});
            } else if ("2".equals(condifield)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"daterangefield"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"datefield"});
            }
        }
    }

    private boolean checkMaxYear(ComboDate comboDate) {
        int maxYear = this.maxYear();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(comboDate.getEndDate());
        int year = calendar.get(1);
        return year <= maxYear;
    }

    private int maxYear() {
        LocalDate julyFirst;
        LocalDate currentDate = LocalDate.now();
        int maxYear = currentDate.isBefore(julyFirst = LocalDate.of(currentDate.getYear(), 7, 1)) ? LocalDate.now().getYear() - 1 : LocalDate.now().getYear();
        return maxYear;
    }
}

