/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import com.alibaba.fastjson.JSONObject;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.cbs.plugin.sharding.common.entity.ComboDate;
import kd.bos.cbs.plugin.sharding.common.util.ShardingStrategyFormUtils;
import kd.bos.cbs.plugin.tools.LicenseUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.archive.ArchiveInfo;
import kd.bos.db.archive.MCArchive;
import kd.bos.db.archive.RouteInfo;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.plugin.IListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.NetAddressUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.enums.ShardFastIndexStatusEnum;
import kd.bos.xdb.enums.ShardTaskNodeEnum;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.enums.ShardTaskTypeEnum;
import kd.bos.xdb.enums.ShardTaskWarningStatusEnum;
import kd.bos.xdb.mservice.ShardingMetadataService;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.service.ShardTaskService;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;

public class ShardingArchiEditPlugin
extends AbstractFormPlugin
implements Const,
RowClickEventListener,
IListPlugin {
    private static final Log logger = LogFactory.getLog(ShardingArchiEditPlugin.class);
    final String sharding_table_deli = "$";
    final String sharding_fields_split = ",";

    public void initialize() {
        ((EntryGrid)this.getView().getControl("entryentity")).addPackageDataListener(new ShardArchiPackageDataListener()::packageData);
        super.initialize();
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"archicondidesc"});
        this.addClickListeners(new String[]{"archivefield"});
        this.addClickListeners(new String[]{"targetdatabase"});
        this.addClickListeners(new String[]{"targetroute2"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseUtils.checkPerformGroup(e, "CBS_ARCHIVE");
    }

    public void afterBindData(EventObject e) {
        String archiveField;
        String entityNumber = (String)this.getModel().getValue("entitynumber");
        List<IDataEntityProperty> dps = ShardingStrategyFormUtils.getEntityPropertiesForSharding(entityNumber, false);
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("shardEntityInfoMap");
        String shardingFields = jsonObject.getString("shardingfields");
        String[] fields = shardingFields.split(",");
        HashSet<String> shardingFieldsSet = new HashSet<String>(Arrays.asList(fields));
        ArrayList<ComboItem> fieldsComboList = new ArrayList<ComboItem>();
        for (IDataEntityProperty dp : dps) {
            if (!shardingFieldsSet.contains(dp.getName()) || !(dp instanceof DateTimeProp)) continue;
            LocaleString displayName = dp.getDisplayName();
            ComboItem item = new ComboItem(new LocaleString(dp.getName() + " (" + displayName.toString() + ")"), dp.getName());
            fieldsComboList.add(item);
        }
        ComboEdit archiFieldComboEdit = (ComboEdit)this.getControl("archivefield");
        archiFieldComboEdit.setComboItems(fieldsComboList);
        IPageCache pageCache = this.getPageCache();
        pageCache.put("shardingFieldsSet", String.join((CharSequence)",", shardingFieldsSet));
        pageCache.put("shardingfields", shardingFields);
        if ("0".equals(this.getModel().getValue("status"))) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"enablearchiving"});
        }
        if (kd.bos.util.StringUtils.isEmpty((String)((String)this.getModel().getValue("archivefield")))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"enablearchiving"});
            if (fieldsComboList.size() == 1) {
                pageCache.put("init", "true");
                this.getModel().setValue("archivefield", (Object)((ComboItem)fieldsComboList.get(0)).getValue());
            }
        }
        if (!shardingFieldsSet.contains(archiveField = (String)this.getModel().getValue("archivefield"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"enablearchiving"});
        }
        super.afterBindData(e);
    }

    public void beforeBindData(EventObject e) {
        Set<ArchiveInfo> allArchiveInfoSet = this.getAllArchiveInfoSet();
        if (allArchiveInfoSet.isEmpty()) {
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboEdit archiveRoute = (ComboEdit)this.getControl("targetroute2");
        for (ArchiveInfo archiveInfo : allArchiveInfoSet) {
            ComboItem item = new ComboItem(new LocaleString(archiveInfo.getName()), archiveInfo.getKey());
            comboItems.add(item);
        }
        archiveRoute.setComboItems(comboItems);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        JSONObject map = (JSONObject)view.getFormShowParameter().getCustomParam("shardEntityInfoMap");
        if (map == null) {
            view.showMessage(ResManager.loadKDString((String)"\u53ea\u6709\u5206\u8868\u5355\u636e\u624d\u53ef\u65b0\u589e\uff0c\u8bf7\u4ece\u5206\u7247\u914d\u7f6e\u8fdb\u5165\u3002", (String)"ShardingFastIndexEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            view.close();
            return;
        }
        Object configPK = map.get((Object)"config");
        if (Objects.isNull(configPK)) {
            view.showMessage(ResManager.loadKDString((String)"\u53ea\u6709\u5206\u8868\u5355\u636e\u624d\u53ef\u65b0\u589e\uff0c\u8bf7\u4ece\u5206\u7247\u914d\u7f6e\u8fdb\u5165\u3002", (String)"ShardingFastIndexEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            view.close();
        }
    }

    public void click(EventObject evt) {
        Control evtSource = (Control)evt.getSource();
        String key = evtSource.getKey();
        IFormView view = this.getView();
        if ("archicondidesc".equals(key)) {
            String rowIndexStr = this.getPageCache().get("rowIndex");
            if (kd.bos.util.StringUtils.isEmpty((String)rowIndexStr)) {
                return;
            }
            int rowIndex = Integer.parseInt(rowIndexStr);
            String archiFiled = (String)this.getModel().getValue("archivefield");
            String archicondijson = (String)this.getModel().getValue("archicondijson", rowIndex);
            if (kd.bos.util.StringUtils.isEmpty((String)archiFiled)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f52\u6863\u5c5e\u6027\u3002", (String)"ShardingConfigEditPlugin_31", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            Long entryid = (Long)((DynamicObject)entryEntity.get(rowIndex)).get("rangejudgecode");
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_cbs_shard_archicondi");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.getCustomParams().put("archivefield", archiFiled);
            fsp.getCustomParams().put("condiDate", archicondijson);
            fsp.getCustomParams().put("entryentity", entryEntity);
            fsp.getCustomParams().put("rangejudgecode", entryid);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CONDITION_FORM_CALL_BACK"));
            view.showForm(fsp);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        IDataModel model = this.getModel();
        Long idObj = (Long)model.getValue("id");
        if (idObj == null || idObj == 0L || !QueryServiceHelper.exists((String)"bos_cbs_shard_archi", (Object)idObj)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u53ef\u80fd\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ShardingArchiEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        IFormView view = this.getView();
        if ("save".equals(operateKey)) {
            if (!this.checkParams()) {
                e.setCancel(true);
                return;
            }
            Long version = (Long)this.getModel().getValue("version");
            version = version + 1L;
            this.getModel().setValue("version", (Object)version);
        } else if ("newentry".equals(operateKey)) {
            String archiFiled = (String)model.getValue("archivefield");
            if (kd.bos.util.StringUtils.isEmpty((String)archiFiled)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f52\u6863\u5c5e\u6027\u3002", (String)"ShardingConfigEditPlugin_31", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else if ("enablearchiving".equals(operateKey)) {
            if (DB.isXDBEnable()) {
                String entityNumber = (String)model.getValue("entitynumber");
                ShardTaskService.get().submitChangeTask(entityNumber);
                if (!this.checkParams()) {
                    e.setCancel(true);
                    return;
                }
                Long version = (Long)model.getValue("version");
                version = version + 1L;
                model.setValue("version", (Object)version);
                SaveServiceHelper.update((DynamicObject)model.getDataEntity());
                try {
                    this.saveRouteChangeDetail();
                }
                catch (Exception ex) {
                    logger.error("saveRouteChangeDetail occur an error: " + ex.getMessage());
                }
                view.invokeOperation("refresh");
                QFilter archirtFilter = new QFilter("entitynumber.number", "=", (Object)entityNumber);
                archirtFilter.and(new QFilter("version", "=", (Object)version));
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_cbs_shard_archirt", (String)"id", (QFilter[])archirtFilter.toArray());
                if (collection == null || collection.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5206\u7247\u8868\u53d1\u751f\u8def\u7531\u53d8\u66f4\uff0c\u65e0\u9700\u6267\u884c\u5206\u5e93\u8fc1\u79fb\u4efb\u52a1\u3002", (String)"ShardingConfigEditPlugin_53", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                String confirmTip = ResManager.loadKDString((String)"\u542f\u7528\u8fc7\u7a0b\u4e2d\u8868\u5355\u8bfb\u5199\u64cd\u4f5c\u4f1a\u88ab\u9501\u5b9a\uff0c\u4e1a\u52a1\u5c06\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ShardingConfigEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("enablearchiving");
                view.showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u6c34\u5e73\u5206\u8868\u914d\u7f6e\u3002", (String)"ShardingConfigEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
        } else if ("enable".equals(operateKey)) {
            String entityNumber = (String)model.getValue("entitynumber");
            this.checkBeforeArchive(e);
            Object shardConfigId = ((DynamicObject)model.getValue("configid")).getPkValue();
            Object id = model.getValue("id");
            String selectFields = "status,operationlog";
            DynamicObject archiConfig = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_shard_archi", (String)selectFields, (QFilter[])new QFilter("id", "=", id).and("entitynumber", "=", (Object)entityNumber).toArray());
            if (archiConfig != null) {
                String fastIndexStatus;
                String archiStatus = (String)archiConfig.get("status");
                if (Objects.nonNull(archiStatus) && ShardFastIndexStatusEnum.ENABLING.getKey().equals(archiStatus)) {
                    view.showMessage(ResManager.loadKDString((String)"\u5206\u8868\u5f52\u6863\u542f\u7528\u4e2d\uff0c\u8bf7\u7b49\u5f85\u8fc1\u79fb\u5b8c\u6210\u3002", (String)"ShardingConfigEditPlugin_46", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject fastIndexConfig = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_shard_fast_index", (String)"fastindex,lastfastindex,operationlog,status", (QFilter[])new QFilter("config", "=", shardConfigId).and("entitynumber", "=", (Object)entityNumber).toArray());
                if (fastIndexConfig != null && Objects.nonNull(fastIndexStatus = (String)fastIndexConfig.get("status")) && ShardFastIndexStatusEnum.ENABLING.getKey().equals(fastIndexStatus)) {
                    view.showMessage(ResManager.loadKDString((String)"\u5feb\u901f\u7d22\u5f15\u914d\u7f6e\u542f\u7528\u4e2d\uff0c\u8bf7\u7b49\u5f85\u8fc1\u79fb\u5b8c\u6210\u3002", (String)"ShardingFastIndexEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                String ip = NetAddressUtils.getLocalIpAddress();
                RequestContext rc = RequestContext.get();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String operationLog = String.format(ResManager.loadKDString((String)"%1$s -> shard archi enable, archi field\uff1a\u3010%2$s\u3011, instance=%3$s@%4$s\uff0centity=%5$s\uff0caccount=%6$s\uff0ctenant=%7$s.", (String)"ShardingAddArchiConfigEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]), sdf.format(new Date()), model.getValue("archivefield"), Instance.getInstanceId(), ip, entityNumber, rc.getAccountId(), rc.getTenantId());
                String opLogLoad = archiConfig.getString("operationlog");
                operationLog = ShardingStrategyFormUtils.getSpliceOperationLog(opLogLoad, operationLog);
                model.setValue("operationlog", (Object)operationLog);
                String rwMark = ShardingManager.get().notifyLimitTableRW(ORMConfiguration.innerGetDataEntityType((String)entityNumber, null).getAlias(), false);
                model.setValue("rwmark", (Object)rwMark);
                SaveServiceHelper.update((DynamicObject)model.getDataEntity(true));
            }
            ShardingStrategyFormUtils.releaseShardingConfigLock();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("save".equals(operateKey)) {
            try {
                this.saveRouteChangeDetail();
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"enablearchiving"});
            }
            catch (SQLException | ParseException ex) {
                logger.error("error occured when saveRouteChangeDetail: " + ex.getMessage());
            }
            this.getView().invokeOperation("refresh");
        } else if ("enable".equals(operateKey)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_cbs_shard_task");
            dynamicObject.set("config", model.getDataEntity().getPkValue());
            dynamicObject.set("tasktype", (Object)ShardTaskTypeEnum.SHARDARCHIVE.getKey());
            dynamicObject.set("tasknode", (Object)ShardTaskNodeEnum.CLUSTERTBLOCK.getKey());
            dynamicObject.set("taskstatus", (Object)ShardTaskStatusEnum.UNEXECUTED.getKey());
            dynamicObject.set("warningstatus", (Object)ShardTaskWarningStatusEnum.NORMAL.getKey());
            dynamicObject.set("entitynumber", model.getValue("entitynumber"));
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("version", (Object)2);
            dynamicObject.set("archivefield", this.getModel().getValue("archivefield"));
            if (XDBConfig.get().isDevMode()) {
                String ip = NetAddressUtils.getLocalIpAddress();
                dynamicObject.set("host", (Object)ip);
            }
            Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            String rwMark = (String)model.getValue("rwmark");
            DynamicObject configid = (DynamicObject)model.getValue("configid");
            long configId = (Long)configid.getPkValue();
            ShardConfigRepository.get().setConfigRWmark(configId, rwMark, ShardConfigStatusEnum.ENABLE);
            ShardConfigRepository.get().setConfigstatus(configId, ShardConfigStatusEnum.ENABLE, ShardConfigStatusEnum.ARCHIVEMOVE);
            view.invokeOperation("refresh");
            if (save.length > 0) {
                Object taskPkValue = ((DynamicObject)save[0]).getPkValue();
                BillShowParameter bsp = new BillShowParameter();
                bsp.setStatus(OperationStatus.EDIT);
                bsp.setFormId("bos_cbs_shard_task");
                bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bsp.setPkId(taskPkValue);
                bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "TASK_FORM_CALL_BACK"));
                bsp.setCaption(ResManager.loadKDString((String)"\u5206\u5e93\u4efb\u52a1", (String)"ShardingConfigEditPlugin_51", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                view.showForm((FormShowParameter)bsp);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.getPageCache().put("rowIndex", String.valueOf(row));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if ("archicondidesc".equals(property)) {
            String value = (String)this.getModel().getValue("archicondidesc");
            if (kd.bos.util.StringUtils.isEmpty((String)value)) {
                this.getModel().setValue("archicondijson", (Object)"");
            }
        } else if ("archivefield".equals(property)) {
            DynamicObjectCollection archiCondiCollection = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < archiCondiCollection.size(); ++i) {
                this.getModel().setValue("archivefield2", this.getModel().getValue("archivefield"), i);
            }
            if (!"true".equals(this.getPageCache().get("init")) && !"true".equals(this.getPageCache().get("restoreArchive"))) {
                this.getPageCache().put("archiveFieldBak", (String)e.getChangeSet()[0].getOldValue());
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                if (entryentity != null && entryentity.size() > 0) {
                    String confirmTip = ResManager.loadKDString((String)"\u66f4\u6539\u5f52\u6863\u5c5e\u6027\uff0c\u5c06\u91cd\u7f6e\u5f52\u6863\u914d\u7f6e\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ShardingArchiveEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("archiveFieldChange");
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
                }
            }
            this.getPageCache().put("restoreArchive", "false");
        }
        if (!"status".equals(property)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"enablearchiving"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        String actionId = closedCallBackEvent.getActionId();
        Object retData = closedCallBackEvent.getReturnData();
        if (retData == null) {
            return;
        }
        switch (actionId) {
            case "FIELDS_FORM_CALL_BACK": {
                String rowIndexStr = this.getPageCache().get("rowIndex");
                if (!kd.bos.util.StringUtils.isEmpty((String)rowIndexStr)) break;
                return;
            }
            case "TASK_FORM_CALL_BACK": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "CONDITION_FORM_CALL_BACK": {
                ComboDate condiDate = null;
                Map retDataMap = null;
                try {
                    retDataMap = (Map)retData;
                }
                catch (Exception e) {
                    logger.error("retData cast to map error");
                }
                if (retDataMap == null) {
                    return;
                }
                try {
                    if (retDataMap.containsKey("condiDate")) {
                        JSONObject jsonObject = (JSONObject)retDataMap.get("condiDate");
                        condiDate = (ComboDate)JSONObject.parseObject((String)jsonObject.toJSONString(), ComboDate.class);
                    }
                }
                catch (Exception e) {
                    logger.error("error occured when parse condidate: " + e.getMessage());
                }
                if (condiDate == null) break;
                String indexStr = this.getPageCache().get("rowIndex");
                if (kd.bos.util.StringUtils.isEmpty((String)indexStr)) {
                    return;
                }
                int index = Integer.parseInt(indexStr);
                this.buildArchiCondiItem(index, condiDate, model, retDataMap);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            if (messageBoxClosedEvent.getCallBackId().equals("enablearchiving")) {
                this.getView().invokeOperation("enable");
            } else if (messageBoxClosedEvent.getCallBackId().equals("archiveFieldChange")) {
                this.getModel().deleteEntryData("entryentity");
            }
        } else if (messageBoxClosedEvent.getCallBackId().equals("archiveFieldChange")) {
            this.getPageCache().put("restoreArchive", "true");
            this.getModel().setValue("archivefield", (Object)this.getPageCache().get("archiveFieldBak"));
        }
    }

    private boolean checkParams() {
        DynamicObjectCollection entryentity;
        String archiveField;
        String shardingFieldSetStr = this.getPageCache().get("shardingFieldsSet");
        HashSet<String> shardingFieldsSet = new HashSet<String>(Arrays.asList(shardingFieldSetStr.split(",")));
        if (!shardingFieldsSet.contains(archiveField = (String)this.getModel().getValue("archivefield"))) {
            this.getModel().setValue("archivefield", (Object)"");
        }
        if ((entryentity = this.getModel().getEntryEntity("entryentity")).isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5f52\u6863\u6761\u4ef6\u3002", (String)"ShardingConfigEditPlugin_41", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return false;
        }
        boolean isIntact = true;
        for (DynamicObject dynamicObject : entryentity) {
            String archiconditiondesc = (String)dynamicObject.get("archicondidesc");
            String database = (String)dynamicObject.get("targetroute2");
            if (!kd.bos.util.StringUtils.isEmpty((String)archiconditiondesc) && !kd.bos.util.StringUtils.isEmpty((String)database)) continue;
            isIntact = false;
            break;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)((String)this.getModel().getValue("archivefield")))) {
            isIntact = false;
        }
        if (!isIntact) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u586b\u5199\u5f52\u6863\u914d\u7f6e\u548c\u5f52\u6863\u5c5e\u6027\u3002", (String)"ShardingConfigEditPlugin_36", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Set<ArchiveInfo> getAllArchiveInfoSet() {
        String entityNumber = (String)this.getModel().getValue("entitynumber");
        IDataEntityType dt = ORMConfiguration.innerGetDataEntityType((String)entityNumber, null);
        String dbRouteKey = dt.getDBRouteKey();
        RouteInfo routeInfo = MCArchive.get((String)dbRouteKey);
        List archiveInfo = routeInfo.getArchiveInfo();
        TreeSet<ArchiveInfo> archiveInfoSet = new TreeSet<ArchiveInfo>(Comparator.comparing(ArchiveInfo::getKey));
        for (ArchiveInfo info : archiveInfo) {
            if (dbRouteKey.equals(info.getKey())) continue;
            archiveInfoSet.add(info);
        }
        return archiveInfoSet;
    }

    private void saveRouteChangeDetail() throws SQLException, ParseException {
        Long id = (Long)this.getModel().getValue("id");
        if (id == null) {
            return;
        }
        DynamicObjectCollection archiCondiCollection = this.getModel().getEntryEntity("entryentity");
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"bos_cbs_shard_archirt");
        List<DynamicObject> routealterRecords = this.buildRouteChangeDetail(archiCondiCollection);
        if (routealterRecords.size() > 0) {
            SaveServiceHelper.save((IDataEntityType)dynamicObjectType, (Object[])routealterRecords.toArray());
        }
    }

    private List<DynamicObject> buildRouteChangeDetail(DynamicObjectCollection archiCondiCollection) throws SQLException {
        String archiveField = (String)this.getModel().getValue("archivefield");
        String entityNumber = (String)this.getModel().getValue("entitynumber");
        ArrayList<DynamicObject> archiRouteList = new ArrayList<DynamicObject>();
        HashMap<Long, Long> indexArchiCondiMap = new HashMap<Long, Long>();
        HashMap<Long, String> indexTableMap = new HashMap<Long, String>();
        HashMap<Long, DynamicObject> archiCondiCollectionMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject archiCondi : archiCondiCollection) {
            archiCondiCollectionMap.put((Long)archiCondi.get("id"), archiCondi);
            String archiCondiJson = (String)archiCondi.get("archicondijson");
            ComboDate comboDate = (ComboDate)JSONObject.parseObject((String)archiCondiJson, ComboDate.class);
            HashMap<String, Date> params = new HashMap<String, Date>(2);
            if (comboDate.getComboType().equals("1")) {
                params.put(archiveField + "$>=", comboDate.getStartDate());
            }
            params.put(archiveField + "$<", comboDate.getEndDate());
            List shardingTableNames = ShardingMetadataService.getInstance().getShardingTableName(entityNumber, params);
            for (String shardingTableName : shardingTableNames) {
                JSONObject jsonObject;
                String strategy;
                String index = shardingTableName.substring(shardingTableName.indexOf("$") + 1);
                if ("0".equals(index) && ("DateYearStrategy".equals(strategy = (jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("shardEntityInfoMap")).getString("strategy")) || "DateMonthStrategy".equals(strategy) || "DateDayStrategy".equals(strategy)) || index.equals("_")) continue;
                long indexLong = Long.parseLong(index);
                indexTableMap.put(indexLong, shardingTableName);
                indexArchiCondiMap.put(indexLong, (Long)archiCondi.get("id"));
            }
        }
        ShardConfigEntity shardConfigEntity = ShardConfigRepository.get().loadConfig(entityNumber);
        List shardingConfigs = shardConfigEntity.toShardingConfigs();
        ShardingConfig sc = (ShardingConfig)shardingConfigs.get(0);
        String originalName = TableName.of((String)sc.getTable()).getOriginalName();
        Map<Long, String> indexOriginalRouteMap = this.queryOriginRouteMap(entityNumber, originalName);
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"bos_cbs_shard_archirt");
        for (Long index : indexArchiCondiMap.keySet()) {
            DynamicObject archiRouteDetail = new DynamicObject((DynamicObjectType)dynamicObjectType);
            Long archiCondiId = (Long)indexArchiCondiMap.get(index);
            DynamicObject archiCondi = (DynamicObject)archiCondiCollectionMap.get(archiCondiId);
            String targetRoute = (String)archiCondi.get("targetroute2");
            String originalRoute = indexOriginalRouteMap.getOrDefault(index, "");
            if (originalRoute.equals(targetRoute)) continue;
            if (kd.bos.util.StringUtils.isEmpty((String)originalRoute)) {
                originalRoute = EntityMetadataCache.getDataEntityType((String)entityNumber).getDBRouteKey();
            }
            long id = ID.genLongId();
            archiRouteDetail.set("id", (Object)id);
            archiRouteDetail.set("createtime", (Object)new Date());
            archiRouteDetail.set("modifytime", (Object)new Date());
            archiRouteDetail.set("entitynumber", (Object)entityNumber);
            archiRouteDetail.set("shardtable", indexTableMap.get(index));
            archiRouteDetail.set("archicondiid", (Object)archiCondiId);
            archiRouteDetail.set("archiconfigid", this.getModel().getValue("id"));
            archiRouteDetail.set("version", this.getModel().getValue("version"));
            archiRouteDetail.set("index", (Object)index);
            archiRouteDetail.set("originalroute", (Object)originalRoute);
            archiRouteDetail.set("targetroute", (Object)targetRoute);
            archiRouteDetail.set("archivefield", this.getModel().getValue("archivefield"));
            archiRouteDetail.set("originaltable", (Object)originalName);
            archiRouteList.add(archiRouteDetail);
        }
        return archiRouteList;
    }

    private Map<Long, String> queryOriginRouteMap(String entityNumber, String originalTable) throws SQLException {
        String[] shardingTable;
        HashMap<Long, String> indexOriginalRouteMap = new HashMap<Long, String>();
        MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getConfigByEntity(entityNumber);
        Set allArchiveRoutes = mainConfig.getOptions().getIndexRoute().getAllArchiveRoutes();
        if (allArchiveRoutes.isEmpty()) {
            return indexOriginalRouteMap;
        }
        TableManager tm = XDBConfig.getTableManager();
        for (String shardTable : shardingTable = tm.getShardingTable(originalTable)) {
            String shardRoute = mainConfig.getOptions().getIndexRoute().getRoute(shardTable);
            if (!kd.bos.util.StringUtils.isNotEmpty((String)shardRoute)) continue;
            indexOriginalRouteMap.put(TableName.of((String)shardTable).getShardingIndex(), shardRoute);
        }
        return indexOriginalRouteMap;
    }

    private void buildArchiCondiItem(int entryIndex, ComboDate comboDate, IDataModel model, Map<String, Object> retDataMap) {
        model.setValue("archicondijson", (Object)((JSONObject)retDataMap.get("condiDate")).toJSONString(), entryIndex);
        model.setValue("rangejudgecode", (Object)ID.genLongId(), entryIndex);
        String condiDateDesc = (String)retDataMap.get("archicondidesc");
        model.setValue("archicondidesc", (Object)condiDateDesc, entryIndex);
        model.setValue("conditioncode", (Object)Integer.parseInt(comboDate.getComboType()), entryIndex);
        model.setValue("archivefield2", model.getValue("archivefield"), entryIndex);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startDateStr = comboDate.getStartDate() == null ? " " : dateFormat.format(comboDate.getStartDate());
        String endDateStr = dateFormat.format(comboDate.getEndDate());
        model.setValue("leftvalue", (Object)startDateStr, entryIndex);
        model.setValue("rightvalue", (Object)endDateStr, entryIndex);
    }

    private void checkBeforeArchive(BeforeDoOperationEventArgs be) {
        ShardConfigStatusEnum configStatus;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String entityNumber = (String)model.getValue("entitynumber");
        ShardConfigEntity shardConfigEntity = ShardConfigRepository.get().loadConfig(entityNumber);
        if (shardConfigEntity != null && ShardConfigStatusEnum.MOVEINDEX == (configStatus = shardConfigEntity.getConfigstatus())) {
            view.showMessage(ResManager.loadKDString((String)"\u7d22\u5f15\u8fc1\u79fb\u4e2d\uff0c\u8bf7\u68c0\u67e5\u5206\u7247\u914d\u7f6e\u6216\u7d22\u5f15\u8fc1\u79fb\u8bb0\u5f55\u3002", (String)"ShardingFastIndexEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            be.setCancel(true);
            return;
        }
        Boolean lockValid = ShardingStrategyFormUtils.shardingLock("config", entityNumber);
        if (lockValid == null || !lockValid.booleanValue()) {
            view.showMessage(ResManager.loadKDString((String)"\u914d\u7f6e\u5df2\u88ab\u64cd\u4f5c\uff0c\u8bf7\u5148\u68c0\u67e5\u914d\u7f6e\u7684\u6b63\u786e\u6027\u3002", (String)"ShardingConfigEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            be.setCancel(true);
        }
    }

    static class ShardArchiPackageDataListener
    extends AbstractListPlugin {
        ShardArchiPackageDataListener() {
        }

        public void packageData(PackageDataEvent e) {
            String fieldKey;
            if (e.getSource() instanceof TextEdit && "archicondidesc".equals(fieldKey = ((TextEdit)e.getSource()).getFieldKey()) && !StringUtils.isEmpty((Object)e.getRowData().get("archicondidesc"))) {
                String archicondijson = (String)e.getRowData().get("archicondijson");
                ComboDate otherDate = (ComboDate)JSONObject.parseObject((String)archicondijson, ComboDate.class);
                e.setFormatValue((Object)otherDate.toDesc());
            }
        }
    }
}

