/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.sharding.tablerw.DBTableRWNotifier;
import kd.bos.db.sharding.tablerw.ZKWatichConfirmNotifier;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ShardingClusterEditPlugin
extends AbstractFormPlugin
implements Const {
    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        if (Objects.nonNull(customParams)) {
            IDataModel model = this.getModel();
            model.deleteEntryData("entryentity");
            long configId = (Long)customParams.get("config");
            String tableName = (String)customParams.get("tableName");
            String entityNumber = (String)customParams.get("entityNumber");
            DynamicObject configLoad = BusinessDataServiceHelper.loadSingle((Object)configId, (String)"bos_cbs_shard_config");
            ZKWatichConfirmNotifier notifierTableRW = DBTableRWNotifier.confirmNotifierTableRW((String)entityNumber, (String)tableName, (String)configLoad.getString("rwmark"));
            if (!notifierTableRW.isConfirmAll()) {
                Set tobeNotifier = notifierTableRW.getTobeNotifier();
                ArrayList cellStyles = new ArrayList(tobeNotifier.size());
                tobeNotifier.forEach(node -> {
                    int rowIndex = model.createNewEntryRow("entryentity");
                    model.setValue("instance", node, rowIndex);
                    model.setValue("instance_status", (Object)"error", rowIndex);
                    CellStyle cellStyle = new CellStyle();
                    cellStyle.setFieldKey("instance_status");
                    cellStyle.setRow(rowIndex);
                    cellStyle.setForeColor("#ff0000");
                    cellStyles.add(cellStyle);
                });
                notifierTableRW.getHasNotifier().forEach(node -> {
                    int rowIndex = model.createNewEntryRow("entryentity");
                    model.setValue("instance", node, rowIndex);
                    model.setValue("instance_status", (Object)"normal", rowIndex);
                });
                EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
                entryGrid.setCellStyle(cellStyles);
            }
        }
    }
}

