/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import java.util.HashMap;
import java.util.Map;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class ShardingCommonPlugin
extends AbstractFormPlugin
implements Const,
ClickListener {
    private static final Log logger = LogFactory.getLog(ShardingCommonPlugin.class);

    protected boolean validateEntity(Map<String, String> map) {
        if (map != null) {
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            String entityName = map.get("number");
            if ("bos_cbs_shard_config".equals(entityName) || "bos_cbs_shard_task".equals(entityName) || "bos_cbs_shard_fields".equals(entityName) || "bos_cbs_shard_strategy".equals(entityName)) {
                view.showMessage(ResManager.loadKDString((String)"\u5206\u7247\u76f8\u5173\u8868\u5355\u4e0d\u53ef\u5206\u7247\uff1a%s\u3002", (String)"ShardingCommonPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[]{entityName}));
                model.setValue("entitynumber", null);
                return false;
            }
            try {
                if (ORM.create().exists("bos_cbs_shard_config", new QFilter[]{new QFilter("entitynumber", "=", (Object)entityName), new QFilter("id", "!=", model.getValue("id"))})) {
                    view.showMessage(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5206\u7247\u914d\u7f6e\uff1a%s\u3002", (String)"ShardingCommonPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[]{entityName}));
                    model.setValue("entitynumber", null);
                    model.setValue("shardingfields", null);
                    model.setValue("strategy", null);
                    model.setValue("strategyzh_cn", null);
                    return false;
                }
            }
            catch (Exception e) {
                logger.error("kd.bos.cbs.plugin.sharding.edit.ShardingCommonPlugin ERROR: ", (Throwable)e);
                view.showMessage(ResManager.loadKDString((String)"\u68c0\u67e5\u662f\u5426\u5df2\u5b58\u5728\u5206\u7247\u914d\u7f6e\u9519\u8bef\uff1a%s\u3002", (String)"ShardingCommonPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[]{e.getMessage()}));
                model.setValue("entitynumber", null);
                return false;
            }
        }
        return true;
    }

    protected Map<String, String> getSelectedEntityNumberAndNameMap() {
        HashMap<String, String> result = new HashMap<String, String>(2);
        DynamicObject curBill = (DynamicObject)this.getModel().getValue("entitynumber");
        if (curBill != null) {
            BasedataEntityType rdType = (BasedataEntityType)curBill.getDataEntityType();
            result.put("number", (String)curBill.get(rdType.getNumberProperty()));
            result.put("name", ((ILocaleString)curBill.get(rdType.getNameProperty())).getLocaleValue());
        }
        return result;
    }

    protected Map<String, Object> getSelectedEntityNumberAndNameILocaleStringMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        DynamicObject curBill = (DynamicObject)this.getModel().getValue("entitynumber");
        if (curBill != null) {
            BasedataEntityType rdType = (BasedataEntityType)curBill.getDataEntityType();
            result.put("number", (String)curBill.get(rdType.getNumberProperty()));
            ILocaleString iLocaleString = (ILocaleString)curBill.get(rdType.getNameProperty());
            result.put("name", iLocaleString);
        }
        return result;
    }
}

