/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.cbs.plugin.statistics.common.util.XDBStatisticsHelper;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableName;

public class ShardingShowAliasFormPlugin
extends AbstractFormPlugin
implements Const {
    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        String entityNumber = (String)view.getFormShowParameter().getCustomParam("number");
        if (Objects.nonNull(entityNumber) && StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            this.showAliasInfo(entityNumber);
        }
    }

    private void showAliasInfo(String entityNumber) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        ShardConfigEntity loadConfig = ShardConfigRepository.get().loadConfig(entityNumber);
        List shardingConfigs = loadConfig.toShardingConfigs();
        for (ShardingConfig sc : shardingConfigs) {
            TableName table = TableName.of((String)sc.getTable());
            int rowIndex = model.createNewEntryRow("entryentity");
            model.setValue("type", (Object)XDBStatisticsHelper.getTypeFromConfig(sc), rowIndex);
            model.setValue("origintable", (Object)table.getOriginalName(), rowIndex);
            model.setValue("aliastable", (Object)table.getAliasName(), rowIndex);
        }
    }
}

