/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.cbs.plugin.sharding.common.util.TableManagerUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ShardingTableDDLFixEditPlugin
extends AbstractFormPlugin
implements Const {
    private static final Log logger = LogFactory.getLog(ShardingTableDDLFixEditPlugin.class);

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        JSONObject inconsistentTableMap = (JSONObject)view.getFormShowParameter().getCustomParam("inconsistentTableMap");
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (null != inconsistentTableMap) {
            inconsistentTableMap.forEach((k, v) -> {
                if (v instanceof JSONArray) {
                    for (String toFixTable : (JSONArray)v) {
                        int rowIndex = model.createNewEntryRow("entryentity");
                        model.setValue("prototype_table", k, rowIndex);
                        model.setValue("inconsistent_table", (Object)toFixTable, rowIndex);
                    }
                }
            });
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("bar_fix_all".equals(itemKey)) {
            String dbRouteKey = (String)view.getFormShowParameter().getCustomParam("dbRouteKey");
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            if (!entryEntity.isEmpty() && null != dbRouteKey) {
                DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
                try {
                    DB.__setupExtContextForUsingXdbTableManager((DBRoute)dbRoute, (boolean)false, () -> {
                        entryEntity.forEach(dynamicObject -> TableManagerUtil.fixDDL(dbRoute, dynamicObject.getString("inconsistent_table")));
                        return null;
                    });
                }
                catch (Exception e) {
                    logger.error("ShardingTableDDLValidateError", (Object)e.getMessage(), (Object)e);
                    view.showErrMessage(ResManager.loadKDString((String)"\u4fee\u590d\u5931\u8d25\uff0cShardingTableDDLValidateError\u3002", (String)"ShardingTableDDLFixEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]), e.getMessage());
                    return;
                }
                view.showMessage(ResManager.loadKDString((String)"\u4fee\u590d\u5b8c\u6210\u3002", (String)"ShardingTableDDLFixEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                view.close();
            }
        } else if ("bar_fix".equals(itemKey)) {
            EntryGrid eg = (EntryGrid)this.getControl("entryentity");
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            int[] selectRows = eg.getSelectRows();
            String dbRouteKey = (String)view.getFormShowParameter().getCustomParam("dbRouteKey");
            if (selectRows.length > 0) {
                DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
                try {
                    DB.__setupExtContextForUsingXdbTableManager((DBRoute)dbRoute, (boolean)false, () -> {
                        for (int i = 0; i < selectRows.length; ++i) {
                            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                            TableManagerUtil.fixDDL(dbRoute, dynamicObject.getString("inconsistent_table"));
                        }
                        return null;
                    });
                }
                catch (Exception e) {
                    logger.error("ShardingTableDDLValidateError", (Object)e.getMessage(), (Object)e);
                    view.showErrMessage(ResManager.loadKDString((String)"\u4fee\u590d\u5931\u8d25\uff0cShardingTableDDLValidateError\u3002", (String)"ShardingTableDDLFixEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]), e.getMessage());
                    return;
                }
                model.deleteEntryRows("entryentity", selectRows);
                if (model.getEntryEntity("entryentity").isEmpty()) {
                    view.showMessage(ResManager.loadKDString((String)"\u4fee\u590d\u5b8c\u6210\u3002", (String)"ShardingTableDDLFixEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    view.close();
                }
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ShardingTableDDLFixEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
        }
    }
}

