/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.engine.ShardingEngineFactory;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.parser.SQLParser;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;

public class ShardingTranslateEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ShardingTranslateEditPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        Lang lang = RequestContext.get().getLang();
        ComboEdit dbCombo = (ComboEdit)this.getControl("dbroute");
        ArrayList<ComboItem> dbComboItem = new ArrayList<ComboItem>();
        JSONArray dbInstanceList = this.getDbInstanceList();
        if (dbInstanceList.size() > 0) {
            for (JSONObject instance : dbInstanceList) {
                String bizAppNum = null;
                bizAppNum = Lang.zh_CN != lang && Lang.zh_TW != lang ? instance.getString("number") : instance.getString("name");
                ComboItem item = new ComboItem(new LocaleString(bizAppNum), (String)instance.get((Object)"number"));
                dbComboItem.add(item);
            }
            dbCombo.setComboItems(dbComboItem);
            this.getModel().setValue("dbroute", (Object)"sys");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("bar_translate".equals(itemKey)) {
            if (DB.isXDBEnable()) {
                CodeEdit sqlEditor = (CodeEdit)this.getControl("codeeditap");
                String sql = sqlEditor.getText();
                while (sql != null && sql.endsWith(";")) {
                    sql = sql.substring(0, sql.length() - 1).trim();
                }
                String dbRoute = (String)model.getValue("dbroute");
                model.setValue("result", null);
                Label label = (Label)this.getControl("count");
                label.setText(ResManager.loadKDString((String)"%s\u6761", (String)"ShardingTranslateEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[]{0}));
                AtomicReference sqlStatementInfo = new AtomicReference();
                AtomicBoolean sameSchema = new AtomicBoolean(false);
                try {
                    String finalSql = sql;
                    DB.__setupExtContextForUsingXdbTableManager((DBRoute)DBRoute.of((String)dbRoute), (boolean)false, () -> {
                        try {
                            String routeKey;
                            StatementInfo statementInfo = SQLParser.parse1_stmtInfo((boolean)false, (String)finalSql, (Object[])new Object[0]);
                            sqlStatementInfo.set(statementInfo);
                            List tableInfos = statementInfo.getTableInfos();
                            TableInfo tableInfo = (TableInfo)tableInfos.get(0);
                            String tableName = tableInfo.getName();
                            ShardingConfig config = XDBConfig.getShardingConfigProvider().getConfig(tableName);
                            if (config != null && dbRoute.equals(routeKey = config.getOptions().getDbRouteKey())) {
                                sameSchema.set(true);
                            }
                        }
                        catch (Exception e) {
                            view.showMessage(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5sql\u8bed\u53e5\u662f\u5426\u6b63\u786e\u3002", (String)"ShardingTranslateEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                            return null;
                        }
                        if (sameSchema.get()) {
                            try {
                                ShardingResult slice = ShardingEngineFactory.get().sharding(finalSql, new Object[0]);
                                SQLInfo[] sqlInfoArray = slice.getSQLInfos();
                                int length = sqlInfoArray.length;
                                label.setText(ResManager.loadKDString((String)"%s\u6761", (String)"ShardingTranslateEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[]{length}));
                                StringBuilder result = new StringBuilder(2056 * sqlInfoArray.length);
                                for (int i = 0; i < length; ++i) {
                                    result.append(sqlInfoArray[i].getSql().replaceAll("\t", "").replaceAll("\n", " "));
                                    if (i == length - 1) {
                                        result.append(";");
                                        continue;
                                    }
                                    result.append(";\n");
                                }
                                model.setValue("result", (Object)result.toString());
                            }
                            catch (Exception e) {
                                view.showMessage(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5sql:%s\u3002", (String)"ShardingTranslateEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[]{finalSql}));
                            }
                        } else {
                            label.setText(ResManager.loadKDString((String)"%s\u6761", (String)"ShardingTranslateEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[]{1}));
                            model.setValue("result", (Object)((StatementInfo)sqlStatementInfo.get()).getSQLInfo().getSql());
                        }
                        return null;
                    });
                }
                catch (Exception exception) {}
            } else {
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u6c34\u5e73\u5206\u8868\u914d\u7f6e\u3002", (String)"ShardingConfigEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
        }
    }

    private JSONArray getDbInstanceList() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/json;charset=UTF-8");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dataCenterId", RequestContext.get().getAccountId());
        String host = System.getProperty("mc.server.url");
        JSONArray data = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)host)) {
            try {
                JSONObject resp;
                String param = JSONUtils.toString(params);
                String sHttpResponse = HttpClientUtils.postjson((String)(host + "/kapi/app/mc/GetDbInstanceListService"), header, (String)param);
                if (StringUtils.isNotBlank((CharSequence)sHttpResponse) && (resp = JSONObject.parseObject((String)sHttpResponse)).getInteger("errorcode") == 100) {
                    data = resp.getJSONArray("data");
                }
            }
            catch (IOException e) {
                logger.error("ShardingTranslateEditPlugin ERROR: ", (Throwable)e);
            }
        }
        return data;
    }
}

