/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.list;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mservice.endpoint.EndPointDispatchServiceHelper;
import kd.bos.xdb.mservice.ShardingMetadataServiceImpl;

public class ShardIndexMapListPlugin
extends AbstractFormPlugin
implements Const {
    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String ip = (String)formShowParameter.getCustomParam("ip");
        String table = (String)formShowParameter.getCustomParam("table");
        ConcurrentMap globalIndexMap = (ConcurrentMap)EndPointDispatchServiceHelper.invoke((String)ip, (String)ShardingMetadataServiceImpl.class.getName(), (String)"getShardingMapTables", (Object[])new Object[]{table});
        this.populateEntryData(globalIndexMap, model, table);
    }

    private void populateEntryData(Map<String, Long> globalIndexMap, IDataModel model, String table) {
        ArrayList<Map.Entry<String, Long>> entryList = new ArrayList<Map.Entry<String, Long>>(globalIndexMap.entrySet());
        entryList.sort(Comparator.comparingLong(Map.Entry::getValue));
        for (Map.Entry entry : entryList) {
            String key = (String)entry.getKey();
            Long value = (Long)entry.getValue();
            int rowIndex = model.createNewEntryRow("entryentity");
            model.setValue("table_name", (Object)(table + "$" + value), rowIndex);
            model.setValue("mapper", (Object)key, rowIndex);
        }
    }
}

