/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.list;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.cbs.plugin.tools.LicenseUtils;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.sharding.config.MainTableConfig;

public class ShardingArchiListPlugin
extends AbstractListPlugin
implements Const {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseUtils.checkPerformGroup(e, "CBS_ARCHIVE");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "ADD_FORM_CALL_BACK": {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs hyperEvt) {
        String fieldName = hyperEvt.getFieldName();
        if ("configid_name".equals(fieldName)) {
            hyperEvt.setCancel(true);
            ListSelectedRow row = ((BillList)hyperEvt.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo();
            if (!QueryServiceHelper.exists((String)"bos_cbs_shard_archi", (Object)row.getPrimaryKeyValue())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ShardingArchiListPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                hyperEvt.setCancel(true);
                return;
            }
            QFilter filter = new QFilter("entitynumber", "=", (Object)row.getNumber());
            String selectFields = "id, shardingfields, strategy, strategyparams";
            DynamicObject shardConfig = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_shard_config", (String)selectFields, (QFilter[])filter.toArray());
            BillShowParameter fsp = new BillShowParameter();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("shardArchiTask", "true");
            map.put("configid", row.getPrimaryKeyValue());
            map.put("shardingfields", shardConfig.get("shardingfields"));
            map.put("number", row.getNumber());
            map.put("strategy", shardConfig.get("strategy"));
            map.put("strategyparams", shardConfig.get("strategyparams"));
            fsp.setCustomParam("shardEntityInfoMap", map);
            fsp.setFormId("bos_cbs_shard_archi");
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fsp.setStatus(OperationStatus.EDIT);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CONFIG_LIST_CALL_BACK"));
            fsp.setPkId(row.getPrimaryKeyValue());
            fsp.setCaption(ResManager.loadKDString((String)"\u5206\u5e93\u914d\u7f6e", (String)"ShardingArchiListPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        IFormView view = this.getView();
        if ("tb_new".equals(operateKey)) {
            FormShowParameter fps = new FormShowParameter();
            fps.setFormId("bos_cbs_add_archiconfig");
            fps.getOpenStyle().setShowType(ShowType.Modal);
            fps.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ADD_FORM_CALL_BACK"));
            this.getView().showForm(fps);
        } else if ("delete".equals(operateKey)) {
            for (ListSelectedRow row : e.getListSelectedData()) {
                Set allArchiveRoutes;
                Object primaryKeyValue = row.getPrimaryKeyValue();
                String number = row.getNumber();
                if (this.isEnabling(primaryKeyValue)) {
                    view.showMessage(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u5206\u5e93\u542f\u7528\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff1a%s\u3002", (String)"ShardingArchiListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[]{number}));
                    e.setCancel(true);
                    return;
                }
                MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getConfigByEntity(number);
                if (mainConfig == null || (allArchiveRoutes = mainConfig.getOptions().getIndexRoute().getAllArchiveRoutes()).isEmpty()) continue;
                view.showMessage(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u5206\u5e93\u751f\u6548\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff1a%s\u3002", (String)"ShardingArchiListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[]{number}));
                e.setCancel(true);
                return;
            }
        }
    }

    private boolean isEnabling(Object primaryKeyValue) {
        DynamicObject configLoad = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bos_cbs_shard_archi");
        String configStatus = configLoad.getString("status");
        return configStatus.equals(ShardConfigStatusEnum.ENABLING.getKey());
    }

    public void afterDoOperation(AfterDoOperationEventArgs ae) {
        boolean success;
        String operateKey = ae.getOperateKey();
        boolean bl = success = ae.getOperationResult() != null && ae.getOperationResult().isSuccess();
        if ("delete".equals(operateKey) && success) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            QFilter qf = new QFilter("config", "=", primaryKeyValue);
            BusinessDataWriter.delete((String)"bos_cbs_shard_task", (QFilter[])qf.toArray());
            String entityNumber = currentSelectedRowInfo.getNumber();
            QFilter qf2 = new QFilter("entitynumber", "=", (Object)entityNumber);
            BusinessDataWriter.delete((String)"bos_cbs_shard_archirt", (QFilter[])qf2.toArray());
        }
    }
}

