/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.list;

import java.sql.SQLException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.cbs.plugin.sharding.common.util.TableManagerUtil;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.entity.ShardDetailUpgradUtil;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.repository.ShardArchiRepository;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.repository.ShardDetailRepository;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.tablemanager.TableManager;

public class ShardingConfigListPlugin
extends AbstractListPlugin
implements Const {
    private static final Log logger = LogFactory.getLog(ShardingConfigListPlugin.class);
    static TableManager tm;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "CONFIG_LIST_CALL_BACK": {
                IFormView view = this.getView();
                view.updateView();
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs hyperEvt) {
        String fieldName = hyperEvt.getFieldName();
        if ("entitynumber_name".equals(fieldName)) {
            hyperEvt.setCancel(true);
            ListSelectedRow row = ((BillList)hyperEvt.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo();
            BillShowParameter fsp = new BillShowParameter();
            fsp.setFormId("bos_cbs_shard_config");
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fsp.setStatus(OperationStatus.EDIT);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CONFIG_LIST_CALL_BACK"));
            fsp.setCaption(ResManager.loadKDString((String)"\u5206\u8868\u914d\u7f6e", (String)"ShardingConfigEditPlugin_49", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            fsp.setPkId(row.getPrimaryKeyValue());
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        IFormView view = this.getView();
        if ("tb_new".equals(operateKey)) {
            FormShowParameter fps = new FormShowParameter();
            fps.setFormId("bos_cbs_add_config");
            fps.getOpenStyle().setShowType(ShowType.Modal);
            fps.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5206\u8868\u914d\u7f6e", (String)"ShardingConfigEditPlugin_50", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            fps.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ADD_FORM_CALL_BACK"));
            this.getView().showForm(fps);
        } else if ("delete".equals(operateKey)) {
            for (ListSelectedRow row : e.getListSelectedData()) {
                Object primaryKeyValue = row.getPrimaryKeyValue();
                String number = row.getNumber();
                if (this.isEffective(primaryKeyValue)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u5206\u7247\u751f\u6548\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff1a%s\u3002", (String)"ShardingConfigListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[]{number}), Integer.valueOf(2000));
                    e.setCancel(true);
                    return;
                }
                QFilter qf = new QFilter("config", "=", primaryKeyValue);
                BusinessDataWriter.delete((String)"bos_cbs_shard_fast_index", (QFilter[])qf.toArray());
                ShardArchiRepository.get().clearArchi(number);
            }
        } else if ("table_validate".equals(operateKey)) {
            String number = e.getListSelectedData().get(0).getNumber();
            IDataEntityType dt = ORM.create().getDataEntityType(number);
            ShardingConfig config = XDBConfig.getShardingConfigProvider().getConfig(dt.getAlias());
            if (logger.isInfoEnabled()) {
                ShardingConfigProvider shardingConfigProvider = XDBConfig.getShardingConfigProvider();
                logger.info("ShardingConfigListPlugin shardingConfigProvider:" + shardingConfigProvider.toString() + "@shardingConfig:" + config + "@tableName:" + dt.getAlias());
            }
            if (null != config) {
                ShardConfigEntity loadConfig = ShardConfigRepository.get().loadConfig(number);
                if (loadConfig.getConfigstatus() == ShardConfigStatusEnum.ENABLE || loadConfig.getConfigstatus() == ShardConfigStatusEnum.DISANLING) {
                    HashMap<String, Set<String>> inconsistentTableMap;
                    List shardingConfigs = loadConfig.toShardingConfigs();
                    Boolean validateTableDDL = this.validateTableDDL(shardingConfigs, inconsistentTableMap = new HashMap<String, Set<String>>(1), DBRoute.of((String)dt.getDBRouteKey()));
                    if (null == validateTableDDL) {
                        return;
                    }
                    if (validateTableDDL.booleanValue()) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u6240\u6709\u5206\u7247\u8868\u7ed3\u6784\u4e00\u81f4\u3002", (String)"ShardingConfigListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    } else {
                        FormShowParameter fsp = new FormShowParameter();
                        fsp.setFormId("bos_cbs_shard_table_fix");
                        fsp.getCustomParams().put("inconsistentTableMap", inconsistentTableMap);
                        fsp.getCustomParams().put("dbRouteKey", dt.getDBRouteKey());
                        fsp.getOpenStyle().setShowType(ShowType.Modal);
                        view.showForm(fsp);
                    }
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5206\u7247\u672a\u542f\u7528\uff0c\u65e0\u9700\u6821\u9a8c\u8868\u7ed3\u6784\u3002", (String)"ShardingConfigListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]), Integer.valueOf(2000));
                }
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u5206\u7247\u672a\u542f\u7528\uff0c\u65e0\u9700\u6821\u9a8c\u8868\u7ed3\u6784\u3002", (String)"ShardingConfigListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        } else if ("view_runtime_info".equals(operateKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            if (!this.isEnable(primaryKeyValue)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5206\u7247\u672a\u542f\u7528\uff0c\u65e0\u9700\u67e5\u770b\u8fd0\u884c\u65f6\u4fe1\u606f", (String)"ShardingConfigListPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]), Integer.valueOf(2000));
                e.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("bos_cbs_shard_runtime");
            listShowParameter.setFormId("bos_templatetreelist");
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String number = e.getListSelectedData().get(0).getNumber();
            listShowParameter.setCustomParam("number", (Object)number);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u8fd0\u884c\u65f6\u4fe1\u606f\uff1a%s", (String)"ShardingConfigListPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[]{number}));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private Boolean validateTableDDL(List<ShardingConfig> shardingConfigs, Map<String, Set<String>> inconsistentTables, DBRoute dbRoute) {
        boolean ret = false;
        try {
            DB.__setupExtContextForUsingXdbTableManager((DBRoute)dbRoute, (boolean)false, () -> {
                tm = XDBConfig.getTableManager();
                shardingConfigs.forEach(sc -> {
                    String table = sc.getTable();
                    try {
                        TableManagerUtil.validate(table, inconsistentTables);
                    }
                    catch (SQLException e) {
                        logger.error("ShardingTableDDLValidateError", (Object)e.getMessage(), (Object)e);
                        this.getView().showErrMessage(ResManager.loadKDString((String)"\u6bd4\u8f83\u67e5\u8be2\u5206\u7247\u8868\u5931\u8d25\uff0cShardingTableDDLValidateError\u3002", (String)"ShardingConfigListPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]), e.getMessage());
                        return;
                    }
                });
                return null;
            });
        }
        catch (Exception e) {
            logger.error("ShardingTableDDLValidateError", (Object)e.getMessage(), (Object)e);
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u6bd4\u8f83\u67e5\u8be2\u5206\u7247\u8868\u5931\u8d25\uff0cShardingTableDDLValidateError\u3002", (String)"ShardingConfigListPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]), e.getMessage());
            return null;
        }
        if (inconsistentTables.isEmpty()) {
            ret = true;
        }
        return ret;
    }

    private boolean isEffective(Object primaryKeyValue) {
        DynamicObject configLoad = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bos_cbs_shard_config");
        String configStatus = configLoad.getString("configstatus");
        return !configStatus.equals(ShardConfigStatusEnum.DISABLE.getKey());
    }

    private boolean isEnable(Object primaryKeyValue) {
        DynamicObject configLoad = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bos_cbs_shard_config");
        String configStatus = configLoad.getString("configstatus");
        return configStatus.equals(ShardConfigStatusEnum.ENABLE.getKey());
    }

    public void afterDoOperation(AfterDoOperationEventArgs ae) {
        boolean success;
        String operateKey = ae.getOperateKey();
        boolean bl = success = ae.getOperationResult() != null && ae.getOperationResult().isSuccess();
        if ("delete".equals(operateKey) && success) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            QFilter qf = new QFilter("config", "=", primaryKeyValue);
            BusinessDataWriter.delete((String)"bos_cbs_shard_task", (QFilter[])qf.toArray());
            String entityNumber = currentSelectedRowInfo.getNumber();
            if (ShardDetailUpgradUtil.isUpgraded()) {
                ShardDetailRepository.get().deleteDetail(entityNumber);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ShardConfigDataProvider());
    }

    static class ShardConfigDataProvider
    extends ListDataProvider {
        ShardConfigDataProvider() {
        }

        public void setListFields(List<ListField> listFields) {
            ListField listField = new ListField();
            listField.setListFieldKey("strategy");
            listField.setEntityName("bos_cbs_shard_config");
            listField.setKey("strategy");
            listField.setFieldName("strategy");
            DynamicProperty dynamicProperty = new DynamicProperty();
            dynamicProperty.setName("strategy");
            listField.setFieldProp((IDataEntityProperty)dynamicProperty);
            listFields.add(listField);
            super.setListFields(listFields);
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            if (!((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"strategy")) {
                return rows;
            }
            for (DynamicObject row : rows) {
                String strategy_multilang;
                String strategy = row.getString("strategy");
                if (StringUtils.isEmpty((String)strategy)) continue;
                switch (strategy) {
                    case "IDSequenceStrategy": {
                        strategy_multilang = ResManager.loadKDString((String)"ID\u65f6\u5e8f\u7b56\u7565", (String)"ShardingChooseStrategyEditPlugin_19", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "HashModStrategy": {
                        strategy_multilang = ResManager.loadKDString((String)"\u54c8\u5e0c\u53d6\u6a21", (String)"ShardingChooseStrategyEditPlugin_21", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "DateDayStrategy": {
                        strategy_multilang = ResManager.loadKDString((String)"\u6309\u65e5\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "DateMonthStrategy": {
                        strategy_multilang = ResManager.loadKDString((String)"\u6309\u6708\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "DateYearStrategy": {
                        strategy_multilang = ResManager.loadKDString((String)"\u6309\u5e74\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_10", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "DateModStrategy": {
                        strategy_multilang = ResManager.loadKDString((String)"\u65e5\u671f\u6c42\u6a21\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_13", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "MapStrategy": {
                        strategy_multilang = ResManager.loadKDString((String)"\u6620\u5c04\u7b56\u7565", (String)"ShardingChooseStrategyEditPlugin_26", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "custom_strategy": {
                        strategy_multilang = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7b56\u7565", (String)"ShardingChooseStrategyEditPlugin_23", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    default: {
                        strategy_multilang = "";
                    }
                }
                row.set("strategyzh_cn", (Object)strategy_multilang);
            }
            return rows;
        }
    }
}

