/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.list;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ShardingLogListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("id desc");
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && messageBoxClosedEvent.getCallBackId().equals("clearBillStatistic")) {
            this.clearListData();
        }
    }

    private void clearListData() {
        String sql = "truncate table t_cbs_shard_log ";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[0]);
        this.getView().invokeOperation("refresh");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("delete".equals(operateKey)) {
            String opName = ResManager.loadKDString((String)"\u5220\u9664\u5206\u7247\u64cd\u4f5c\u65e5\u5fd7\u3002", (String)"ShardingLogListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            for (ListSelectedRow selectedRow : selectedRows) {
                String entityNumber = this.getEntityNumber(selectedRow.getPrimaryKeyValue());
                String string = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u5220\u9664\u5206\u7247\u64cd\u4f5c\u65e5\u5fd7\u6210\u529f\u3002", (String)"ShardingLogListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]), entityNumber);
            }
        } else if ("bar_clear".equals(operateKey)) {
            String confirmTip = ResManager.loadKDString((String)"\u6e05\u7a7a\u6240\u6709\u65e5\u5fd7\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ShardingLogListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("clearBillStatistic");
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
        }
        super.beforeDoOperation(args);
    }

    public String getEntityNumber(Object fid) {
        QFilter filter = new QFilter("id", "=", fid);
        return (String)QueryServiceHelper.queryOne((String)"bos_cbs_shard_log", (String)"entitynumber", (QFilter[])new QFilter[]{filter}).get("entitynumber");
    }
}

