/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.statistics;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.cbs.plugin.statistics.common.entity.StatisticsEntity;
import kd.bos.cbs.plugin.statistics.common.util.XDBStatisticsHelper;
import kd.bos.cbs.plugin.statistics.config.XDBStatisticsConfig;
import kd.bos.cbs.plugin.statistics.service.StatisticsEntityService;
import kd.bos.context.OperationContextCreator;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dlock.DLock;
import kd.bos.framework.lifecycle.Service;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.tenant.listener.TenantListener;
import kd.bos.tenant.listener.TenantListenerInfo;
import kd.bos.tenant.listener.TenantListenerManager;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;

public final class XDBStatisticsStartTimerService
implements Service {
    private static final Log log = LogFactory.getLog(XDBStatisticsStartTimerService.class);
    private static final String SIMPLE_NAME = XDBStatisticsStartTimerService.class.getSimpleName();
    private static final List<RequestContext> rcList = new CopyOnWriteArrayList<RequestContext>();
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean isSameTask = new AtomicBoolean();
    private String existEntityNumber;
    private long version;

    public void start() {
        if (XDBStatisticsConfig.isEnabled()) {
            if (!this.started.compareAndSet(false, true)) {
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.set(7, 1);
            ThreadPools.executeOnce((String)"XDB-STATISTICS-THREAD-ONCE", () -> {
                Timer timer = new Timer("XDB-STATISTICS-SCHEDULE", true);
                TimerTask timerTask = null;
                Thread thread = Thread.currentThread();
                while (!thread.isInterrupted()) {
                    int dayInterval = XDBStatisticsConfig.getDayInterval();
                    Date date = calendar.getTime();
                    while (date.before(new Date())) {
                        date = this.addDay(date, dayInterval);
                    }
                    if (!this.isSameTask.get()) {
                        timerTask = ThreadLifeCycleManager.wrapTimerTask((Runnable)new StatisticsTask());
                        timer.scheduleAtFixedRate(timerTask, date, (long)(dayInterval * 24 * 3600000));
                    }
                    this.setHourSleep(12L);
                    int curDayInterval = XDBStatisticsConfig.getDayInterval();
                    if (dayInterval == curDayInterval) {
                        this.isSameTask.set(true);
                        continue;
                    }
                    timerTask.cancel();
                    timer.purge();
                    this.isSameTask.set(false);
                }
            });
        }
    }

    private void setHourSleep(long hour) {
        try {
            TimeUnit.HOURS.sleep(hour);
        }
        catch (InterruptedException e) {
            log.error("xdb stat sleep error" + e.getMessage(), (Throwable)e);
        }
    }

    private void setExistEntityNumberAndVersion(List<StatisticsEntity> statisticsEntityList, List<StatisticsEntity> curStatisticsEntityList) {
        boolean isBroken = false;
        for (StatisticsEntity statisticsEntity : curStatisticsEntityList) {
            String entityNumber = statisticsEntity.getEntityNumber();
            for (StatisticsEntity se : statisticsEntityList) {
                if (!se.getEntityNumber().equals(entityNumber)) continue;
                this.existEntityNumber = entityNumber;
                this.version = se.getVersion();
                isBroken = true;
                break;
            }
            if (!isBroken) continue;
            break;
        }
    }

    private boolean isAccountEnabled() {
        return this.started.get() && XDBStatisticsConfig.isAccountEnable();
    }

    private Date addDay(Date date, int num) {
        Calendar startDT = Calendar.getInstance();
        startDT.setTime(date);
        startDT.add(5, num);
        return startDT.getTime();
    }

    public void stop() {
        this.started.set(false);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public String getName() {
        return SIMPLE_NAME;
    }

    static {
        List<Object> allAccounts = new ArrayList();
        try {
            allAccounts = AccountUtils.getAllAccountsOfCurrentEnv();
        }
        catch (Exception e) {
            allAccounts = Collections.emptyList();
            log.warn("XDBStatisticsStartTimerService getAllAccountsOfCurrentEnv failed: " + e.getMessage(), (Throwable)e);
        }
        for (Account account : allAccounts) {
            RequestContext rc = RequestContext.create();
            rc.setAccountId(account.getAccountId());
            rc.setTenantId(account.getTenantId());
            rcList.add(rc);
        }
        TenantListenerManager.addTenantListener((TenantListener)new TenantListener(){

            public void onTenantAccountsAdded(TenantListenerInfo tenantListenerInfo) {
                try {
                    String typeString = System.getProperty("mc.type");
                    if ("ZK".equalsIgnoreCase(typeString)) {
                        for (Account account : tenantListenerInfo.getAccountList()) {
                            RequestContext rc = RequestContext.create((boolean)false);
                            rc.setTenantId(tenantListenerInfo.getTenantnumber());
                            rc.setAccountId(account.getAccountId());
                            rcList.add(rc);
                        }
                    }
                }
                catch (Exception e) {
                    OperationContextCreator.getOrCreateForBos();
                    log.error("TenantListener onTenantAccountsAdded failed: " + e.getMessage(), (Throwable)e);
                }
            }

            public void onTenantAccountsRemoved(TenantListenerInfo tenantListenerInfo) {
                try {
                    String typeString = System.getProperty("mc.type");
                    if ("ZK".equalsIgnoreCase(typeString)) {
                        for (Account account : tenantListenerInfo.getAccountList()) {
                            Iterator it = rcList.iterator();
                            while (it.hasNext()) {
                                RequestContext requestContext = (RequestContext)it.next();
                                if (!requestContext.getAccountId().equals(account.getAccountId()) || !requestContext.getTenantId().equals(tenantListenerInfo.getTenantnumber())) continue;
                                it.remove();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    OperationContextCreator.getOrCreateForBos();
                    log.error("TenantListener onTenantAccountsRemoved failed: " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private class StatisticsTask
    extends TimerTask {
        private StatisticsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName("XDB-STATISTICS-SCHEDULE-TASK");
            StatisticsEntityService ses = StatisticsEntityService.get();
            DLock lock = DLock.create((String)"/xdb/statistics/schedule");
            if (lock.tryLock()) {
                try {
                    for (RequestContext rc : new ArrayList(rcList)) {
                        List<StatisticsEntity> curStatisticsEntityList;
                        RequestContext.copyAndSet((RequestContext)rc);
                        if (!XDBStatisticsStartTimerService.this.isAccountEnabled() || (curStatisticsEntityList = ses.queryAllStatistics()).isEmpty()) continue;
                        TXHandle h = TX.requiresNew((String)"xdb.schedule.statistic");
                        Throwable throwable = null;
                        try {
                            for (StatisticsEntity se : curStatisticsEntityList) {
                                XDBStatisticsHelper.statisticsEntityNumber(se.getEntityNumber(), se.getId());
                                ses.updateStatisticsVersion(se.getEntityNumber(), new Date());
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (h == null) continue;
                            if (throwable != null) {
                                try {
                                    h.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            h.close();
                        }
                    }
                }
                catch (Exception e) {
                    log.error("xdb stat error: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }
}

