/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.statistics.common.util;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.cbs.plugin.statistics.common.StatisticEnum;
import kd.bos.cbs.plugin.statistics.service.XDBStatisticsService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;

public class XDBStatisticsHelper {
    private static final Log log = LogFactory.getLog(XDBStatisticsHelper.class);

    public static void statisticsEntityNumber(String number, Object statisticsId) {
        boolean isShardingEnable;
        XDBStatisticsService xdbStatisticsService = XDBStatisticsService.get();
        IDataEntityType dt = ORM.create().getDataEntityType(number);
        String dbRouteKey = dt.getDBRouteKey();
        ShardConfigEntity configEntity = ShardConfigRepository.get().loadConfig(number);
        boolean isMock = false;
        if (null == configEntity) {
            configEntity = ShardConfigEntity.mockShardConfigEntity((String)number);
            isMock = true;
        }
        String configStatus = configEntity.getConfigstatus().getKey();
        boolean bl = isShardingEnable = DB.isXDBEnable() && configStatus != null && ShardConfigStatusEnum.ENABLE.getKey().equals(configStatus);
        if (!isShardingEnable && !isMock) {
            configEntity = ShardConfigEntity.mockShardConfigEntity((String)number);
            isMock = true;
        }
        List shardingConfigs = configEntity.toShardingConfigs(isMock);
        xdbStatisticsService.setRouteKey(dbRouteKey);
        long startTime = System.currentTimeMillis();
        AtomicLong totalCount = new AtomicLong(0L);
        AtomicLong tableCount = new AtomicLong(0L);
        AtomicLong shardingCount = new AtomicLong(0L);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_cbs_shard_stat_detail");
        dynamicObject.set("entitynumber", (Object)number);
        dynamicObject.set("statistic", statisticsId);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("sharding", (Object)(isShardingEnable ? "1" : "0"));
        DynamicObjectCollection entryEntitys = dynamicObject.getDynamicObjectCollection("entryentity");
        for (ShardingConfig config : shardingConfigs) {
            String type = XDBStatisticsHelper.getTypeFromConfig(config);
            String tableName = config.getTable();
            if (isShardingEnable) {
                try {
                    DB.__setupExtContextForUsingXdbTableManager((DBRoute)DBRoute.of((String)dbRouteKey), (boolean)false, () -> {
                        String[] shardingTable = XDBConfig.getTableManager().getShardingTable(tableName);
                        tableCount.addAndGet(shardingTable.length);
                        shardingCount.compareAndSet(0L, shardingTable.length);
                        for (String alias : shardingTable) {
                            XDBStatisticsHelper.createStatisticsEntry(xdbStatisticsService, totalCount, entryEntitys, type, tableName, alias);
                        }
                        return null;
                    });
                }
                catch (Exception exception) {
                    log.error(exception.getMessage(), (Throwable)exception);
                }
                continue;
            }
            tableCount.compareAndSet(0L, shardingConfigs.size());
            XDBStatisticsHelper.createStatisticsEntry(xdbStatisticsService, totalCount, entryEntitys, type, tableName, tableName);
        }
        dynamicObject.set("totalcount", (Object)totalCount.get());
        dynamicObject.set("originaltablecount", (Object)shardingConfigs.size());
        dynamicObject.set("tablecount", (Object)tableCount.get());
        dynamicObject.set("shardingcount", (Object)shardingCount.get());
        dynamicObject.set("cost", (Object)BigDecimal.valueOf(System.currentTimeMillis() - startTime).divide(BigDecimal.valueOf(1000L), 3, 4));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private static void createStatisticsEntry(XDBStatisticsService xdbStatisticsService, AtomicLong totalCount, DynamicObjectCollection entryEntitys, String type, String tableName, String alias) {
        long count = xdbStatisticsService.countTable(alias);
        DynamicObject entryEntity = ORM.create().newDynamicObject("bos_cbs_shard_stat_detail.entryentity");
        entryEntity.set("type", (Object)type);
        entryEntity.set("table", (Object)alias);
        entryEntity.set("originaltable", (Object)tableName);
        entryEntity.set("count", (Object)count);
        totalCount.addAndGet(count);
        entryEntitys.add((Object)entryEntity);
    }

    public static String getTypeFromConfig(ShardingConfig config) {
        String type = "";
        if (config instanceof MainTableConfig) {
            type = StatisticEnum.Head.getType();
        } else {
            ShardingConfig parent = ((ChildrenTableConfig)config).getParent();
            if (parent instanceof MainTableConfig) {
                type = ShardConfigEntity.isLangTableShardingDBConfig((ShardingConfig)config) ? StatisticEnum.HeadLang.getType() : (ShardConfigEntity.isGroupTableShardingDBConfig((ShardingConfig)config) ? StatisticEnum.HeadGroup.getType() : (ShardConfigEntity.isTcTableShardingDBConfig((ShardingConfig)config) ? StatisticEnum.EntryTc.getType() : (ShardConfigEntity.isLkTableShardingDBConfig((ShardingConfig)config) ? StatisticEnum.HeadLk.getType() : (ShardConfigEntity.isPrivacyTableShardingDBConfig((ShardingConfig)config) ? StatisticEnum.HeadPrivacy.getType() : StatisticEnum.Entry.getType()))));
            } else {
                ShardingConfig grandParent = ((ChildrenTableConfig)parent).getParent();
                if (grandParent instanceof MainTableConfig) {
                    type = ShardConfigEntity.isLangTableShardingDBConfig((ShardingConfig)config) ? StatisticEnum.EntryLang.getType() : (ShardConfigEntity.isGroupTableShardingDBConfig((ShardingConfig)config) ? StatisticEnum.EntryGroup.getType() : (ShardConfigEntity.isWbTableShardingDBConfig((ShardingConfig)config) ? StatisticEnum.SubEntryWb.getType() : (ShardConfigEntity.isLkTableShardingDBConfig((ShardingConfig)config) ? StatisticEnum.EntryLk.getType() : (ShardConfigEntity.isPrivacyTableShardingDBConfig((ShardingConfig)config) ? StatisticEnum.EntryPrivacy.getType() : StatisticEnum.SubEntry.getType()))));
                } else if (ShardConfigEntity.isLangTableShardingDBConfig((ShardingConfig)config)) {
                    type = StatisticEnum.SubEntryLang.getType();
                } else if (ShardConfigEntity.isGroupTableShardingDBConfig((ShardingConfig)config)) {
                    type = StatisticEnum.SubEntryGroup.getType();
                } else if (ShardConfigEntity.isLkTableShardingDBConfig((ShardingConfig)config)) {
                    type = StatisticEnum.SubEntryLk.getType();
                } else if (ShardConfigEntity.isPrivacyTableShardingDBConfig((ShardingConfig)config)) {
                    type = StatisticEnum.SubEntryPrivacy.getType();
                }
            }
        }
        return type;
    }
}

