/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.statistics.plugin.edit;

import java.util.EventObject;
import kd.bos.cbs.plugin.statistics.common.Constant.StatisticConst;
import kd.bos.cbs.plugin.statistics.common.entity.StatisticsEntity;
import kd.bos.cbs.plugin.statistics.common.util.XDBStatisticsHelper;
import kd.bos.cbs.plugin.statistics.service.StatisticsEntityService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.repository.ShardConfigRepository;

public class XDBStatisticsEditPlugin
extends AbstractFormPlugin
implements StatisticConst {
    private final ORM orm = ORM.create();

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model;
        DynamicObject baseEntity;
        String property = e.getProperty().getName();
        if ("entitynumber".equals(property) && (baseEntity = (DynamicObject)(model = this.getModel()).getValue("entitynumber")) != null) {
            RefEntityType rdType = (RefEntityType)baseEntity.getDataEntityType();
            String number = baseEntity.getString(rdType.getNumberProperty());
            try {
                if (this.orm.exists("bos_cbs_shard_statistic", new QFilter[]{new QFilter("entitynumber", "=", (Object)number)})) {
                    model.setValue("entitynumber", null);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8868\u5355\u5df2\u5b58\u5728\u3002", (String)"XDBStatisticsEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                }
            }
            catch (Exception exception) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u68c0\u67e5\u5143\u6570\u636e\u4e0e\u4ee3\u7801\u7248\u672c\u662f\u5426\u4e00\u81f4\u3002", (String)"XDBStatisticsEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        IDataModel model = this.getModel();
        String itemKey = evt.getItemKey();
        if ("bar_statistic".equals(itemKey)) {
            DynamicObject baseEntity = (DynamicObject)model.getValue("entitynumber");
            if (baseEntity != null) {
                RefEntityType rdType = (RefEntityType)baseEntity.getDataEntityType();
                String number = baseEntity.getString(rdType.getNumberProperty());
                StatisticsEntity statisticsEntity = StatisticsEntityService.get().queryStatisticsByEntityNumber(number);
                if (statisticsEntity.getEntityNumber() == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u8868\u5355\u3002", (String)"XDBStatisticsEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    return;
                }
                ShardConfigEntity configEntity = ShardConfigRepository.get().loadConfig(number);
                if (configEntity != null) {
                    boolean configEnable;
                    String configStatus = configEntity.getConfigstatus().getKey();
                    boolean bl = configEnable = configStatus != null && ShardConfigStatusEnum.ENABLE.getKey().equals(configStatus);
                    if (configEnable && !DB.isXDBEnable()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u5355\u5df2\u542f\u7528\u5206\u7247\uff0c\u8bf7\u5148\u5f00\u542f\u5206\u7247\u914d\u7f6e\u3002", (String)"XDBStatisticsEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                        return;
                    }
                }
                XDBStatisticsHelper.statisticsEntityNumber(number, model.getDataEntity().getPkValue());
            }
            this.getView().invokeOperation("refresh");
        }
    }
}

