/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.statistics.plugin.edit;

import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cbs.plugin.statistics.common.entity.StatisticsDetailEntity;
import kd.bos.cbs.plugin.statistics.plugin.edit.Group;
import kd.bos.cbs.plugin.statistics.service.StatisticsDetailEntityService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.plugin.AbstractFormPlugin;

public class XDBStatisticsLineChartEditPlugin
extends AbstractFormPlugin {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        if (!customParams.isEmpty()) {
            this.drawStatisticsChart(customParams);
        }
    }

    private void drawStatisticsChart(Map<String, Object> customParams) {
        PointLineChart customChart = this.getChartControl();
        customChart.clearData();
        customChart.setMargin(Position.right, "80");
        customChart.setMargin(Position.left, "40");
        customChart.setShowLegend(true);
        customChart.setLegendVertical(false);
        List<StatisticsDetailEntity> detailEntities = StatisticsDetailEntityService.get().queryDetailsByStatisticsId(customParams.get("id"));
        List dateForXAxis = detailEntities.stream().map(detail -> this.sdf.format(detail.getCreateTime())).collect(Collectors.toList());
        Map<Group, List<Number>> sortedData = this.getData((String)customParams.get("entityNumber"), detailEntities);
        sortedData.forEach(this::createBarSeries);
        Axis xAxis = this.createCategoryAxis(ResManager.loadKDString((String)"\u65e5\u671f", (String)"XDBStatisticsLineChartEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]), true);
        xAxis.setCategorys(dateForXAxis);
        HashMap xAxisPointer = Maps.newHashMap();
        xAxisPointer.put("show", true);
        xAxisPointer.put("type", "shadow");
        Label xAxisLabel = new Label();
        xAxisLabel.setShow(true);
        xAxisLabel.setBackgroundColor("black");
        xAxisPointer.put("label", xAxisLabel);
        xAxis.setPropValue("axisPointer", (Object)xAxisPointer);
        Axis yAxis = this.createValueAxis(ResManager.loadKDString((String)"\u6570\u636e\u91cf", (String)"XDBStatisticsLineChartEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]), false);
        HashMap axisLabel1 = Maps.newHashMap();
        axisLabel1.put("formatter", ResManager.loadKDString((String)"%s\u884c", (String)"XDBStatisticsLineChartEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[]{"{value} "}));
        yAxis.setPropValue("axisLabel", (Object)axisLabel1);
        yAxis.setPropValue("minInterval", (Object)1);
        HashMap yAxisPointer = Maps.newHashMap();
        yAxisPointer.put("show", true);
        yAxisPointer.put("type", "line");
        Label yAxisLabel = new Label();
        yAxisLabel.setShow(true);
        yAxisLabel.setBackgroundColor("black");
        yAxisPointer.put("label", xAxisLabel);
        HashMap lineStyle = Maps.newHashMap();
        lineStyle.put("type", "dotted");
        yAxisPointer.put("lineStyle", lineStyle);
        yAxisPointer.put("triggerTooltip", false);
        yAxis.setPropValue("axisPointer", (Object)yAxisPointer);
        customChart.refresh();
    }

    private void createBarSeries(Group group, List<Number> data) {
        LineSeries barSeries = this.getChartControl().createLineSeries(group.getGroupName());
        Label label = new Label();
        label.setBackgroundColor("#FFFFFF");
        label.setShow(true);
        barSeries.setLabel(label);
        barSeries.setType(group.getChartType());
        barSeries.setItemColor("red");
        barSeries.setAnimationDuration(2000);
        barSeries.setPropValue("yAxisIndex", (Object)group.getyAxisIndex());
        barSeries.setData(data.toArray(new Number[0]));
    }

    private Map<Group, List<Number>> getData(String entityNumber, List<StatisticsDetailEntity> detailEntities) {
        LinkedHashMap<Group, List<Number>> summaryResult = new LinkedHashMap<Group, List<Number>>();
        List<Group> groups = this.getDefaultGroups(entityNumber);
        ArrayList list01 = new ArrayList();
        detailEntities.forEach(detail -> list01.add(detail.getTotalCount()));
        summaryResult.put(groups.get(0), list01);
        return summaryResult;
    }

    private Axis createCategoryAxis(String name, boolean isX) {
        Axis axis = isX ? this.getChartControl().createXAxis(name, AxisType.category) : this.getChartControl().createYAxis(name, AxisType.category);
        HashMap<String, Integer> axisTick = new HashMap<String, Integer>();
        axisTick.put("interval", 0);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#5F9EA0");
        return axis;
    }

    private Axis createValueAxis(String name, boolean isX) {
        Axis axis = isX ? this.getChartControl().createXAxis(name, AxisType.value) : this.getChartControl().createYAxis(name, AxisType.value);
        HashMap axisTick = new HashMap();
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#5F9EA0");
        this.getChartControl().setShowTooltip(true);
        return axis;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private PointLineChart getChartControl() {
        return (PointLineChart)this.getControl("pointlinechartap");
    }

    private List<Group> getDefaultGroups(String entityNumber) {
        ArrayList<Group> defaultGroupList = new ArrayList<Group>(2);
        defaultGroupList.add(new Group(entityNumber, "count", "#4DB39E", true, ChartType.line, 0));
        return defaultGroupList;
    }
}

