/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.statistics.plugin.edit;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.statistics.common.Constant.StatisticConst;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;

public class XDBStatisticsShowDetailPlugin
extends AbstractFormPlugin
implements SetFilterListener,
StatisticConst {
    public void beforeBindData(EventObject e) {
        IDataModel model = this.getModel();
        BillList detailList = (BillList)this.getView().getControl("billlistap");
        DynamicObject baseEntity = (DynamicObject)model.getValue("entitynumber");
        String number = null;
        if (baseEntity != null) {
            RefEntityType rdType = (RefEntityType)baseEntity.getDataEntityType();
            number = baseEntity.getString(rdType.getNumberProperty());
        }
        detailList.setFilter(new QFilter("entitynumber", "=", number).and(new QFilter("statistic", "=", model.getDataEntity().getPkValue())));
    }

    public void registerListener(EventObject e) {
        IFormView view = this.getView();
        BillList taskList = (BillList)view.getControl("billlistap");
        taskList.addSetFilterListener((SetFilterListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("showdetail".equals(operateKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            Object primaryKeyValue = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            BillShowParameter bsp = new BillShowParameter();
            bsp.setStatus(OperationStatus.EDIT);
            bsp.setFormId("bos_cbs_shard_stat_detail");
            bsp.getOpenStyle().setShowType(ShowType.Modal);
            bsp.setPkId(primaryKeyValue);
            bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "DETAIL_FORM_CALL_BACK"));
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        switch (closedCallBackEvent.getActionId()) {
            case "DETAIL_FORM_CALL_BACK": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        IDataModel model = this.getModel();
        DynamicObject baseEntity = (DynamicObject)model.getValue("entitynumber");
        String number = null;
        if (baseEntity != null) {
            RefEntityType rdType = (RefEntityType)baseEntity.getDataEntityType();
            number = baseEntity.getString(rdType.getNumberProperty());
        }
        setFilterEvent.getCustomQFilters().add(new QFilter("entitynumber", "=", number).and(new QFilter("statistic", "=", model.getDataEntity().getPkValue())));
    }
}

