/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.statistics.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.cbs.plugin.statistics.common.entity.StatisticsEntity;
import kd.bos.cbs.plugin.statistics.service.StatisticsEntityService;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.xdb.hint.NoShardingHint;

public class StatisticsEntityServiceImpl
implements StatisticsEntityService {
    public static final StatisticsEntityServiceImpl instance = new StatisticsEntityServiceImpl();

    @Override
    public StatisticsEntity queryStatisticsByEntityNumber(String entityNumber) {
        IDataEntityType dt = ORM.create().getDataEntityType("bos_cbs_shard_statistic");
        String table = dt.getAlias();
        String fidField = dt.getPrimaryKey().getAlias();
        String entityNumberField = ((IDataEntityProperty)dt.getProperties().get((Object)"entitynumber")).getAlias();
        String createTimeField = ((IDataEntityProperty)dt.getProperties().get((Object)"createtime")).getAlias();
        String versionField = ((IDataEntityProperty)dt.getProperties().get((Object)"version")).getAlias();
        String modifyTimeField = ((IDataEntityProperty)dt.getProperties().get((Object)"modifytime")).getAlias();
        String sql = "select " + fidField + ", " + entityNumberField + ", " + createTimeField + ", " + versionField + ", " + modifyTimeField + " from " + table + " where " + entityNumberField + " = ? ";
        sql = "/*dialect*/" + NoShardingHint.genNoShardingSQL((String)sql);
        return (StatisticsEntity)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)sql, (Object[])new Object[]{entityNumber}, rs -> {
            StatisticsEntity statisticsEntity = new StatisticsEntity();
            if (rs.next()) {
                statisticsEntity.setId(rs.getLong(fidField));
                statisticsEntity.setEntityNumber(rs.getString(entityNumberField));
                statisticsEntity.setCreateTime(rs.getDate(createTimeField));
                statisticsEntity.setVersion(rs.getLong(versionField));
                statisticsEntity.setModifyTime(rs.getDate(modifyTimeField));
            }
            return statisticsEntity;
        });
    }

    @Override
    public List<StatisticsEntity> queryAllStatistics() {
        IDataEntityType dt = ORM.create().getDataEntityType("bos_cbs_shard_statistic");
        String table = dt.getAlias();
        String fidField = dt.getPrimaryKey().getAlias();
        String entityNumberField = ((IDataEntityProperty)dt.getProperties().get((Object)"entitynumber")).getAlias();
        String createTimeField = ((IDataEntityProperty)dt.getProperties().get((Object)"createtime")).getAlias();
        String versionField = ((IDataEntityProperty)dt.getProperties().get((Object)"version")).getAlias();
        String modifyTimeField = ((IDataEntityProperty)dt.getProperties().get((Object)"modifytime")).getAlias();
        String sql = "select " + fidField + ", " + entityNumberField + ", " + createTimeField + ", " + versionField + ", " + modifyTimeField + " from " + table;
        sql = "/*dialect*/" + NoShardingHint.genNoShardingSQL((String)sql);
        return (List)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)sql, rs -> {
            ArrayList<StatisticsEntity> ret = new ArrayList<StatisticsEntity>(16);
            while (rs.next()) {
                StatisticsEntity statisticsEntity = new StatisticsEntity();
                statisticsEntity.setId(rs.getLong(fidField));
                statisticsEntity.setEntityNumber(rs.getString(entityNumberField));
                statisticsEntity.setCreateTime(rs.getDate(createTimeField));
                statisticsEntity.setVersion(rs.getLong(versionField));
                statisticsEntity.setModifyTime(rs.getDate(modifyTimeField));
                ret.add(statisticsEntity);
            }
            return ret;
        });
    }

    @Override
    public void updateStatisticsVersion(String entityNumber, Date date) {
        IDataEntityType dt = ORM.create().getDataEntityType("bos_cbs_shard_statistic");
        String table = dt.getAlias();
        String entityNumberField = ((IDataEntityProperty)dt.getProperties().get((Object)"entitynumber")).getAlias();
        String versionField = ((IDataEntityProperty)dt.getProperties().get((Object)"version")).getAlias();
        String modifyTimeField = ((IDataEntityProperty)dt.getProperties().get((Object)"modifytime")).getAlias();
        String sql = "update " + table + " set " + versionField + " = " + versionField + "+1 , " + modifyTimeField + " = ? where " + entityNumberField + " = ?";
        sql = "/*dialect*/" + NoShardingHint.genNoShardingSQL((String)sql);
        DB.execute((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)sql, (Object[])new Object[]{date, entityNumber});
    }
}

