/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.statistics.service.impl;

import com.alibaba.druid.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.cbs.plugin.statistics.common.table.Table;
import kd.bos.cbs.plugin.statistics.service.XDBStatisticsService;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableName;

public class XDBStatisticsServiceImpl
implements XDBStatisticsService {
    private static final Log log = LogFactory.getLog(XDBStatisticsServiceImpl.class);
    public static final XDBStatisticsServiceImpl instance = new XDBStatisticsServiceImpl();
    static Class<?> entryType;
    static Class<?> subEntryType;
    private String dbRouteKey;

    @Override
    public List<Table> statisticTableInfo(String entityNumber) {
        ArrayList<Table> tables = new ArrayList<Table>(8);
        IDataEntityType dt = ORM.create().getDataEntityType(entityNumber);
        String dbRouteKey = dt.getDBRouteKey();
        String tableName = dt.getAlias();
        ShardConfigEntity configEntity = ShardConfigRepository.get().loadConfig(entityNumber);
        boolean isMock = false;
        if (null == configEntity) {
            configEntity = ShardConfigEntity.mockShardConfigEntity((String)entityNumber);
            isMock = true;
        }
        List shardingConfigs = configEntity.toShardingConfigs(isMock);
        for (ShardingConfig config : shardingConfigs) {
            tables.add(Table.table(dbRouteKey, config.getTable()));
        }
        Table mainTable = Table.table(dbRouteKey, tableName);
        tables.add(mainTable);
        this.collectTable(dt, true, mainTable, tables);
        return tables;
    }

    @Override
    public long countTable(String tableName) {
        String sql = "select count(1) from " + tableName;
        String dbRoute = this.getRouteOfTable(tableName);
        long count = (Long)DB.query((DBRoute)DBRoute.of((String)dbRoute), (String)sql, rs -> {
            rs.next();
            return rs.getLong(1);
        });
        return count;
    }

    @Override
    public void setRouteKey(String dbRouteKey) {
        this.dbRouteKey = dbRouteKey;
    }

    private void collectTable(IDataEntityType dt, boolean isMain, Table parent, List<Table> tables) {
        Table currentTable = parent;
        if (!isMain) {
            Table children = Table.childrenTable(dt.getAlias(), parent);
            tables.add(children);
            currentTable = children;
        }
        ArrayList<Table> childList = new ArrayList<Table>();
        HashSet<String> tableGroupSet = new HashSet<String>();
        DataEntityPropertyCollection dps = dt.getProperties();
        int n = dps.size();
        for (int i = 0; i < n; ++i) {
            IDataEntityProperty dp = (IDataEntityProperty)dps.get(i);
            this.collectTable(dp, tableGroupSet, currentTable, childList);
        }
        for (String ext : tableGroupSet) {
            Table extTable = Table.childrenTable(dt.getAlias() + "_" + ext, currentTable);
            XDBStatisticsServiceImpl.setAttr(extTable);
            tables.add(extTable);
        }
        if (!childList.isEmpty()) {
            tables.addAll(childList);
        }
    }

    private void collectTable(IDataEntityProperty dp, Set<String> tableGroupSet, Table currentTable, List<Table> childList) {
        if (dp instanceof ICollectionProperty) {
            if (dp instanceof DynamicLocaleProperty) {
                tableGroupSet.add("L");
            } else {
                IDataEntityType itemDT = ((ICollectionProperty)dp).getItemType();
                Class<?> cls = itemDT.getClass();
                if ((cls.isAssignableFrom(entryType) || cls.isAssignableFrom(subEntryType)) && itemDT.getAlias() != null && itemDT.getAlias().trim().length() > 0) {
                    this.collectTable(itemDT, false, currentTable, childList);
                }
            }
        } else if (!(dp instanceof IComplexProperty) && !ORMUtil.isDbIgnoreRefBaseData((IDataEntityProperty)dp)) {
            String tableGroup;
            if (ORMUtil.isDbIgnore((IDataEntityProperty)dp)) {
                // empty if block
            }
            if ((tableGroup = dp.getTableGroup()) != null && tableGroup.length() > 0) {
                tableGroupSet.add(tableGroup.toUpperCase());
            }
        }
    }

    private static void setAttr(Table table) {
        String attr = table.getTable().endsWith("_l") ? "is_lang_table" : "is_group_table";
        table.setAttribute(attr, true);
    }

    private String getRouteOfTable(String tableName) {
        String originalName = TableName.of((String)tableName).getOriginalName();
        MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getMainConfig(originalName);
        if (mainConfig == null) {
            return this.dbRouteKey;
        }
        String curRoute = mainConfig.getOptions().getIndexRoute().getRoute(tableName);
        return StringUtils.isEmpty((String)curRoute) ? mainConfig.getOptions().getDbRouteKey() : curRoute;
    }

    static {
        try {
            entryType = Class.forName("kd.bos.entity.EntryType");
            subEntryType = Class.forName("kd.bos.entity.SubEntryType");
        }
        catch (ClassNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }
}

