/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.tools;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.util.StringUtils;

public class OperationLogUtil {
    public static void writeLog(List<AppLogInfo> appLogInfoList) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        if (!appLogInfoList.isEmpty()) {
            logService.addBatchLog(appLogInfoList);
        }
    }

    public static OpLogAppInfo buildLogInfo(String msg, Long orgId, String opKey, IFormView view) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        return logInfo;
    }

    public static OpLogAppInfo buildLogInfo(String msg, Long orgId, String opKey, IFormView view, MultiLangEnumBridge opNameBridge) {
        AppInfo appInfo;
        String formNumber = view.getFormShowParameter().getFormId();
        String appNumber = view.getFormShowParameter().getAppId();
        String appId = " ";
        if (StringUtils.isNotEmpty((String)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        if (StringUtils.isBlank((String)appId)) {
            BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
            if (StringUtils.isNotEmpty((String)formNumber)) {
                appId = bizAppService.getAppIdByFormNum(formNumber);
            }
        }
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(formNumber);
        logInfo.setModifyBillID(formNumber);
        if (orgId != null && 0L != orgId) {
            logInfo.setOrgID(orgId);
        } else {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        }
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opKey, opNameBridge);
        logInfo.setOpDescription(msg);
        return logInfo;
    }
}

