/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FileItem {
    private static Log logger = LogFactory.getLog(FileItem.class);
    private String appId;
    private String fId;
    private String fileName;
    private String type;
    private String pageId;
    private String path;
    private InputStream in;
    private File[] tempFiles;
    private boolean createNewFileWhenExists = false;
    private boolean verified = false;
    private String tempFileUrl;

    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        this.deleteTempFiles();
    }

    private void deleteTempFiles() {
        if (this.tempFiles != null) {
            for (File temp : this.tempFiles) {
                if (temp.delete()) continue;
                logger.warn("\u5220\u9664\u6587\u4ef6\u5931\u8d25");
            }
        }
    }

    public FileItem(String fileName, String path, InputStream in) {
        this.fileName = fileName;
        this.path = path;
        this.in = in;
    }

    public void setTempFiles(File[] tempFiles) {
        this.tempFiles = tempFiles;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isCreateNewFileWhenExists() {
        return this.createNewFileWhenExists;
    }

    public void setCreateNewFileWhenExists(boolean createNewFileWhenExists) {
        this.createNewFileWhenExists = createNewFileWhenExists;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getFId() {
        return this.fId;
    }

    public void setFId(String fId) {
        this.fId = fId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public String getTempFileUrl() {
        return this.tempFileUrl;
    }

    public void setTempFileUrl(String tempFileUrl) {
        this.tempFileUrl = tempFileUrl;
    }
}

