/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class FileItemParser {
    private static Log logger = LogFactory.getLog(FileItemParser.class);
    private static String uploadTempDir = System.getProperty("java.io.tmpdir") + "/ierpupload";

    public static FileItem parseHttpRequest(HttpServletRequest request) {
        return FileItemParser.parseHttpRequest(request, uploadTempDir);
    }

    public static FileItem parseHttpRequest(HttpServletRequest request, String uploadTempDir) {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(102400);
        Path tempDir = Paths.get(uploadTempDir, new String[0]);
        if (!tempDir.toFile().exists()) {
            try {
                Files.createDirectories(tempDir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                logger.error("createDirectories error", (Throwable)ex);
                throw new KDException((Throwable)ex, BosErrorCode.createDirectoryFailed, new Object[]{"can't create directory, path:'" + uploadTempDir + "'"});
            }
        }
        factory.setRepository(tempDir.toFile());
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        ArrayList<File> tempFiles = new ArrayList<File>();
        InputStream in = null;
        try {
            List fileItems = upload.parseRequest(request);
            String appId = null;
            String fId = null;
            String fileName = null;
            String type = null;
            String url = null;
            String pageId = null;
            String createNewFileWhenExistsStr = null;
            for (org.apache.commons.fileupload.FileItem fileItem : fileItems) {
                File tempfile;
                if (fileItem instanceof DiskFileItem && (tempfile = ((DiskFileItem)fileItem).getStoreLocation()) != null && tempfile.exists()) {
                    tempFiles.add(tempfile);
                }
                if (fileItem.isFormField()) {
                    String name = fileItem.getFieldName();
                    if (name.equals("url")) {
                        url = fileItem.getString("UTF-8");
                        continue;
                    }
                    if (name.equals("createNewFileWhenExists")) {
                        createNewFileWhenExistsStr = fileItem.getString("UTF-8").trim();
                        continue;
                    }
                    if (name.equals("appId")) {
                        appId = fileItem.getString("UTF-8");
                        continue;
                    }
                    if (name.equals("fId")) {
                        fId = fileItem.getString("UTF-8");
                        continue;
                    }
                    if (name.equals("type")) {
                        type = fileItem.getString("UTF-8");
                        continue;
                    }
                    if (!name.equals("pageId")) continue;
                    pageId = fileItem.getString("UTF-8");
                    continue;
                }
                in = fileItem.getInputStream();
                fileName = fileItem.getName();
                fileName = fileName.replaceAll("\\\\", "/");
                int index = -1;
                index = fileName.lastIndexOf(47);
                if (index == -1) continue;
                fileName = fileName.substring(index + 1);
            }
            FileItem fileItem1 = new FileItem(fileName, url, in);
            if (!tempFiles.isEmpty()) {
                fileItem1.setTempFiles(tempFiles.toArray(new File[tempFiles.size()]));
            }
            if (createNewFileWhenExistsStr != null) {
                fileItem1.setCreateNewFileWhenExists(Boolean.parseBoolean(createNewFileWhenExistsStr));
            }
            if (!StringUtils.isBlank(appId)) {
                fileItem1.setAppId(appId);
            }
            if (!StringUtils.isBlank(fId)) {
                fileItem1.setFId(fId);
            }
            if (!StringUtils.isBlank(type)) {
                fileItem1.setType(type);
            }
            if (!StringUtils.isBlank(pageId)) {
                fileItem1.setPageId(pageId);
            }
            return fileItem1;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{"parse HttpRequest FileItem error."});
        }
    }
}

