/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.config;

import kd.bos.util.ConfigurationUtil;

public class FileServiceConfig {
    public static final ConfigItem<Boolean> FILE_RECYCLE_BIN_ENABLE = new ConfigItem<Boolean>("fileService.recycleBin.enable", true, "Enable RecycleBin feature");
    public static final ConfigItem<Boolean> FILE_RECYCLE_BIN_SPI_ENABLE = new ConfigItem<Boolean>("fileService.recycleBin.forSpi.enable", false, "Enable RecycleBin feature");
    public static final ConfigItem<Boolean> WATERMARK_OPT_PDFBOX_ENABLE = new ConfigItem<Boolean>("watermark.opt.pdfbox.enable", true, "use pdfbox");
    public static final ConfigItem<Boolean> WATERMARK_OPT_IMAGE_COMPRESS_ENABLE = new ConfigItem<Boolean>("watermark.opt.image.compress.enable", true, "image compress");
    public static final ConfigItem<Boolean> WATERMARK_OPT_PDF_ENABLE = new ConfigItem<Boolean>("fileservice.watermark.opt.pdf.enable", true, "pdf watermark optimize");
    public static final ConfigItem<Boolean> WATERMARK_OPT_PDF_PLAIN = new ConfigItem<Boolean>("fileservice.watermark.opt.pdf.plain", false, "true : plain random access file, false: mapped");
    public static final ConfigItem<Boolean> PREVIEW_SIZE_LIMIT_ENABLE = new ConfigItem<Boolean>("fileservice.preview.limit.enable", false, "Enable preview size limit");
    public static final ConfigItem<Long> PREVIEW_SIZE_LIMIT = new ConfigItem<Long>("preview.size.limit", 0L, "Preview size limit");
    public static final ConfigItem<Long> PREVIEW_SIZE_LIMIT_MAX = new ConfigItem<Long>("preview.size.limit.max", 0x6400000L, "Preview size limit max");
    public static final ConfigItem<Long> PREVIEW_SIZE_LIMIT_4_EXCEL = new ConfigItem<Long>("fileservice.preview.excel.limit.size", 0x6400000L, "Preview size limit to excel file");
    public static final ConfigItem<Boolean> PREVIEW_TRANS_EXCEL_ENABLE = new ConfigItem<Boolean>("fileservice.preview.trans.excel.enable", true, "Enable preview of excel trans content");
    public static final ConfigItem<Boolean> PREVIEW_WATERMARK_EXCEL_ENABLE = new ConfigItem<Boolean>("fileservice.preview.watermark.excel.enable", true, "Enable preview of excel watermarking");
    public static final ConfigItem<String> DOWNLOAD_BIG_FILE_ENABLE = new ConfigItem<String>("fileservice.download.bigfile.enable", "false", "Enable download big file model");
    public static final ConfigItem<Long> DOWNLOAD_BIG_FILE_REMOVE_DELAY = new ConfigItem<Long>("fileservice.download.bigfile.remove.delay", 10L, "download big file model remove delay");
    public static final ConfigItem<String> DOWNLOAD_BIG_FILE_TEMP_DIR = new ConfigItem<String>("fileservice.download.bigfile.temp.dir", "", "download big file model temp dir");

    public static class ConfigItem<T> {
        private final String key;
        private final T defaultValue;
        private final String description;

        public ConfigItem(String key, T defaultValue, String description) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public int getInt() {
            return ConfigurationUtil.getInteger((String)this.key, (Integer)((Integer)this.defaultValue));
        }

        public long getLong() {
            return ConfigurationUtil.getLong((String)this.key, (Long)((Long)this.defaultValue));
        }

        public T getDefault() {
            return this.defaultValue;
        }

        public String getString() {
            return ConfigurationUtil.getString((String)this.key, (String)((String)this.defaultValue));
        }

        public boolean getBoolean() {
            return ConfigurationUtil.getBoolean((String)this.key, (Boolean)((Boolean)this.defaultValue));
        }

        public String toString() {
            return String.format("[%s=%s,%s]", this.key, this.defaultValue, this.description);
        }

        public String getKey() {
            return this.key;
        }
    }
}

