/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.filter;

import com.alibaba.fastjson.JSON;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.util.ExceptionUtils;

public class WPSFileInfoFilter
implements Filter {
    public static final String ACTION_CLASS = "kd.bos.web.actions.AttachmentAction";
    public static final String ACTION_METHOD = "fileInfoForWps";
    private Object actionObject;
    private Method actionMethod;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            Class<?> clazz = Class.forName(ACTION_CLASS);
            this.actionObject = clazz.newInstance();
            this.actionMethod = clazz.getMethod(ACTION_METHOD, HttpServletRequest.class, HttpServletResponse.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Init kd.bos.web.actions.AttachmentAction failed", e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        try {
            this.actionMethod.invoke(this.actionObject, httpRequest, httpResponse);
        }
        catch (IllegalAccessException e) {
            this.writeErrorMessage(httpResponse, "reflect invoke kd.bos.web.actions.AttachmentAction#fileInfoForWps error:" + e.getMessage());
        }
        catch (InvocationTargetException e) {
            String msg = String.format("get file info failed: %s", e.getTargetException().getMessage());
            if (e.getTargetException() instanceof Exception) {
                msg = msg + "\n" + ExceptionUtils.getExceptionStackTraceMessage((Exception)((Exception)e.getTargetException()));
            }
            this.writeErrorMessage(httpResponse, msg);
        }
    }

    public void destroy() {
    }

    private void writeErrorMessage(HttpServletResponse servletResponse, String message) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("status", "error");
        result.put("description", message);
        servletResponse.setContentType("text/html;charset=utf-8");
        servletResponse.setHeader("Cache-Control", "no-cache");
        servletResponse.setHeader("Cache-Control", "no-store");
        servletResponse.setHeader("Pragma", "no-cache");
        servletResponse.setDateHeader("Expires", 0L);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)servletResponse.getOutputStream()), "utf-8");){
            writer.write(JSON.toJSONString(result));
            writer.flush();
        }
    }
}

