/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.impl;

import com.alibaba.fastjson.JSON;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import kd.bos.cache.TempTransResult;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.BatchDownloadRequest;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.ResolveUtils;
import kd.bos.fileservice.config.FileServiceConfig;
import kd.bos.fileservice.config.FileServiceTenantConfig;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.fileservice.impl.FileServiceVersion;
import kd.bos.fileservice.impl.HttpFileClient;
import kd.bos.fileservice.impl.TimeCachedMap;
import kd.bos.fileservice.multiserver.Dispatcher;
import kd.bos.fileservice.multiserver.DispatcherFactory;
import kd.bos.fileservice.permission.FilePermissionManager;
import kd.bos.fileservice.preview.PreviewServiceFactory;
import kd.bos.fileservice.recycle.RecycleBin;
import kd.bos.fileservice.utils.FileTimeoutUtil;
import kd.bos.fileservice.utils.FileUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public abstract class AbstractFileService
implements FileService {
    private static final String USER_AGENT = "USER-AGENT";
    private static final String STATUS_CODE = "statusCode";
    private static final String INPUT_STREAM = "inputStream";
    public static final String UTF_8 = "utf-8";
    public static final String ERROR = "error";
    public static final String COOKIE = "Cookie";
    private static final int DEFAULT_TRANS_UNIT = 1024;
    private static final String BOS_FILESERVICE_SDK = "bos-fileservice-sdk";
    public static final String STATUS = "status";
    public static final String DESCRIPTION = "description";
    public static final String UPLOAD = "upload ";
    public static final String FILESERVER_CLIENT_READ_TIMEOUT = "fileserver.client.readTimeout";
    private static final String FILESERVER_AUTH_USER = "fileserver.authuser";
    private static final String FILESERVER_AUTH_PASS = "fileserver.authpass";
    private static final String FILESERVER_SSL_KEYSTORE_KEY = "fileserver.ssl.keystore";
    private static final String FILESERVER_SSL_KEYPASS_KEY = "fileserver.ssl.keypass";
    private static final String UPLOAD_URL_PREFIX = "file/upload.do";
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static Set<String> picSuffixes = new HashSet<String>();
    private int uploadTimeout;
    private final Dispatcher fileServerDispatcher;
    private String serverHttpUrlConfigKey;
    private String serverPreviewUrlConfigKey;
    private int bufferSize;
    private static Log logger;
    private boolean isPreviewcacheEnable;
    private TimeCachedMap<String> map = new TimeCachedMap(3000);

    public AbstractFileService(String serverHttpUrlConfigKey, String serverPreviewUrlConfigKey, int uploadTimeout, boolean isPreviewcacheEnable, int bufferSize) {
        this.uploadTimeout = uploadTimeout;
        this.isPreviewcacheEnable = isPreviewcacheEnable;
        this.bufferSize = bufferSize;
        this.serverHttpUrlConfigKey = serverHttpUrlConfigKey;
        this.serverPreviewUrlConfigKey = serverPreviewUrlConfigKey;
        this.fileServerDispatcher = DispatcherFactory.build(serverHttpUrlConfigKey, BosErrorCode.fileServerNotConfigured);
        this.map = new TimeCachedMap(Integer.parseInt(System.getProperty("fileserver.ticket.cache.timeout", "3000")));
    }

    public AbstractFileService(String serverHttpUrlConfigKey, int uploadTimeout) {
        this.uploadTimeout = uploadTimeout;
        this.serverHttpUrlConfigKey = serverHttpUrlConfigKey;
        this.fileServerDispatcher = DispatcherFactory.build(serverHttpUrlConfigKey, BosErrorCode.fileServerNotConfigured);
        this.map = new TimeCachedMap(Integer.parseInt(System.getProperty("fileserver.ticket.cache.timeout", "3000")));
    }

    @Override
    public String getHttpUrlPrefix() {
        return this.fileServerDispatcher.select();
    }

    private boolean isEmpty(String str) {
        return str == null ? true : str.trim().length() == 0;
    }

    private boolean isNotEmpty(String str) {
        return !this.isEmpty(str);
    }

    @Override
    @SdkInternal
    public String getPublicKey() {
        String httpUrlPrefix = this.getHttpUrlPrefix();
        String publicKey = "";
        String userName = this.authUserName();
        if (StringUtils.isEmpty((String)userName)) {
            return publicKey;
        }
        CloseableHttpClient client1 = this.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
        HttpGet get = new HttpGet();
        try {
            String uri = httpUrlPrefix + "/auth/getPublicKey.do";
            get.setURI(new URI(uri));
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.getTicketFailed, new Object[]{"get getPublicKey failed for url illegal"});
        }
        InputStream in = null;
        try {
            get.addHeader(COOKIE, "userName=" + userName);
            CloseableHttpResponse response = client1.execute((HttpUriRequest)get);
            in = response.getEntity().getContent();
            byte[] b = new byte[1024];
            int length = in.read(b);
            String rpStr = new String(b, 0, length, UTF_8);
            Map<String, String> rpMap = ResolveUtils.resolveJson(rpStr);
            String string = publicKey = rpMap.get("data");
            return string;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.getTicketFailed, new Object[]{"get publicKey failed for url illegal:"});
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            try {
                client1.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    @Override
    public String getTicket() {
        String httpUrlPrefix = this.getHttpUrlPrefix();
        String ticketStr = "ticket";
        String ticket = this.map.get(ticketStr);
        if (ticket != null) {
            return ticket;
        }
        CloseableHttpClient client1 = this.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
        HttpGet get = new HttpGet();
        try {
            String uri = httpUrlPrefix + "/login/getTicket.do";
            get.setURI(new URI(uri));
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.getTicketFailed, new Object[]{"get ticket failed for url illegal"});
        }
        InputStream in = null;
        try {
            String passWord = this.authPassWord();
            get.addHeader(COOKIE, "userName=" + this.authUserName());
            get.addHeader(COOKIE, "passWord=" + passWord);
            CloseableHttpResponse response = client1.execute((HttpUriRequest)get);
            in = response.getEntity().getContent();
            byte[] b = new byte[1024];
            int length = in.read(b);
            String rpStr = new String(b, 0, length, UTF_8);
            Map<String, String> rpMap = ResolveUtils.resolveJson(rpStr);
            String status = rpMap.get(STATUS);
            if (status != null && ERROR.equals(status)) {
                throw new KDException(BosErrorCode.getTicketFailed, new Object[]{rpMap.get(DESCRIPTION)});
            }
            ticket = rpMap.get("data");
            this.map.put(ticketStr, ticket);
            String string = ticket;
            return string;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.getTicketFailed, new Object[]{"get ticket failed for url illegal:"});
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            try {
                client1.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    @Override
    public List<String> upload(FileItem[] fileItems) {
        ArrayList<String> list = new ArrayList<String>(fileItems.length);
        try {
            for (FileItem item : fileItems) {
                list.add(this.upload(item));
            }
        }
        catch (KDException e) {
            for (String url : list) {
                try {
                    this.physicalDelete(url);
                }
                catch (KDException e2) {
                    logger.error(e.getMessage(), (Throwable)e);
                    logger.error("Fail delete url when post error.", (Throwable)e2);
                }
            }
            throw e;
        }
        return list;
    }

    @Override
    public void delete(String path) {
        if (RecycleBin.fileServerOpened()) {
            if (this.exists(path)) {
                try (InputStream in = this.getInputStream(path);){
                    String recyclePath = path.startsWith("/") ? RecycleBin.getCurrentDateRecyclePath() + path : RecycleBin.getCurrentDateRecyclePath() + "/" + path;
                    FileItem item = new FileItem("", recyclePath, in);
                    this.upload(item);
                }
                catch (Exception e) {
                    logger.error("Soft delete error, path: " + path, (Throwable)e);
                    throw new KDException((Throwable)e, BosErrorCode.deleteFailed, new Object[]{path + ERROR});
                }
                this.physicalDelete(path);
            }
        } else {
            this.physicalDelete(path);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void physicalDelete(String path) {
        String httpUrlPrefix = this.getHttpUrlPrefix();
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            client = this.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
            HttpGet get = new HttpGet();
            this.setCookie(get);
            String uri = null;
            path = this.getFileServiceExt().getRealPath(path);
            path = FilePermissionManager.checkDownloadPath(path, this);
            path = URLEncoder.encode(path, UTF_8);
            uri = !httpUrlPrefix.endsWith("/") ? httpUrlPrefix + "/file/remove.do?path=" + path : httpUrlPrefix + "file/remove.do?path=" + path;
            get.setURI(new URI(uri));
            response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                HttpEntity resEntity = response.getEntity();
                String respStr = EntityUtils.toString((HttpEntity)resEntity, (String)UTF_8);
                throw new KDException(BosErrorCode.deleteFailed, new Object[]{respStr});
            }
            this.getFileServiceExt().afterDeleteFile(path);
            this.closeClientAndResponse(client, response);
            return;
        }
        catch (KDException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.deleteFailed, new Object[]{path + ERROR});
                }
            }
            catch (Throwable throwable) {
                this.closeClientAndResponse(client, response);
                throw throwable;
            }
        }
    }

    protected void closeClientAndResponse(CloseableHttpClient client, CloseableHttpResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    protected void setCookie(HttpGet get) {
        if (this.needAuth()) {
            String ticket = this.getTicket();
            get.addHeader(COOKIE, "ticket=" + ticket);
        }
    }

    private void setCookie(Map<String, String> header) {
        if (header != null && this.needAuth()) {
            String ticket = this.getTicket();
            header.put(COOKIE, "ticket=" + ticket);
        }
    }

    @Override
    public String upload(FileItem item) {
        return this.upload(item, null);
    }

    private String upload(FileItem item, Map<String, String> headers) {
        String httpUrlPrefix = this.getHttpUrlPrefix();
        String httpUploadUrlPrefix = null;
        httpUploadUrlPrefix = httpUrlPrefix.endsWith("/") ? httpUrlPrefix + UPLOAD_URL_PREFIX : httpUrlPrefix + "/file/upload.do";
        boolean createNewFileWhenExists = item.isCreateNewFileWhenExists();
        InputStream inputStream = null;
        try {
            if (!item.isVerified()) {
                inputStream = this.getFileServiceExt().checkFile(item.getInputStream(), item.getFileName());
                item.setVerified(true);
            } else {
                inputStream = item.getInputStream();
            }
            String path = this.getFileServiceExt().getRealPath(item.getPath());
            path = FilePermissionManager.checkUploadPath(path);
            path = path.replaceAll("\\\\", "/");
            inputStream = this.getFileServiceExt().encode(path, inputStream);
            String filename = path.substring(path.lastIndexOf(47) + 1);
            item = new FileItem(filename, path, inputStream);
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put("version", FileServiceVersion.VERSION1.toString());
            arg.put("url", item.getPath().replaceAll("[=+%?&#]", "_"));
            arg.put("fileName", item.getFileName().replaceAll("[=+%?&#]", "_"));
            arg.put("createNewFileWhenExists", String.valueOf(createNewFileWhenExists));
            if (headers != null) {
                arg.putAll(headers);
            }
            try {
                if (item.getFileName() != null && item.getFileName().lastIndexOf(".") <= 0) {
                    throw new KDException(BosErrorCode.uploadFailed, new Object[]{"upload file " + item.getPath() + Resources.getString((String)" failed. description: \u6587\u4ef6\u6269\u5c55\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractFileService_0", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0])});
                }
                if (this.needAuth()) {
                    arg.put("ticket", this.getTicket());
                }
                Map<String, String> result = HttpFileClient.sendFile(httpUploadUrlPrefix, this.uploadTimeout * 1000, item.getInputStream(), arg);
                item.close();
                if (result != null) {
                    String description;
                    String url = result.get("url");
                    if (this.isEmpty(url) && this.isNotEmpty(description = result.get(DESCRIPTION))) {
                        throw new KDException(BosErrorCode.uploadFailed, new Object[]{UPLOAD + item.getPath() + " failed. description:" + description});
                    }
                    String string = this.getFileServiceExt().save(url);
                    return string;
                }
                try {
                    throw new KDException(BosErrorCode.uploadFailed, new Object[]{"upload timeout within " + this.uploadTimeout + " seconds" + item.getPath()});
                }
                catch (KDException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{UPLOAD + item.getPath() + " failed."});
                }
            }
            finally {
                item.close();
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("stream close error");
                }
            }
        }
    }

    @Override
    public String compressPicUpload(FileItem fileItem, long capacity) {
        String fileName = fileItem.getFileName();
        InputStream compressedInputStream = FileUtil.compressPic(fileName, fileItem.getInputStream(), capacity);
        FileItem newFileItem = new FileItem(fileName, fileItem.getPath(), compressedInputStream);
        newFileItem.setCreateNewFileWhenExists(fileItem.isCreateNewFileWhenExists());
        return this.upload(newFileItem);
    }

    private CloseableHttpResponse excuteDownLoadRequest(CloseableHttpClient httpClient, String httpUrlPrefix, String path, Map<String, String> headerMap) throws IOException, URISyntaxException {
        HttpGet get = new HttpGet();
        this.setCookie(get);
        String uri = null;
        path = this.getFileServiceExt().getRealPath(path);
        path = FilePermissionManager.checkDownloadPath(path, this);
        path = URLEncoder.encode(path, UTF_8);
        uri = !httpUrlPrefix.endsWith("/") && !path.startsWith("/") ? httpUrlPrefix + "/" + path : httpUrlPrefix + path;
        get.setURI(new URI(uri));
        for (Map.Entry<String, String> entry : headerMap.entrySet()) {
            get.setHeader(entry.getKey(), entry.getValue());
        }
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
        if (response.getStatusLine().getStatusCode() == 200) {
            return response;
        }
        HttpEntity resEntity = response.getEntity();
        String respStr = EntityUtils.toString((HttpEntity)resEntity, (String)UTF_8);
        throw new KDException(BosErrorCode.downloadFailed, new Object[]{respStr});
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void download(String path, HttpServletResponse servletResponse, String userAgent) {
        InputStream decode;
        Boolean isBigFileEnable;
        String tempFilePath;
        block50: {
            CloseableHttpResponse response = null;
            CloseableHttpClient client = null;
            String httpUrlPrefix = this.getHttpUrlPrefix();
            String tempDir = FileServiceConfig.DOWNLOAD_BIG_FILE_TEMP_DIR.getString();
            if (tempDir == null || "".equals(tempDir)) {
                tempDir = TEMP_DIR;
            }
            tempFilePath = FileUtils.checkFileUrl((String)(tempDir + "/download-" + UUID.randomUUID().toString().replace("-", "")));
            InputStream in = null;
            String isBigFileEnableStr = FileServiceFactory.getPropertyByTenant(FileServiceConfig.DOWNLOAD_BIG_FILE_ENABLE.getKey());
            isBigFileEnable = isBigFileEnableStr != null && !"".equals(isBigFileEnableStr) ? Boolean.valueOf(Boolean.parseBoolean(isBigFileEnableStr)) : Boolean.valueOf(false);
            decode = null;
            try {
                try (ServletOutputStream out7 = servletResponse.getOutputStream();){
                    HashMap<String, String> headerMap = new HashMap<String, String>();
                    if (userAgent != null) {
                        headerMap.put(USER_AGENT, userAgent);
                    }
                    client = this.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
                    response = this.excuteDownLoadRequest(client, httpUrlPrefix, path, headerMap);
                    this.copyResponesStatus((HttpResponse)response, servletResponse);
                    if (isBigFileEnable.booleanValue()) {
                        InputStream tempIn = response.getEntity().getContent();
                        try (FileOutputStream tempOutputStream = new FileOutputStream(tempFilePath);){
                            byte[] buffer = new byte[8192];
                            int len = 0;
                            while ((len = tempIn.read(buffer)) != -1) {
                                ((OutputStream)tempOutputStream).write(buffer, 0, len);
                            }
                        }
                        in = new FileInputStream(tempFilePath);
                    } else {
                        in = response.getEntity().getContent();
                    }
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    Map<String, Object> ret = this.getFileServiceExt().beforeWrite(path, in, userAgent, params);
                    decode = (InputStream)ret.get("returnInputStream");
                    if (FileServiceTenantConfig.DOWNLOAD_FILE_SIZE_DEF_ENABLE.getBooleanTenant()) {
                        servletResponse.setHeader("Content-Length", String.valueOf(decode.available()));
                    }
                    if (ret.get("fileSize") != null) {
                        servletResponse.setHeader("Content-Length", (String)ret.get("fileSize"));
                    }
                    byte[] buffer = new byte[8192];
                    int len = 0;
                    while ((len = decode.read(buffer)) != -1) {
                        out7.write(buffer, 0, len);
                    }
                    out7.flush();
                }
                this.closeClientAndResponse(client, response);
                if (in == null) break block50;
            }
            catch (KDException e) {
                try {
                    throw e;
                    catch (Exception e2) {
                        throw new KDException((Throwable)e2, BosErrorCode.downloadFailed, new Object[]{path + ERROR});
                    }
                }
                catch (Throwable throwable) {
                    this.closeClientAndResponse(client, response);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (decode != null) {
                        try {
                            decode.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (isBigFileEnable == false) throw throwable;
                    FileTimeoutUtil.removeFile(tempFilePath, null, FileServiceConfig.DOWNLOAD_BIG_FILE_REMOVE_DELAY.getLong());
                    throw throwable;
                }
            }
            try {
                in.close();
            }
            catch (IOException out7) {
                // empty catch block
            }
        }
        if (decode != null) {
            try {
                decode.close();
            }
            catch (IOException out7) {
                // empty catch block
            }
        }
        if (isBigFileEnable == false) return;
        FileTimeoutUtil.removeFile(tempFilePath, null, FileServiceConfig.DOWNLOAD_BIG_FILE_REMOVE_DELAY.getLong());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void download(String path, OutputStream out, String userAgent) {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        String httpUrlPrefix = this.getHttpUrlPrefix();
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            if (userAgent != null) {
                headerMap.put(USER_AGENT, userAgent);
            }
            client = this.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
            response = this.excuteDownLoadRequest(client, httpUrlPrefix, path, headerMap);
            InputStream in = response.getEntity().getContent();
            InputStream decodeStream = this.getFileServiceExt().beforeWriteToResponse(path, in, userAgent);
            byte[] buffer = new byte[8192];
            int len = 0;
            while (true) {
                if ((len = decodeStream.read(buffer)) <= 0) {
                    this.closeClientAndResponse(client, response);
                    return;
                }
                out.write(buffer, 0, len);
            }
        }
        catch (KDException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.downloadFailed, new Object[]{path + ERROR});
                }
            }
            catch (Throwable throwable) {
                this.closeClientAndResponse(client, response);
                throw throwable;
            }
        }
    }

    @Override
    public Map<String, Object> download(String path, String userAgent, String ext) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        String httpUrlPrefix = this.getHttpUrlPrefix();
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            if (userAgent != null) {
                headerMap.put(USER_AGENT, userAgent);
            }
            client = this.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
            response = this.excuteDownLoadRequest(client, httpUrlPrefix, path, headerMap);
            int statusCode = 0;
            for (Header header : response.getAllHeaders()) {
                String headerName = header.getName();
                String headerValue = header.getValue();
                if ("internalError".equals(headerName) && "true".equals(headerValue)) {
                    statusCode = 500;
                    break;
                }
                if (!"isFileExist".equals(headerName) || !"false".equals(headerValue)) continue;
                statusCode = 204;
                break;
            }
            InputStream in = response.getEntity().getContent();
            InputStream decodeStream = this.getFileServiceExt().decode(path, in);
            if ("txt".equalsIgnoreCase(ext)) {
                InputStream tempIn = null;
                tempIn = !decodeStream.markSupported() ? new BufferedInputStream(decodeStream) : decodeStream;
                tempIn.mark(Integer.MAX_VALUE);
                String fileCharset = FileUtil.getFilecharset(tempIn);
                logger.info(String.format("txt\u6587\u4ef6\u7f16\u7801\u4e3a%s", fileCharset));
                result.put(PreviewParams.CHARSET.getEnumName(), fileCharset);
                tempIn.reset();
                result.put(INPUT_STREAM, tempIn);
            } else {
                result.put(INPUT_STREAM, decodeStream);
            }
            result.put(STATUS_CODE, statusCode);
            return result;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{path + ERROR});
        }
    }

    @Override
    public InputStream download(String path, Map<String, String> header, Map<String, String> resHeader) {
        String httpUrlPrefix = this.getHttpUrlPrefix();
        String ext = path.substring(path.lastIndexOf(46) + 1);
        InputStream decodeStream = null;
        try {
            String realPath = this.getFileServiceExt().getRealPath(path);
            realPath = FilePermissionManager.checkDownloadPath(realPath, this);
            realPath = URLEncoder.encode(realPath, UTF_8);
            String url = httpUrlPrefix + (!httpUrlPrefix.endsWith("/") && !realPath.startsWith("/") ? "/" : "") + realPath;
            this.setCookie(header);
            int connectTimeout = Integer.parseInt(System.getProperty("fileserver.client.connectTimeout", "5000"));
            int readTimeout = Integer.parseInt(System.getProperty(FILESERVER_CLIENT_READ_TIMEOUT, "10000"));
            Map<String, Object> result = HttpFileClient.getFileStreamAndHeader(url, connectTimeout, readTimeout, header);
            resHeader.putAll((HashMap)result.get("header"));
            InputStream in = (InputStream)result.get("INPUT_STREAM");
            decodeStream = this.getFileServiceExt().decode(url, in);
            if ("true".equals(header.get("preview"))) {
                if (!"true".equals(resHeader.get("fromCache"))) {
                    throw new KDException(BosErrorCode.downloadFailed, new Object[]{Resources.getString((String)"\u4ece\u6587\u4ef6\u670d\u52a1\u5668\u4e2d\u83b7\u53d6\u9884\u89c8\u7f13\u5b58\u5931\u8d25", (String)"AbstractFileService_2", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0])});
                }
            } else if ("true".equals(resHeader.get("internalError")) || "false".equals(resHeader.get("isFileExist"))) {
                throw new KDException(BosErrorCode.downloadFailed, new Object[]{Resources.getString((String)"\u4ece\u6587\u4ef6\u670d\u52a1\u5668\u4e2d\u83b7\u53d6\u56fe\u7247,txt\u6587\u4ef6,\u6216pdf\u6d41\u5931\u8d25", (String)"AbstractFileService_2", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0]) + IOUtils.toString((InputStream)decodeStream)});
            }
        }
        catch (Exception e) {
            if (decodeStream != null) {
                try {
                    decodeStream.close();
                }
                catch (IOException e1) {
                    logger.info("close in fail", (Object)e1);
                }
            }
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{e.getMessage()});
        }
        InputStream tempIn = "txt".equalsIgnoreCase(ext) && !decodeStream.markSupported() ? new BufferedInputStream(decodeStream) : decodeStream;
        return tempIn;
    }

    @Override
    public InputStream getInputStream(String path) {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        String httpUrlPrefix = this.getHttpUrlPrefix();
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            client = this.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
            response = this.excuteDownLoadRequest(client, httpUrlPrefix, path, headerMap);
            InputStream in = response.getEntity().getContent();
            InputStream decode = this.getFileServiceExt().decode(path, in);
            return decode;
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{path + " download failed."});
        }
    }

    @Override
    public Map<String, Object> preview(String fileName, String path, String userAgent) {
        return PreviewServiceFactory.getPreviewService(this).preview(fileName, path, userAgent);
    }

    @Override
    public void removePreview(String id) {
        PreviewServiceFactory.getPreviewService(this).removePreview(id);
    }

    @Override
    public Map<String, Object> previewFromCache(String fileName, String path, String userAgent, InputStream cacheIn) {
        return PreviewServiceFactory.getPreviewService(this).previewFromCache(fileName, path, userAgent, cacheIn);
    }

    @Override
    public Map<String, Object> previewWPS(String fileName, String path, String userAgent, Map<String, String> config) {
        return PreviewServiceFactory.getPreviewService(this).previewWPS(fileName, path, userAgent, config);
    }

    @Override
    public Map<String, Object> previewFromCacheWPS(String fileName, String path, String userAgent, InputStream cacheIn, Map<String, String> config) {
        return PreviewServiceFactory.getPreviewService(this).previewFromCacheWPS(fileName, path, userAgent, cacheIn, config);
    }

    @Override
    public void deletePreviewCacheWps(String url, Map<String, String> config) {
        PreviewServiceFactory.getPreviewService(this).deletePreviewCacheWps(url, config);
    }

    @Override
    public void deletePreviewWps(String path, Map<String, String> config) {
        PreviewServiceFactory.getPreviewService(this).deletePreviewWps(path, config);
    }

    private void copyResponesStatus(HttpResponse response1, HttpServletResponse servletResponse) {
        Header[] hds;
        for (Header h : hds = response1.getAllHeaders()) {
            if ("isFileExist".equals(h.getName()) && "false".equals(h.getValue())) {
                servletResponse.setHeader("Content-Disposition", null);
            }
            if (servletResponse.getHeader(h.getName()) != null || !this.isSupportCustomEncode(h.getName())) continue;
            servletResponse.addHeader(h.getName(), h.getValue());
        }
        servletResponse.setStatus(response1.getStatusLine().getStatusCode());
    }

    private boolean isSupportCustomEncode(String headerName) {
        return !"Transfer-Encoding".equals(headerName);
    }

    @Override
    public void batchDownload(BatchDownloadRequest request, OutputStream out, String userAgent) {
        ZipOutputStream zout = null;
        try {
            String encoding = System.getProperty("fileservice.batchdownload.encoding", "gbk");
            zout = new ZipOutputStream(out);
            zout.setEncoding(encoding);
            this.filesZip(request.getFiles(), zout, userAgent, "");
            this.DirsZip(request.getDirs(), zout, userAgent, "");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (zout != null) {
                try {
                    zout.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    @Override
    public void batchDownload(BatchDownloadRequest request, HttpServletResponse servletResponse, String userAgent) {
        ServletOutputStream out = null;
        try {
            out = servletResponse.getOutputStream();
            this.batchDownload(request, (OutputStream)out, userAgent);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[0]);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getAllowExtensions() {
        String httpUrlPrefix = this.getHttpUrlPrefix();
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            client = this.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
            HttpGet get = new HttpGet();
            this.setCookie(get);
            String uri = null;
            uri = !httpUrlPrefix.endsWith("/") ? httpUrlPrefix + "/file/getAllowExtensions.do" : httpUrlPrefix + "file/getAllowExtensions.do";
            get.setURI(new URI(uri));
            response = client.execute((HttpUriRequest)get);
            HttpEntity resEntity = response.getEntity();
            String respStr = EntityUtils.toString((HttpEntity)resEntity, (String)UTF_8);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{respStr});
            }
            Map<String, String> responseMap = ResolveUtils.resolveJson(respStr);
            if (responseMap != null) {
                String description;
                if (ERROR.equals(responseMap.get(STATUS)) && this.isNotEmpty(description = responseMap.get(DESCRIPTION))) {
                    throw new KDException(BosErrorCode.fileserviceException, new Object[]{description});
                }
                String data = responseMap.get("data");
                if (data != null && data.length() > 0) {
                    for (String str : data.split(",")) {
                        result.add(str);
                    }
                }
            }
            this.closeClientAndResponse(client, response);
            return result;
        }
        catch (KDException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.fileserviceException, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                this.closeClientAndResponse(client, response);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getForbiddenExtensions() {
        String httpUrlPrefix = this.getHttpUrlPrefix();
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            client = this.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
            HttpGet get = new HttpGet();
            this.setCookie(get);
            String uri = null;
            uri = !httpUrlPrefix.endsWith("/") ? httpUrlPrefix + "/file/getForbiddenExtensions.do" : httpUrlPrefix + "file/getForbiddenExtensions.do";
            get.setURI(new URI(uri));
            response = client.execute((HttpUriRequest)get);
            HttpEntity resEntity = response.getEntity();
            String respStr = EntityUtils.toString((HttpEntity)resEntity, (String)UTF_8);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{respStr});
            }
            Map<String, String> respMap = ResolveUtils.resolveJson(respStr);
            if (respMap != null) {
                String desc;
                if (ERROR.equals(respMap.get(STATUS)) && this.isNotEmpty(desc = respMap.get(DESCRIPTION))) {
                    throw new KDException(BosErrorCode.fileserviceException, new Object[]{desc});
                }
                String dataStr = respMap.get("data");
                if (dataStr != null && dataStr.length() > 0) {
                    for (String str : dataStr.split(",")) {
                        result.add(str);
                    }
                }
            }
            this.closeClientAndResponse(client, response);
            return result;
        }
        catch (KDException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.fileserviceException, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                this.closeClientAndResponse(client, response);
                throw throwable;
            }
        }
    }

    private void filesZip(BatchDownloadRequest.File[] files, ZipOutputStream out, String userAgent, String path) {
        if (files != null) {
            for (BatchDownloadRequest.File file : files) {
                if (file == null) continue;
                this.simpleFileZip(file, out, userAgent, path);
            }
        }
    }

    private void DirsZip(BatchDownloadRequest.Dir[] dirs, ZipOutputStream out, String userAgent, String path) {
        if (dirs != null) {
            for (BatchDownloadRequest.Dir dir : dirs) {
                this.simpleDirZip(dir, out, userAgent, path);
            }
        }
    }

    private void simpleDirZip(BatchDownloadRequest.Dir dir, ZipOutputStream out, String userAgent, String path) {
        String dirname = dir.getName();
        this.filesZip(dir.getFiles(), out, userAgent, "".equals(path) ? dirname : path + "/" + dirname);
        this.DirsZip(dir.getDirs(), out, userAgent, "".equals(path) ? dirname : path + "/" + dirname);
    }

    private void simpleFileZip(BatchDownloadRequest.File file, ZipOutputStream out, String userAgent, String path) {
        String httpUrlPrefix = this.getHttpUrlPrefix();
        CloseableHttpClient client1 = this.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
        String url = file.getUrl();
        String entryName = file.getName();
        HttpGet get = new HttpGet();
        try {
            this.setCookie(get);
            String uri = null;
            url = this.getFileServiceExt().getRealPath(url);
            url = FilePermissionManager.checkDownloadPath(url, this);
            url = URLEncoder.encode(url, UTF_8);
            uri = !httpUrlPrefix.endsWith("/") && !url.startsWith("/") ? httpUrlPrefix + "/" + url : httpUrlPrefix + url;
            get.setURI(new URI(uri));
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.downloadFailed, new Object[]{"url illegal:" + url});
        }
        if (userAgent != null) {
            get.setHeader(USER_AGENT, userAgent);
        }
        InputStream in = null;
        try {
            CloseableHttpResponse response1 = client1.execute((HttpUriRequest)get);
            in = this.getFileServiceExt().beforeWriteToResponse(file.getUrl(), response1.getEntity().getContent(), userAgent);
            this.doZip(in, out, path, entryName);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.downloadFailed, new Object[]{url + ERROR});
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            try {
                client1.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    private void doZip(InputStream in, ZipOutputStream out, String dir, String entryName) throws IOException {
        if (!"".equals(dir)) {
            entryName = dir + "/" + entryName;
        }
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        int len = 0;
        byte[] buffer = new byte[8192];
        BufferedInputStream fis = new BufferedInputStream(in);
        while ((len = fis.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
        out.closeEntry();
        fis.close();
    }

    @Override
    public boolean exists(String path) {
        return this.isExists(path, false);
    }

    @Override
    public boolean _existsNopm(String path) {
        return this.isExists(path, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isExists(String path, boolean isNoPm) {
        String httpUrlPrefix = this.getHttpUrlPrefix();
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            client = this.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
            HttpGet get = new HttpGet();
            this.setCookie(get);
            path = this.getFileServiceExt().getRealPath(path);
            if (!isNoPm) {
                path = FilePermissionManager.checkDownloadPath(path, this);
            }
            path = URLEncoder.encode(path, UTF_8);
            String uri = !httpUrlPrefix.endsWith("/") ? httpUrlPrefix + "/file/exists.do?path=" + path : httpUrlPrefix + "file/exists.do?path=" + path;
            get.setURI(new URI(uri));
            response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                HttpEntity httpEntity = response.getEntity();
                String respStr = EntityUtils.toString((HttpEntity)httpEntity, (String)UTF_8);
                throw new KDException(BosErrorCode.downloadFailed, new Object[]{respStr});
            }
            String respStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)UTF_8);
            Map<String, String> responseMap = ResolveUtils.resolveJson(respStr);
            String data = responseMap.get("data");
            if (data != null && data.equals("true")) {
                boolean bl = true;
                this.closeClientAndResponse(client, response);
                return bl;
            }
        }
        catch (KDException e) {
            try {
                logger.error((Throwable)e);
                throw e;
                catch (Exception e2) {
                    logger.error((Throwable)e2);
                    throw new KDException((Throwable)e2, BosErrorCode.downloadFailed, new Object[]{String.format("call AbstractFileService#exist err found, path: %s", path)});
                }
            }
            catch (Throwable throwable) {
                this.closeClientAndResponse(client, response);
                throw throwable;
            }
        }
        {
            boolean bl = false;
            this.closeClientAndResponse(client, response);
            return bl;
        }
    }

    protected CloseableHttpClient getHttpClient(String region) {
        int connectTimeout = Integer.parseInt(System.getProperty("fileserver.client.connectTimeout", "5000"));
        int readTimeout = Integer.parseInt(System.getProperty(FILESERVER_CLIENT_READ_TIMEOUT, "10000"));
        SSLConnectionSocketFactory scsf = this.getSslConnectionSocketFactory(region);
        CloseableHttpClient client1 = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(connectTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(readTimeout).build()).setSSLSocketFactory((LayeredConnectionSocketFactory)scsf).build();
        return client1;
    }

    @Override
    public String authUserName() {
        return System.getProperty(FILESERVER_AUTH_USER, "");
    }

    @Override
    public String authPassWord() {
        String authPass = System.getProperty(FILESERVER_AUTH_PASS, "");
        if (StringUtils.isNotEmpty((String)authPass)) {
            authPass = Encrypters.decode((String)authPass);
        }
        return authPass;
    }

    @Override
    public boolean needAuth() {
        return StringUtils.isNotEmpty((String)this.authUserName()) && StringUtils.isNotEmpty((String)this.authPassWord());
    }

    @Override
    public List<String> getFileServerList() {
        return this.fileServerDispatcher.getServers();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkServer(String url) {
        if (this.isEmpty(url)) {
            throw new KDException(BosErrorCode.fileServerNotConfigured, new Object[]{"checkServer() fail. The url is empty"});
        }
        String tempPath = UUID.randomUUID().toString().replace("-", "") + ".png";
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            SSLConnectionSocketFactory scsf = this.getSslConnectionSocketFactory(this.getConfigKeyRegion(url));
            client = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(1000).setConnectTimeout(1000).setSocketTimeout(1000).build()).setSSLSocketFactory((LayeredConnectionSocketFactory)scsf).build();
            HttpGet get = new HttpGet();
            this.setCookie(get);
            String uri = !url.endsWith("/") ? url + "/file/exists.do?path=" + tempPath : url + "file/exists.do?path=" + tempPath;
            get.setURI(new URI(uri));
            response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                HttpEntity httpEntity = response.getEntity();
                String respStr = EntityUtils.toString((HttpEntity)httpEntity, (String)UTF_8);
                throw new KDException(BosErrorCode.downloadFailed, new Object[]{respStr});
            }
            this.closeClientAndResponse(client, response);
            return;
        }
        catch (KDException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new KDException(BosErrorCode.downloadFailed, new Object[]{"Call AbstractFileService#checkServer error found: " + e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                this.closeClientAndResponse(client, response);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getFileSize(String path) {
        String httpUrlPrefix = this.getHttpUrlPrefix();
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        try {
            client = this.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
            HttpGet get = new HttpGet();
            this.setCookie(get);
            path = this.getFileServiceExt().getRealPath(path);
            path = FilePermissionManager.checkDownloadPath(path, this);
            path = URLEncoder.encode(path, UTF_8);
            String uri = !httpUrlPrefix.endsWith("/") ? httpUrlPrefix + "/file/getFileSize.do?path=" + path : httpUrlPrefix + "file/getFileSize.do?path=" + path;
            get.setURI(new URI(uri));
            response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                HttpEntity httpEntity = response.getEntity();
                String respStr = EntityUtils.toString((HttpEntity)httpEntity, (String)UTF_8);
                throw new KDException(BosErrorCode.downloadFailed, new Object[]{respStr});
            }
            String respStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)UTF_8);
            Map<String, String> responseMap = ResolveUtils.resolveJson(respStr);
            if (ERROR.equals(responseMap.get(STATUS))) {
                throw new KDException(BosErrorCode.downloadFailed, new Object[]{responseMap.get(DESCRIPTION)});
            }
            String data = responseMap.get("data");
            long l = Long.parseLong(data);
            this.closeClientAndResponse(client, response);
            return l;
        }
        catch (KDException e) {
            try {
                logger.error((Throwable)e);
                throw e;
                catch (Exception e2) {
                    logger.error((Throwable)e2);
                    throw new KDException((Throwable)e2, BosErrorCode.downloadFailed, new Object[]{String.format("call AbstractFileService#getFileSize err found, path: %s", path)});
                }
            }
            catch (Throwable throwable) {
                this.closeClientAndResponse(client, response);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportTempfile() {
        CloseableHttpResponse response;
        CloseableHttpClient client;
        block5: {
            client = null;
            response = null;
            String httpUrlPrefix = this.getHttpUrlPrefix();
            client = HttpFileClient.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
            HttpGet get = new HttpGet();
            this.setCookie(get);
            String uri = httpUrlPrefix + "/tempfile/isSupported.do";
            get.setURI(new URI(uri));
            response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) break block5;
            HttpEntity httpEntity = response.getEntity();
            String respStr = EntityUtils.toString((HttpEntity)httpEntity, (String)UTF_8);
            logger.error(respStr);
            boolean bl = false;
            this.closeClientAndResponse(client, response);
            return bl;
        }
        try {
            String respStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)UTF_8);
            Map<String, String> responseMap = ResolveUtils.resolveJson(respStr);
            String data = responseMap.get("data");
            boolean bl = data != null && data.equals("true");
            this.closeClientAndResponse(client, response);
            return bl;
        }
        catch (Exception e) {
            try {
                logger.error("Failed to get if the file server supports temporary files. ERROR_INFO: ", (Throwable)e);
                boolean bl = false;
                this.closeClientAndResponse(client, response);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeClientAndResponse(client, response);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportTempTransToPersist() {
        CloseableHttpResponse response;
        CloseableHttpClient client;
        block5: {
            client = null;
            response = null;
            String httpUrlPrefix = this.getHttpUrlPrefix();
            client = HttpFileClient.getHttpClient(this.getConfigKeyRegion(httpUrlPrefix));
            HttpGet get = new HttpGet();
            this.setCookie(get);
            String uri = httpUrlPrefix + "/tempfile/isSupportTempTransToPersist.do";
            get.setURI(new URI(uri));
            response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) break block5;
            HttpEntity httpEntity = response.getEntity();
            String respStr = EntityUtils.toString((HttpEntity)httpEntity, (String)UTF_8);
            logger.warn("isSupportTempTransToPersist status code isn't equal 200 ,because : " + respStr);
            boolean bl = false;
            this.closeClientAndResponse(client, response);
            return bl;
        }
        try {
            String respStr = EntityUtils.toString((HttpEntity)response.getEntity(), (String)UTF_8);
            Map<String, String> responseMap = ResolveUtils.resolveJson(respStr);
            String data = responseMap.get("data");
            boolean bl = data != null && data.equals("true");
            this.closeClientAndResponse(client, response);
            return bl;
        }
        catch (Exception e) {
            try {
                logger.error("Failed to get if the file server supports temporary files. ERROR_INFO: ", (Throwable)e);
                boolean bl = false;
                this.closeClientAndResponse(client, response);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeClientAndResponse(client, response);
                throw throwable;
            }
        }
    }

    @Override
    public List<TempTransResult> moveTempFile(List<FileItem> persistFileItems) {
        ArrayList<TempTransResult> resultList;
        block20: {
            String httpUrlPrefix = this.getHttpUrlPrefix();
            String httpTransTempUrlPrefix = httpUrlPrefix.endsWith("/") ? httpUrlPrefix + "file/transferTempToPersist.do" : httpUrlPrefix + "/file/transferTempToPersist.do";
            ArrayList persistFileMapList = new ArrayList();
            for (FileItem fileItem : persistFileItems) {
                boolean createNewFileWhenExists = fileItem.isCreateNewFileWhenExists();
                HashMap<String, String> persisFileMap = new HashMap<String, String>();
                String path = fileItem.getPath();
                String filename = (path = path.replaceAll("\\\\", "/")).substring(path.lastIndexOf(47) + 1);
                if (filename.lastIndexOf(".") <= 0) {
                    throw new KDException(BosErrorCode.uploadFailed, new Object[]{"upload file " + filename + Resources.getString((String)" failed. description: \u6587\u4ef6\u6269\u5c55\u540d\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractFileService_0", (String)BOS_FILESERVICE_SDK, (Object[])new Object[0])});
                }
                persisFileMap.put("version", FileServiceVersion.VERSION1.toString());
                persisFileMap.put("url", path.replaceAll("[=+%?&#]", "_"));
                persisFileMap.put("fileName", filename.replaceAll("[=+%?&#]", "_"));
                persisFileMap.put("createNewFileWhenExists", String.valueOf(createNewFileWhenExists));
                Map<String, String> tempFileMap = this.parseUrl(fileItem.getTempFileUrl());
                persisFileMap.put("tempFilePath", tempFileMap.get("id"));
                persistFileMapList.add(persisFileMap);
            }
            HashMap<String, String> arg = new HashMap<String, String>();
            String persistFileMapListStr = JSON.toJSONString(persistFileMapList);
            arg.put("persistFileMapListStr", persistFileMapListStr);
            arg.put("magic", "kdcomicinternal");
            CloseableHttpClient httpClient = null;
            CloseableHttpResponse result = null;
            String responseBody = "";
            resultList = new ArrayList<TempTransResult>();
            try {
                String headerStr = ResolveUtils.resolveJson(arg);
                httpClient = this.getHttpClient(httpTransTempUrlPrefix);
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.uploadTimeout * 1000).setSocketTimeout(this.uploadTimeout * 1000).build();
                HttpPost httpPost = new HttpPost(httpTransTempUrlPrefix);
                httpPost.setConfig(requestConfig);
                httpPost.setEntity((HttpEntity)new StringEntity(headerStr, "UTF-8"));
                if (this.needAuth()) {
                    httpPost.addHeader(COOKIE, "ticket=" + this.getTicket());
                }
                if ((result = httpClient.execute((HttpUriRequest)httpPost)) != null) {
                    if (result.getStatusLine().getStatusCode() == 200) {
                        HttpEntity entity = result.getEntity();
                        if (entity != null) {
                            responseBody = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                            List response = (List)JSON.parseObject((String)responseBody, List.class);
                            for (Map mapItem : response) {
                                String path = (String)mapItem.get("path");
                                path = this.getFileServiceExt().save(path);
                                String msg = (String)mapItem.get("msg");
                                String resultStr = (String)mapItem.get("result");
                                if (!resultStr.equals("success")) {
                                    logger.error("trans error: " + msg);
                                }
                                TempTransResult tempTransResult = new TempTransResult("success".equalsIgnoreCase(resultStr), path, msg);
                                resultList.add(tempTransResult);
                            }
                            break block20;
                        }
                        throw new KDException(BosErrorCode.uploadFailed, new Object[]{"trans failed. response is empty"});
                    }
                    HttpEntity resEntity = result.getEntity();
                    String respStr = EntityUtils.toString((HttpEntity)resEntity, (String)UTF_8);
                    logger.error("trans error: " + respStr);
                    throw new KDException(BosErrorCode.uploadFailed, new Object[]{respStr});
                }
                String msg = String.format("trans temp failed,upload timeout within %s seconds, persistFileItems:%s, response:", this.uploadTimeout, persistFileMapListStr, responseBody);
                throw new KDException(BosErrorCode.uploadFailed, new Object[]{BosErrorCode.uploadFailed, msg});
            }
            catch (KDException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = String.format("trans temp failed: persistFileItems:%s", persistFileMapListStr);
                throw new KDException((Throwable)e, BosErrorCode.uploadFailed, new Object[]{msg});
            }
            finally {
                try {
                    if (httpClient != null) {
                        httpClient.close();
                    }
                    if (result != null) {
                        result.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        return resultList;
    }

    protected Map<String, String> parseUrl(String url) {
        String[] pairstr = url.split("\\?");
        String[] pairs = pairstr[1].split("&");
        HashMap<String, String> m = new HashMap<String, String>(pairs.length);
        for (String pair : pairs) {
            String[] p = pair.split("=");
            m.put(p[0], p[1]);
        }
        return m;
    }

    private SSLConnectionSocketFactory getSslConnectionSocketFactory(String keyRegion) {
        SSLConnectionSocketFactory scsf;
        block16: {
            String keystorePath = this.getProperty(FILESERVER_SSL_KEYSTORE_KEY, keyRegion);
            String keystorePass = this.getProperty(FILESERVER_SSL_KEYPASS_KEY, keyRegion);
            boolean sslTrust = StringUtils.isEmpty((String)keystorePath) && StringUtils.isEmpty((String)keystorePass);
            try {
                if (!sslTrust) {
                    KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    try (FileInputStream ins = new FileInputStream(FilenameUtils.normalize((String)keystorePath));){
                        keystorePass = Encrypters.decode((String)keystorePass);
                        trustStore.load(ins, keystorePass.toCharArray());
                    }
                    SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore, null).build();
                    scsf = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
                    break block16;
                }
                scsf = new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDException(BosErrorCode.fileserviceException, new Object[]{e});
            }
        }
        return scsf;
    }

    private String getProperty(String key, String region) {
        String value = System.getProperty(key + "." + region);
        if (StringUtils.isEmpty((String)value)) {
            return System.getProperty(key);
        }
        return value;
    }

    protected String getConfigKeyRegion(String url) {
        String region;
        try {
            URL u = new URL(url);
            String host = u.getHost();
            region = host.replaceAll("\\.", "_");
        }
        catch (Exception e) {
            region = "";
        }
        return region;
    }

    static {
        picSuffixes.addAll(Arrays.asList("jpg,jpeg,png,gif,bmp,tiff,tga,ico,dib,rle,emf,jpe,jfif,pcx,pic,tif,wmf,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,hdri,ai,raw".split(",")));
        logger = LogFactory.getLog(AbstractFileService.class);
    }
}

