/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fileservice.impl;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;

public enum FileServiceVersion {
    VERSION0("v0.0"),
    VERSION1("v1.0"),
    VERSION5("v5.0");

    private String versionNumber;

    private FileServiceVersion(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String toString() {
        return this.versionNumber;
    }

    public static FileServiceVersion getValueOf(String versionNumber) {
        FileServiceVersion[] types;
        FileServiceVersion result = null;
        for (FileServiceVersion type : types = FileServiceVersion.values()) {
            if (!type.versionNumber.equals(versionNumber)) continue;
            result = type;
        }
        return result;
    }

    public static FileServiceVersion getLatestVersion() {
        FileServiceVersion[] types = FileServiceVersion.values();
        FileServiceVersion latestVersion = VERSION0;
        for (FileServiceVersion version : types) {
            if (version.myCompareTo(latestVersion) != 1) continue;
            latestVersion = version;
        }
        return latestVersion;
    }

    public int myCompareTo(FileServiceVersion anotherVersion) {
        if (anotherVersion == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"FileServiceVersion can not be null!"});
        }
        Double v1 = Double.parseDouble(this.toString().substring(1));
        Double v2 = Double.parseDouble(anotherVersion.toString().substring(1));
        return Double.compare(v1, v2);
    }
}

